/*
 * Decompiled with CFR 0.152.
 */
package jet.datasource.hds;

import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jet.datasource.hds.ArrayImpl;
import jet.datasource.hds.HDSElementNode;
import jet.log.JRLogger;
import jet.universe.engine.UFakeHDSColumn;
import jet.xml.model.AttValuesNode;

public class DataProcessor {
    Format QOIV;
    private Hashtable append = null;
    boolean[] booleanValue;
    byte[] class$;
    short[] doubleValue;
    int[] elementAt;
    long[] error;
    float[] floatValue;
    double[] forName;
    BigDecimal[] get;
    Date[] getColIndex;
    Time[] getColumnName;
    Timestamp[] getFormat;
    String[] getLogger;
    ArrayImpl[] getMessage;
    int getName = 0;
    int getSqlType = -1;
    private static JRLogger getTime = JRLogger.getLogger((class$jet$datasource$hds$DataProcessor == null ? (class$jet$datasource$hds$DataProcessor = DataProcessor.class$("jet.datasource.hds.DataProcessor")) : class$jet$datasource$hds$DataProcessor).getName());
    static Class class$jet$datasource$hds$DataProcessor;

    public DataProcessor() {
    }

    public DataProcessor(Hashtable hashtable, Vector[] vectorArray) {
        this.getName = hashtable.size() + 1;
        this.class$();
        this.append = new Hashtable(this.getName);
        this.QOIV(hashtable, vectorArray);
    }

    void QOIV(Hashtable hashtable, Vector[] vectorArray) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            UFakeHDSColumn uFakeHDSColumn = (UFakeHDSColumn)enumeration.nextElement();
            Object v = hashtable.get(uFakeHDSColumn);
            if (v instanceof Boolean) {
                this.append.put(new Integer(uFakeHDSColumn.getColIndex()), new Boolean(true));
                continue;
            }
            this.append(uFakeHDSColumn);
            try {
                if (uFakeHDSColumn.isArray()) {
                    this.booleanValue(uFakeHDSColumn, vectorArray[uFakeHDSColumn.getColIndex()]);
                    continue;
                }
                if (v instanceof HDSElementNode) {
                    this.booleanValue(uFakeHDSColumn, ((HDSElementNode)v).getValue());
                    continue;
                }
                this.booleanValue(uFakeHDSColumn, ((AttValuesNode)v).getValues());
            }
            catch (ParseException parseException) {
                if (!getTime.isErrorEnabled()) continue;
                getTime.error("XML Data Parse Error to Column " + uFakeHDSColumn.getColumnName() + '\n' + parseException.toString(), parseException);
            }
            catch (NumberFormatException numberFormatException) {
                if (!getTime.isErrorEnabled()) continue;
                getTime.error("XML Data Parse Error to Column " + uFakeHDSColumn.getColumnName() + '\n' + numberFormatException.toString(), numberFormatException);
            }
        }
    }

    void append(UFakeHDSColumn uFakeHDSColumn) {
        int n = uFakeHDSColumn.getSqlType();
        String string = uFakeHDSColumn.getFormat();
        if (n == 91 || n == 92 || n == 93) {
            this.QOIV = new SimpleDateFormat(string);
        } else if (n == 5 || n == 4 || n == -5 || n == 6 || n == 7 || n == 8 || n == 2 || n == 3) {
            this.QOIV = new DecimalFormat(string);
        }
    }

    void booleanValue(UFakeHDSColumn uFakeHDSColumn, Vector vector) throws ParseException, NumberFormatException {
        int n = uFakeHDSColumn.getSqlType();
        String string = null;
        int n2 = uFakeHDSColumn.getColIndex();
        if (vector == null || vector.size() <= 0) {
            this.append.put(new Integer(n2), new Boolean(true));
            return;
        }
        if (uFakeHDSColumn.isArray()) {
            this.getMessage[n2] = new ArrayImpl(n, this.QOIV);
            this.getMessage[n2].setValue(vector);
        } else {
            string = (String)vector.elementAt(0);
            if (string == null || string.trim().length() == 0) {
                this.append.put(new Integer(n2), new Boolean(true));
                return;
            }
            String string2 = string;
            string = string.trim();
            switch (n) {
                case -7: {
                    this.booleanValue[n2] = new Boolean(string);
                    break;
                }
                case -6: {
                    this.class$[n2] = Byte.parseByte(string);
                    break;
                }
                case 5: {
                    this.doubleValue[n2] = this.QOIV == null ? Short.parseShort(string) : ((Number)this.QOIV.parseObject(string)).shortValue();
                    break;
                }
                case 4: {
                    this.elementAt[n2] = this.QOIV == null ? Integer.parseInt(string) : ((Number)this.QOIV.parseObject(string)).intValue();
                    break;
                }
                case -5: {
                    this.error[n2] = this.QOIV == null ? Long.parseLong(string) : ((Number)this.QOIV.parseObject(string)).longValue();
                    break;
                }
                case 6: 
                case 7: {
                    this.floatValue[n2] = (this.QOIV == null ? (Number)Float.valueOf(string) : (Number)((Number)this.QOIV.parseObject(string))).floatValue();
                    break;
                }
                case 8: {
                    this.forName[n2] = (this.QOIV == null ? (Number)Double.valueOf(string) : (Number)((Number)this.QOIV.parseObject(string))).doubleValue();
                    break;
                }
                case 2: 
                case 3: {
                    this.get[n2] = this.QOIV == null ? new BigDecimal(string) : new BigDecimal(((Number)this.QOIV.parseObject(string)).toString());
                    break;
                }
                case 91: {
                    java.util.Date date = this.QOIV == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.QOIV).parse(string);
                    this.getColIndex[n2] = new Date(date.getTime());
                    break;
                }
                case 92: {
                    java.util.Date date = this.QOIV == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.QOIV).parse(string);
                    this.getColumnName[n2] = new Time(date.getTime());
                    break;
                }
                case 93: {
                    java.util.Date date = this.QOIV == null ? new SimpleDateFormat().parse(string) : ((SimpleDateFormat)this.QOIV).parse(string);
                    this.getFormat[n2] = new Timestamp(date.getTime());
                    break;
                }
                case -1: 
                case 1: 
                case 12: {
                    this.getLogger[n2] = string2;
                }
            }
        }
    }

    void class$() {
        this.booleanValue = new boolean[this.getName];
        this.class$ = new byte[this.getName];
        this.doubleValue = new short[this.getName];
        this.elementAt = new int[this.getName];
        this.error = new long[this.getName];
        this.floatValue = new float[this.getName];
        this.forName = new double[this.getName];
        this.get = new BigDecimal[this.getName];
        this.getColIndex = new Date[this.getName];
        this.getColumnName = new Time[this.getName];
        this.getFormat = new Timestamp[this.getName];
        this.getLogger = new String[this.getName];
        this.getMessage = new ArrayImpl[this.getName];
    }

    public void clear() {
        this.booleanValue = null;
        this.class$ = null;
        this.doubleValue = null;
        this.elementAt = null;
        this.error = null;
        this.floatValue = null;
        this.forName = null;
        this.get = null;
        this.getColIndex = null;
        this.getColumnName = null;
        this.getFormat = null;
        this.getLogger = null;
        this.getMessage = null;
        this.QOIV = null;
    }

    public boolean getBooleanValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return false;
        }
        return this.booleanValue[n];
    }

    public byte getByteValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return 0;
        }
        return this.class$[n];
    }

    public short getShortValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return 0;
        }
        return this.doubleValue[n];
    }

    public int getIntValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return 0;
        }
        return this.elementAt[n];
    }

    public long getLongValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return 0L;
        }
        return this.error[n];
    }

    public float getFloatValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return 0.0f;
        }
        return this.floatValue[n];
    }

    public double getDoubleValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return 0.0;
        }
        return this.forName[n];
    }

    public BigDecimal getBigDecimalValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return null;
        }
        return this.get[n];
    }

    public Date getDateValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return null;
        }
        return this.getColIndex[n];
    }

    public Time getTimeValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return null;
        }
        return this.getColumnName[n];
    }

    public Timestamp getTimestampValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return null;
        }
        return this.getFormat[n];
    }

    public String getStringValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return null;
        }
        return this.getLogger[n];
    }

    public Array getArrayValue(int n) {
        this.getSqlType = n;
        if (this.isNull()) {
            return null;
        }
        return this.getMessage[n];
    }

    public boolean isNull() {
        if (this.append.isEmpty() || this.append.get(new Integer(this.getSqlType)) == null) {
            return false;
        }
        return (Boolean)this.append.get(new Integer(this.getSqlType));
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

