/*
 * Decompiled with CFR 0.152.
 */
package jet.export.text;

import com.jinfonet.util.JRLog;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.StringTokenizer;
import jet.JRStopEngineException;
import jet.bean.TextParameter;
import jet.datastream.DSBody;
import jet.datastream.DSField;
import jet.datastream.DSPage;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.datastream.DSReference;
import jet.datastream.DSSection;
import jet.datastream.DSSubReport;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.RenderText;
import jet.export.AbstractExporter;
import jet.export.util.CCUtil;
import jet.util.Propertiable;

abstract class SDFTextBase
extends AbstractExporter {
    public static final String EXP = ".txt";
    protected static final String CSV = ".csv";
    protected static String lineSeparator = System.getProperty("line.separator");
    protected char delimiter = (char)32;
    protected char quoteMark = (char)34;
    protected boolean forWin;
    protected boolean hasHeadFoot = true;
    protected boolean hasSetSystem;
    protected boolean isCompress;
    protected boolean isRepeat;
    protected boolean isCSV;
    protected boolean useQuoteMark = true;
    protected boolean useDelimiter;
    protected PrintWriter textwriter;

    SDFTextBase() {
    }

    protected void getParameters(TextParameter textParameter) {
        this.QOIV(textParameter.isForWinExport());
        this.hasHeadFoot = textParameter.isHasHeadFoot();
        this.isCompress = textParameter.isCompress();
        this.isRepeat = textParameter.isRepeat();
        this.useDelimiter = textParameter.isUseDelimiter();
        if (this.useDelimiter) {
            this.setDelimiter(textParameter.getDelimiter());
        }
        this.useQuoteMark = textParameter.isUseQuoteMark();
        if (JRLog.isTrace(5)) {
            JRLog.indent("sdf text parameters");
            JRLog.trace(5, 5402101, "" + textParameter.isHasHeadFoot());
            JRLog.trace(5, 5402102, "" + textParameter.isForWinExport());
            JRLog.trace(5, 5402103, "" + textParameter.getResolution());
            JRLog.trace(5, 5402104, "" + textParameter.isUseQuoteMark());
            JRLog.trace(5, 5402105, "" + textParameter.isCompress());
            JRLog.trace(5, 5402106, "" + textParameter.getDelimiter() + "flag(" + this.useDelimiter + ")");
            JRLog.trace(5, 5402107, "" + textParameter.isRepeat());
            JRLog.deIndent("sdf text parameters");
        }
    }

    protected void free() {
    }

    protected void setDelimiter(char c) {
        this.delimiter = c;
        if (c == ',') {
            this.isCSV = true;
        }
    }

    private void QOIV(boolean bl) {
        this.forWin = bl;
        this.hasSetSystem = true;
    }

    protected void publish(BufferedOutputStream bufferedOutputStream) throws IOException, JRStopEngineException {
        this.waitCommunicator();
        String string = this._commu.getEncoding();
        if (string == null) {
            string = "UTF-8";
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, 5402006);
            }
        }
        this.textwriter = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, string));
    }

    protected void writePage(DSPage dSPage, boolean bl) {
        int n = dSPage.size();
        int n2 = 0;
        while (n2 < n) {
            JRObjectResult jRObjectResult = dSPage.getObject(n2);
            jRObjectResult = this.getFactOject(jRObjectResult);
            int n3 = jRObjectResult.getObjectType();
            if (this.canExportToCSV(jRObjectResult)) {
                if ((n3 & 0x200) == 512) {
                    this.writeSection((DSSection)jRObjectResult, 0, bl);
                } else if (n3 == 262177) {
                    this.writeBody((DSBody)jRObjectResult, 0, bl);
                }
            }
            ++n2;
        }
    }

    protected final JRObjectResult getFactOject(JRObjectResult jRObjectResult) {
        JRObjectResult jRObjectResult2 = jRObjectResult;
        int n = jRObjectResult.getObjectType();
        while (n == 8192) {
            jRObjectResult2 = ((DSReference)jRObjectResult2).getRefData();
            n = jRObjectResult2.getObjectType();
        }
        return jRObjectResult2;
    }

    protected abstract void writeSection(DSSection var1, int var2, boolean var3);

    protected abstract void writeBody(DSBody var1, int var2, boolean var3);

    protected String getParagraphValue(DSParagraph dSParagraph) {
        List list = this.zOrder(dSParagraph.getChildren());
        int n = list.size();
        String string = "";
        if (n > 0) {
            int n2 = 0;
            while (n2 < n) {
                JRObjectResult jRObjectResult = (JRObjectResult)list.get(n2);
                if (this.canExportToCSV(jRObjectResult)) {
                    String string2;
                    Object object;
                    JRVisiableResult jRVisiableResult;
                    if (jRObjectResult instanceof DSParagraphText) {
                        jRVisiableResult = (DSParagraphText)jRObjectResult;
                        object = ((DSParagraphText)jRVisiableResult).getText();
                        if (object != null) {
                            string = string + (String)object;
                        }
                    } else if (jRObjectResult instanceof DSField && (object = ((DSField)(jRVisiableResult = (DSField)jRObjectResult)).getRender()) instanceof RenderText && (string2 = ((DSField)jRVisiableResult).toString()) != null) {
                        string = string + string2;
                    }
                }
                ++n2;
            }
        }
        return string;
    }

    protected final boolean canExportToCSV(JRObjectResult jRObjectResult) {
        boolean bl = jRObjectResult instanceof JRVisiableResult;
        if (bl) {
            int n = jRObjectResult.getObjectType();
            if (n == 40) {
                return false;
            }
            if (n == 128) {
                return false;
            }
            if (n == 71) {
                return false;
            }
            boolean bl2 = bl = !this._commu(jRObjectResult, "Invisible") && this._commu(jRObjectResult, "ExportToCSV");
            if (bl) {
                if (jRObjectResult.getObjectType() == 262178) {
                    bl = true;
                } else if (((JRVisiableResult)jRObjectResult).getWidth() <= 0 || ((JRVisiableResult)jRObjectResult).getHeight() <= 0) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2402104, String.valueOf(((JRVisiableResult)jRObjectResult).getObjectType()));
                        JRLog.error(2, 2402105, ((JRVisiableResult)jRObjectResult).getWidth() + "*" + ((JRVisiableResult)jRObjectResult).getHeight());
                    }
                    bl = false;
                }
            }
            if (bl) {
                switch (n) {
                    case 513: 
                    case 514: 
                    case 515: 
                    case 516: 
                    case 517: 
                    case 518: 
                    case 2561: 
                    case 2562: 
                    case 2563: 
                    case 2564: {
                        bl = this.hasHeadFoot;
                        break;
                    }
                    case 34: {
                        break;
                    }
                    case 33: 
                    case 37: {
                        bl = !((DSSubReport)jRObjectResult).isError();
                        break;
                    }
                    case 264: {
                        bl = false;
                        break;
                    }
                }
            }
        }
        return bl;
    }

    protected final String prepareText(String string) {
        boolean bl = false;
        String string2 = "";
        if (string != null && string.length() > 0) {
            if (this.useDelimiter && string.indexOf(this.delimiter) >= 0) {
                bl = true;
            }
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",\"", true);
            String string3 = null;
            while (stringTokenizer.hasMoreTokens()) {
                string3 = stringTokenizer.nextToken();
                if (",".equals(string3)) {
                    bl = true;
                    stringBuffer.append(",");
                    continue;
                }
                if ("\"".equals(string3)) {
                    bl = true;
                    stringBuffer.append("\"\"");
                    continue;
                }
                stringBuffer.append(string3);
            }
            string2 = stringBuffer.toString();
            if (bl && !this.useQuoteMark) {
                string2 = this.quoteMark + string2 + this.quoteMark;
            }
        }
        return string2;
    }

    protected final void addLineSeparator(StringBuffer stringBuffer) {
        if (this.hasSetSystem) {
            if (this.forWin) {
                stringBuffer.append("\r\n");
            } else {
                stringBuffer.append("\n");
            }
        } else {
            stringBuffer.append(lineSeparator);
        }
    }

    protected final List zOrder(List list) {
        return list;
    }

    private boolean _commu(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    protected boolean isTextField(DSField dSField) {
        Propertiable propertiable = dSField.getPropertyByName("renderType");
        if (propertiable != null) {
            int n = (Integer)propertiable.getObject();
            return n == 0 || n == 4;
        }
        return true;
    }

    protected void waitCommunicator() {
        long l = System.currentTimeMillis();
        this._commu.waitFinished();
        long l2 = System.currentTimeMillis();
        if (JRLog.isTrace(4)) {
            JRLog.trace(2, "Wait communicator times:(" + (l2 - l) + ")");
        }
    }
}

