/*
 * Decompiled with CFR 0.152.
 */
package jet.export.util;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.PixelGrabber;
import jet.export.util.ExportUtil;

public class ImageGrabber {
    private int QOIV;
    private int WHITE;
    private boolean createGraphics = false;
    private Image dispose;
    private int[] drawImage = null;
    boolean fillRect = false;

    public ImageGrabber(Image image) {
        this.dispose = image;
        ExportUtil.waitImage(this.dispose);
        this.QOIV = image.getWidth(null);
        this.WHITE = image.getHeight(null);
        if (this.dispose instanceof BufferedImage) {
            this.fillRect = true;
        }
    }

    public boolean processImage() {
        if (this.fillRect) {
            this.createGraphics = ((BufferedImage)this.dispose).getColorModel().hasAlpha();
            return true;
        }
        ExportUtil.waitImage(this.dispose);
        this.drawImage = new int[this.QOIV * this.WHITE];
        PixelGrabber pixelGrabber = new PixelGrabber(this.dispose, 0, 0, this.QOIV, this.WHITE, this.drawImage, 0, this.QOIV);
        boolean bl = false;
        try {
            bl = pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            bl = false;
            interruptedException.printStackTrace();
        }
        ColorModel colorModel = pixelGrabber.getColorModel();
        this.createGraphics = colorModel == null ? false : colorModel.hasAlpha();
        return bl;
    }

    public BufferedImage convertToBufferedImage(boolean bl) {
        if (this.dispose instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)this.dispose;
            int n = bufferedImage.getType();
            if (bl) {
                if (n == 2 || n == 3) {
                    return bufferedImage;
                }
                n = 2;
            } else {
                if (n == 1 || n == 4 || n == 5 || n == 9 || n == 8 || n == 9) {
                    return bufferedImage;
                }
                n = 1;
            }
            bufferedImage = new BufferedImage(this.QOIV, this.WHITE, n);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            if (!bl) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.fillRect(0, 0, this.QOIV, this.WHITE);
            }
            graphics2D.drawImage(this.dispose, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage;
        }
        int n = 1;
        if (bl) {
            n = 2;
        }
        BufferedImage bufferedImage = new BufferedImage(this.QOIV, this.WHITE, n);
        bufferedImage.setRGB(0, 0, this.QOIV, this.WHITE, this.drawImage, 0, this.QOIV);
        return bufferedImage;
    }

    public boolean hasAlpha() {
        return this.createGraphics;
    }

    public int getHeight() {
        return this.WHITE;
    }

    public int getWidth() {
        return this.QOIV;
    }

    public Image getImage() {
        return this.dispose;
    }

    public boolean isBufferedImage() {
        return this.fillRect;
    }
}

