/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import java.util.Vector;
import jet.controls.JetBoolean;
import jet.controls.JetColumnVector;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.controls.JetVector;
import jet.dataengine.groupengine.GroupConstant;
import jet.dataengine.groupengine.GroupModel;
import jet.dataengine.groupengine.RangGroupBreaker;
import jet.naming.EnumerationConstant;
import jet.report.chart.JetChartElement;
import jet.reportLogic.objectInfo.AdvanceOption;
import jet.reportLogic.objectInfo.GroupInfo;
import jet.reportLogic.objectInfo.SortInfo;
import jet.reportLogic.objectInfo.SpecifieldDesc;
import jet.reportLogic.objectInfo.SpecifieldOption;

public class JetChartGroupInfo
extends JetChartElement {
    public JetString groupOrder = null;
    public JetNumber groupType = null;
    public JetVector sortBy = null;
    public JetVector sortOrder = null;
    public JetVector specNames = null;
    public JetVector specOperators = null;
    public JetVector specOprands = null;
    public JetVector specOpNum = null;
    public JetBoolean keepOthers = null;
    public JetString othersName = null;
    public JetEnumeration selectType = null;
    public JetNumber selectN = null;
    public JetNumber selectStartPosition = null;

    public JetChartGroupInfo(JetObject jetObject, String string) {
        super(jetObject, string);
        this.groupOrder = new JetString(jetObject, string + "GroupOrder");
        this.groupOrder.set(GroupModel.getStringForOrder(0));
        this.groupType = new JetNumber(jetObject, string + "GroupType", 0);
        this.sortBy = new JetColumnVector(jetObject, string + "SortBy");
        this.sortOrder = new JetVector(jetObject, string + "SortOrder");
        this.specNames = new JetVector(jetObject, string + "SpecialNames");
        this.specOperators = new JetVector(jetObject, string + "SpecialOperators");
        this.specOprands = new JetVector(jetObject, string + "SpecialOperands");
        this.specOpNum = new JetVector(jetObject, string + "SpecialOpNum");
        this.keepOthers = new JetBoolean(jetObject, string + "KeepOthers", false);
        this.othersName = new JetString(jetObject, string + "OthersName", "Others");
        this.selectType = new JetEnumeration(jetObject, string + "SelectType", 87);
        this.selectN = new JetNumber(jetObject, string + "SelectN", -1);
        this.selectStartPosition = new JetNumber(jetObject, string + "SelectStartPosition", 1);
        this.selectType.set(EnumerationConstant.SELECTTYPE_STR_NAMES[0]);
    }

    public String getGroupName() {
        return null;
    }

    public void setGroupInfo(GroupInfo groupInfo) {
        int n = groupInfo.getSortType();
        String string = GroupConstant.getStringForOrder(n);
        if (string != null) {
            this.groupOrder.set(string);
            this.groupType.set(0);
            this.clearSpecifieldOption();
            this.QOIV(groupInfo.getAdvOption());
        } else {
            this.SELECTTYPE_STR_NAMES();
            this.add(groupInfo.getSpecOption());
        }
        Vector vector = groupInfo.getSortInfos();
        this.sortBy.clear();
        this.sortOrder.clear();
        int n2 = vector.size();
        if (n2 > 0) {
            int n3 = 0;
            while (n3 < vector.size()) {
                SortInfo sortInfo = (SortInfo)vector.get(n3);
                this.sortBy.add(sortInfo.getFieldName());
                int n4 = sortInfo.getSortType();
                String string2 = GroupConstant.getStringForOrder(n4);
                this.sortOrder.add(string2);
                ++n3;
            }
            this.groupType.set(1);
        }
    }

    private void QOIV(AdvanceOption advanceOption) {
        if (advanceOption == null) {
            return;
        }
        this.keepOthers.set(advanceOption.isKeepOthers());
        this.othersName.set(advanceOption.getOtherName());
        String string = advanceOption.getParameterNameForSelectN();
        this.selectType.set(advanceOption.getSelectType());
        if (string != null) {
            this.selectN.setChangeByObject(string);
        } else {
            int n = advanceOption.getSelectN();
            this.selectN.setChangeByObject(null);
            this.selectN.set(n);
        }
        this.selectStartPosition.set(advanceOption.getSelectStartPosition());
    }

    private void SELECTTYPE_STR_NAMES() {
        this.othersName.set("");
        this.selectType.set("");
        if (this.selectN.isChangeByOther()) {
            this.selectN.setChangeByObject(null);
        }
        this.selectN.set(-1);
        this.selectStartPosition.set(-1);
    }

    private void add(SpecifieldOption specifieldOption) {
        if (specifieldOption == null) {
            return;
        }
        String string = specifieldOption.getOtherName();
        this.keepOthers.set(specifieldOption.isKeepOthers());
        this.othersName.set(string);
        Vector vector = specifieldOption.getSpecifieldDescs();
        if (vector != null && vector.size() > 0) {
            this.groupOrder.set("");
            this.groupType.set(2);
        }
        this.specNames.clear();
        this.specOperators.clear();
        this.specOpNum.clear();
        this.specOprands.clear();
        int n = 0;
        int n2 = vector.size();
        while (n < n2) {
            Vector vector2;
            int n3;
            SpecifieldDesc specifieldDesc = (SpecifieldDesc)vector.get(n);
            this.specNames.add(specifieldDesc.getGroupName());
            int n4 = specifieldDesc.getOperator();
            String string2 = RangGroupBreaker.getPresentationName(n4);
            if (string2 != null) {
                this.specOperators.add(string2);
            }
            if ((n3 = (vector2 = specifieldDesc.getOperands()).size()) > 0) {
                this.specOpNum.add("" + n3);
                int n5 = 0;
                while (n5 < n3) {
                    this.specOprands.add(vector2.get(n5).toString());
                    ++n5;
                }
            }
            ++n;
        }
    }

    public void clearSpecifieldOption() {
        this.specNames.clear();
        this.specOperators.clear();
        this.specOpNum.clear();
        this.specOprands.clear();
    }

    public GroupInfo getGroupInfo() {
        int n = this.groupType.get();
        String string = this.groupOrder.get();
        int n2 = n == 2 ? -1 : GroupConstant.getOrderForString(string);
        GroupInfo groupInfo = new GroupInfo(null, null, n2);
        if (n2 != -1) {
            groupInfo.setAdvOption(this.append());
        } else {
            groupInfo.setSpecOption(this.getSpecOption());
        }
        groupInfo.setSortInfos(this.getSortInfos());
        return groupInfo;
    }

    public Vector getSortInfos() {
        Vector<SortInfo> vector = new Vector<SortInfo>();
        Vector vector2 = this.sortBy.get();
        Vector vector3 = this.sortOrder.get();
        int n = 0;
        int n2 = vector2.size();
        while (n < n2) {
            String string = (String)vector2.get(n);
            String string2 = (String)vector3.get(n);
            int n3 = GroupConstant.getOrderForString(string2);
            SortInfo sortInfo = new SortInfo(string, n3);
            vector.add(sortInfo);
            ++n;
        }
        return vector;
    }

    public SpecifieldOption getSpecOption() {
        String string = null;
        if (this.keepOthers.get()) {
            string = this.othersName.get();
        }
        SpecifieldOption specifieldOption = new SpecifieldOption(string);
        specifieldOption.setKeepOthers(this.keepOthers.get());
        Vector vector = this.specNames.get();
        Vector vector2 = this.specOperators.get();
        Vector vector3 = this.specOpNum.get();
        Vector vector4 = this.specOprands.get();
        Vector<SpecifieldDesc> vector5 = new Vector<SpecifieldDesc>();
        int n = 0;
        int n2 = 0;
        int n3 = vector.size();
        while (n < n3) {
            String string2 = (String)vector.get(n);
            String string3 = (String)vector2.get(n);
            int n4 = RangGroupBreaker.getOperatorByName(string3);
            int n5 = Integer.parseInt((String)vector3.get(n));
            Vector vector6 = new Vector();
            int n6 = 0;
            while (n6 < n5) {
                vector6.add(vector4.get(n2 + n6));
                ++n6;
            }
            n2 += n5;
            SpecifieldDesc specifieldDesc = new SpecifieldDesc(string2, n4, vector6);
            vector5.add(specifieldDesc);
            ++n;
        }
        specifieldOption.setSpecifieldDescs(vector5);
        return specifieldOption;
    }

    private AdvanceOption append() {
        AdvanceOption advanceOption = new AdvanceOption();
        String string = this.othersName.get();
        advanceOption.setKeepOthers(this.keepOthers.get());
        if (advanceOption.isKeepOthers()) {
            advanceOption.setOtherName(string);
        }
        advanceOption.setSelectType(this.selectType.getCurKey());
        advanceOption.setSelectStartPosition(this.selectStartPosition.get());
        advanceOption.setSelectN(this.selectN.get());
        advanceOption.setParameterNameForSelectN(this.selectN.getChangeByObjectName());
        return advanceOption;
    }

    public boolean hasGroupInfo() {
        return this.groupOrder.get() != null && !this.groupOrder.get().equals(GroupModel.getStringForOrder(0)) || this.sortBy.get() != null && this.sortBy.get().size() != 0 || this.keepOthers.get() || this.selectN.getChangeByObjectName() != null || this.selectN.get() != -1;
    }
}

