/*
 * Decompiled with CFR 0.152.
 */
package jet.report.chart;

import chart.properties.ChartAxisProperties;
import chart.properties.ChartNumericAxisProperties;
import jet.controls.JetBoolean;
import jet.controls.JetDoubleNumber;
import jet.controls.JetEnumeration;
import jet.controls.JetNumber;
import jet.controls.JetObject;
import jet.report.chart.JetChartCategoryAxisProperties;

public class JetChartNumericAxisProperties
extends JetChartCategoryAxisProperties {
    public JetDoubleNumber maxValue;
    public JetDoubleNumber minValue;
    public JetNumber numOfTickMarks;
    public JetDoubleNumber increment;
    public JetDoubleNumber labelStartValue;
    public JetBoolean useLabelStartValue;
    public JetEnumeration labelPosition;

    JetChartNumericAxisProperties(JetObject jetObject, String string) {
        super(jetObject, string);
        this.maxValue = new JetDoubleNumber(jetObject, this.prefix + "MaxValue", 0);
        this.minValue = new JetDoubleNumber(jetObject, this.prefix + "MinValue", 0);
        this.numOfTickMarks = new JetNumber(jetObject, this.prefix + "NumOfTickMarks", -1);
        this.increment = new JetDoubleNumber(jetObject, this.prefix + "Increment", -1);
        this.labelStartValue = new JetDoubleNumber(jetObject, this.prefix + "LabelStartValue", 0);
        this.useLabelStartValue = new JetBoolean(jetObject, this.prefix + "UseLabelStartValue", false);
        this.labelPosition = new JetEnumeration(jetObject, this.prefix + "LabelPosition");
        this.labelPosition.add("outside", new Integer(0));
        this.labelPosition.add("inside", new Integer(1));
        this.labelPosition.set("outside");
    }

    public void addToGroup(String string) {
        super.addToGroup(string);
        if (string != null) {
            this.owner.addPropertyToGroup(this.prefix + "MaxValue", string);
            this.owner.addPropertyToGroup(this.prefix + "MinValue", string);
            this.owner.addPropertyToGroup(this.prefix + "NumOfTickMarks", string);
            this.owner.addPropertyToGroup(this.prefix + "Increment", string);
            if (!this.prefix.equals("AxisX")) {
                this.owner.addPropertyToGroup(this.prefix + "UseLabelStartValue", string);
                this.owner.addPropertyToGroup(this.prefix + "LabelStartValue", string);
            }
            this.owner.addPropertyToGroup(this.prefix + "LabelPosition", string);
        }
    }

    public void addToGroup2(String string) {
        super.addToGroup(string);
        if (string != null) {
            this.owner.addPropertyToGroup(this.prefix + "MaxValue", string);
            this.owner.addPropertyToGroup(this.prefix + "MinValue", string);
            this.owner.addPropertyToGroup(this.prefix + "NumOfTickMarks", string);
            this.owner.addPropertyToGroup(this.prefix + "Increment", string);
            this.owner.addPropertyToGroup(this.prefix + "UseLabelStartValue", string);
            this.owner.addPropertyToGroup(this.prefix + "LabelStartValue", string);
            this.owner.addPropertyToGroup(this.prefix + "LabelPosition", string);
        }
    }

    public ChartAxisProperties getChartAxisProperties() {
        ChartNumericAxisProperties chartNumericAxisProperties = new ChartNumericAxisProperties();
        super.toChartAxisProperties(chartNumericAxisProperties);
        chartNumericAxisProperties.setMaxValue(this.maxValue.doubleValue());
        chartNumericAxisProperties.setMinValue(this.minValue.doubleValue());
        chartNumericAxisProperties.setNumOfTickMarks(this.numOfTickMarks.intValue());
        chartNumericAxisProperties.setAxisIncrement(this.increment.doubleValue());
        chartNumericAxisProperties.setLabelStartValue(this.labelStartValue.doubleValue());
        chartNumericAxisProperties.setUseLabelStartValue(this.useLabelStartValue.booleanValue());
        chartNumericAxisProperties.setLabelPosition(this.labelPosition.intValue());
        return chartNumericAxisProperties;
    }

    public void setChartAxisProperties(ChartAxisProperties chartAxisProperties) {
        super.fromChartAxisProperties(chartAxisProperties);
        if (chartAxisProperties instanceof ChartNumericAxisProperties) {
            ChartNumericAxisProperties chartNumericAxisProperties = (ChartNumericAxisProperties)chartAxisProperties;
            this.maxValue.set(chartNumericAxisProperties.getMaxValue());
            this.minValue.set(chartNumericAxisProperties.getMinValue());
            this.numOfTickMarks.set(chartNumericAxisProperties.getNumOfTickMarks());
            this.increment.set(chartNumericAxisProperties.getAxisIncrement());
            this.labelStartValue.set(chartNumericAxisProperties.getLabelStartValue());
            this.useLabelStartValue.set(chartNumericAxisProperties.isUseLabelStartValue());
            this.labelPosition.set(new Integer(chartNumericAxisProperties.getLabelPosition()));
        }
    }
}

