/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine;

import com.jinfonet.util.JRLog;
import java.io.IOException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSPage;
import jet.datastream.DataStream;
import jet.datastream.RandomByteArrayOutputStream;
import jet.ie.ZipToolkit;
import jet.ie.io.PJFDataOutput;
import jet.rptengine.DSObjectRecycler;
import jet.rptengine.JCommunicator;
import jet.rptengine.JReportEngine;
import jet.rptengine.SynRecord;

public class JDataStream
extends DataStream {
    private JRecord GZip;
    int I;
    DSObjectRecycler QOIV = new DSObjectRecycler();
    JCommunicator append;
    private DSPage cachePage;

    public JDataStream() {
    }

    public JDataStream(Communicator communicator, int n, int n2) {
        super(communicator, n2);
        this.I = n;
        this.append = (JCommunicator)communicator;
        JReportEngine jReportEngine = this.append.getReportEngine(0);
        this.GZip = new SynRecord(this.dbBuffer, jReportEngine);
    }

    public void close() {
    }

    public void clearMem() {
        super.clearMem();
        if (this.QOIV != null) {
            this.QOIV.I();
        }
    }

    public JRecord getSynRecord(int n) {
        this.GZip.setPosition(n);
        this.GZip.refresh(false);
        return this.GZip;
    }

    public DSObjectRecycler getRecycler() {
        return this.QOIV;
    }

    public void setID(int n) {
        this.I = n;
    }

    public String toString() {
        return super.toString() + '@' + this.I;
    }

    public void addPage(DSPage dSPage) {
        block2: {
            try {
                this.cachePage(dSPage);
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block2;
                JRLog.error(2, iOException);
            }
        }
    }

    protected void cachePage(DSPage dSPage) throws IOException {
        int n;
        if (this.cachedPages.size() >= this.cacheSize) {
            n = this.LRU.removeLastElement();
            DSPage dSPage2 = (DSPage)this.cachedPages.remove(n);
            if (this.getPageEntry(n) == null) {
                if (this.bufFile == null) {
                    this.createTempFile();
                }
                long l = this.bufFile.length();
                this.bufFile.seek(l);
                this.out.reset(this.bufFile.length());
                RandomByteArrayOutputStream randomByteArrayOutputStream = new RandomByteArrayOutputStream(dSPage2.length());
                dSPage2.write(new PJFDataOutput(randomByteArrayOutputStream));
                byte[] byArray = randomByteArrayOutputStream.toByteArray();
                if (this.isCacheZip()) {
                    byArray = ZipToolkit.GZip(byArray);
                }
                this.out.write(byArray);
                randomByteArrayOutputStream.close();
                this.pageEntries.put(n, new Long(l));
                this.pageLengthes.put(n, new Integer((int)(this.bufFile.length() - l)));
                if (this.append.getCacheSection()) {
                    this.QOIV.I(dSPage2);
                }
            }
        }
        n = dSPage.getPageNum();
        this.cachedPages.put(n, dSPage);
        this.LRU.insertElementAt(n, 0);
    }

    public DSPage getFastPassPage(int n) {
        DSPage dSPage = null;
        Communicator communicator = this.getCommunicator();
        if (communicator instanceof JCommunicator && ((JCommunicator)communicator).isFastPass() && (dSPage = (DSPage)this.cachedPages.get(n)) != null) {
            this.cachedPages.remove(n);
        }
        this.cachePage = dSPage;
        return dSPage;
    }

    public synchronized void addFastPassPage(DSPage dSPage) {
        Communicator communicator;
        if (this.cachedPages.size() >= this.cacheSize && (communicator = this.getCommunicator()) instanceof JCommunicator && ((JCommunicator)communicator).isFastPass()) {
            while (this.cachedPages.size() >= this.cacheSize) {
                try {
                    this.wait();
                }
                catch (Exception exception) {
                    if (!JRLog.isError(2)) continue;
                    JRLog.error(2, exception);
                }
            }
        }
        int n = dSPage.getPageNum();
        this.cachedPages.put(n, dSPage);
    }
}

