/*
 * Decompiled with CFR 0.152.
 */
package jet.rptengine.creator;

import com.jinfonet.util.JRLog;
import jet.exception.UserException;
import jet.report.JRObjectTemplate;
import jet.report.JetRptCTCrossTab;
import jet.report.JetRptField;
import jet.report.JetRptMap;
import jet.report.JetRptReportBody;
import jet.report.JetRptSectionObject;
import jet.report.JetRptSubReport;
import jet.report.JetRptTextBox;
import jet.report.chart.JetRptChartPlatform;
import jet.report.paragraph.build.JetRptParagraph;
import jet.report.table.JetRptNewTable;
import jet.report.tabular.JetRptTabular;
import jet.report.tabular.JetRptTabularCell;
import jet.rptengine.JCommunicator;
import jet.rptengine.SectionPanelCreator;
import jet.rptengine.creator.AbstractCreator;
import jet.rptengine.creator.ChartCreator;
import jet.rptengine.creator.CrosstabCreator;
import jet.rptengine.creator.ExecuteEnv;
import jet.rptengine.creator.FormCreator;
import jet.rptengine.creator.JDSSectionObjectCreator;
import jet.rptengine.creator.JFieldCreator;
import jet.rptengine.creator.MapCreator;
import jet.rptengine.creator.ParagraphCreator;
import jet.rptengine.creator.ReportBodyCreator;
import jet.rptengine.creator.SimpleComponentCreator;
import jet.rptengine.creator.SubReportCreator;
import jet.rptengine.creator.TabularCellCreator;
import jet.rptengine.creator.TabularCreator;
import jet.rptengine.creator.TextBoxCreator;
import jet.table.TableCreator;

public class CreatorFactory {
    public static AbstractCreator getANewCreator(JRObjectTemplate jRObjectTemplate, ExecuteEnv executeEnv) throws UserException {
        AbstractCreator abstractCreator = null;
        int n = jRObjectTemplate.getObjectType();
        switch (n) {
            case 262177: {
                abstractCreator = new ReportBodyCreator((JetRptReportBody)jRObjectTemplate, executeEnv);
                break;
            }
            case 262178: {
                abstractCreator = new ParagraphCreator((JetRptParagraph)jRObjectTemplate, executeEnv);
                break;
            }
            case 45: {
                abstractCreator = new JDSSectionObjectCreator((JetRptSectionObject)jRObjectTemplate, executeEnv);
                break;
            }
            case 46: {
                abstractCreator = new TabularCreator((JetRptTabular)jRObjectTemplate, executeEnv);
                break;
            }
            case 47: {
                abstractCreator = new TabularCellCreator((JetRptTabularCell)jRObjectTemplate, executeEnv);
                break;
            }
            case 34: {
                abstractCreator = new CrosstabCreator((JetRptCTCrossTab)jRObjectTemplate, executeEnv);
                break;
            }
            case 262179: {
                abstractCreator = new TableCreator((JetRptNewTable)jRObjectTemplate, executeEnv);
                break;
            }
            case 262181: {
                abstractCreator = new TextBoxCreator((JetRptTextBox)jRObjectTemplate, executeEnv);
                break;
            }
            case 71: {
                abstractCreator = new ChartCreator((JetRptChartPlatform)jRObjectTemplate, executeEnv);
                break;
            }
            case 40: {
                abstractCreator = new MapCreator((JetRptMap)jRObjectTemplate, executeEnv);
                break;
            }
            case 128: {
                abstractCreator = new SimpleComponentCreator(jRObjectTemplate, executeEnv);
                break;
            }
            case 262183: {
                abstractCreator = new SimpleComponentCreator(jRObjectTemplate, executeEnv);
                break;
            }
            case 33: {
                abstractCreator = new SubReportCreator((JetRptSubReport)jRObjectTemplate, executeEnv);
                break;
            }
            case 0x100002: {
                abstractCreator = new SimpleComponentCreator(jRObjectTemplate, executeEnv);
                break;
            }
            case 4096: {
                abstractCreator = new SimpleComponentCreator(jRObjectTemplate, executeEnv);
                break;
            }
            case 0x100001: {
                abstractCreator = new SimpleComponentCreator(jRObjectTemplate, executeEnv);
                break;
            }
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 393473: 
            case 393513: 
            case 393514: {
                abstractCreator = new JFieldCreator((JetRptField)jRObjectTemplate, executeEnv);
                break;
            }
            case 513: 
            case 514: 
            case 515: 
            case 516: 
            case 517: 
            case 518: 
            case 519: 
            case 2561: 
            case 2562: 
            case 2563: 
            case 2564: {
                abstractCreator = new SectionPanelCreator(jRObjectTemplate, executeEnv);
            }
        }
        if (abstractCreator != null) {
            return abstractCreator;
        }
        throw new UserException(300001, new Object[]{jRObjectTemplate.toString()}, null);
    }

    public static AbstractCreator getCreator(JRObjectTemplate jRObjectTemplate, ExecuteEnv executeEnv) throws UserException {
        AbstractCreator abstractCreator;
        block4: {
            abstractCreator = null;
            try {
                abstractCreator = (AbstractCreator)((JCommunicator)executeEnv.engine.getCommunicator()).getObjectCreater(jRObjectTemplate);
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block4;
                JRLog.error(2, exception);
            }
        }
        if (abstractCreator != null) {
            return abstractCreator;
        }
        abstractCreator = CreatorFactory.getANewCreator(jRObjectTemplate, executeEnv);
        if (abstractCreator != null) {
            ((JCommunicator)executeEnv.engine.getCommunicator()).setObjectCreater(jRObjectTemplate, abstractCreator);
            return abstractCreator;
        }
        throw new UserException(300001, new Object[]{jRObjectTemplate.toString()}, null);
    }

    public static FormCreator getFormCreator(ExecuteEnv executeEnv) {
        return ((JCommunicator)executeEnv.engine.getCommunicator()).getFormCreator();
    }
}

