/*
 * Decompiled with CFR 0.152.
 */
package jet.universe;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import jet.JResource;
import jet.ReportEnv;
import jet.connect.DbColDesc;
import jet.controls.JetObject;
import jet.controls.JetString;
import jet.datasource.JRUDSNameChecker;
import jet.exception.FormulaSyntaxErrorException;
import jet.exception.InvalidParameterException;
import jet.exception.ParseFormulaFailedException;
import jet.formula.FormulaCompiler;
import jet.formula.FormulaCompilerListener;
import jet.formula.FormulaContainer;
import jet.formula.FormulatoJava;
import jet.formula.JetRptFormula;
import jet.formula.ParamDesc;
import jet.formula.ParserOption;
import jet.formula.SymbolInfo;
import jet.formula.VarsTable;
import jet.log.JRLogger;
import jet.universe.JetUAcl;
import jet.universe.JetUCloneable;
import jet.universe.JetUConnection;
import jet.universe.JetUDBField;
import jet.universe.JetUDBTreeNode;
import jet.universe.JetUField;
import jet.universe.JetUFormula;
import jet.universe.JetUHierDataSource;
import jet.universe.JetUJDBCConnection;
import jet.universe.JetUParameter;
import jet.universe.JetUQueriable;
import jet.universe.JetUQuery;
import jet.universe.JetUResourceContainer;
import jet.universe.JetUResourceEntity;
import jet.universe.JetUSummary;
import jet.universe.JetUTableView;
import jet.universe.JetUTreeNode;
import jet.universe.JetUUDSField;
import jet.universe.JetUUniverse;
import jet.universe.JetUUserDataSource;
import jet.universe.JetUWhereFormula;
import jet.universe.JetUWherePortion;
import jet.universe.UMapTable;
import jet.universe.exception.CannotFindEntity;
import jet.universe.exception.CannotFindFrmlRefFld;
import jet.universe.exception.CannotFindQuery;
import jet.universe.exception.FormulaHasGrammarError;
import jet.universe.exception.GenerateFormulasCodeException;
import jet.universe.exception.InvalidEntityException;
import jet.universe.psql.RptPsqlQuery;
import jet.xml.model.ElementNode;
import toolkit.db.DataSourceInfo;
import toolkit.db.DbTools;
import toolkit.db.EnhancedDataSourceInfo;

public class JetUDatabase
extends JetUResourceContainer
implements FormulaContainer,
JRUDSNameChecker,
FormulaCompilerListener {
    public static final String strFormulaPackage = "jet.formula.javaformula.";
    public static final String strFormulaClassSuffix = "_formula";
    public static final String strJavaFileExtension = ".java";
    public static final String strClassFileExtension = ".c_";
    public static final String DEFAULT_NAME = "Default";
    public JetString javaFrmulaName = new JetString(this, "JavaFormulaName");
    protected transient UMapTable mapTable = new UMapTable();
    private transient VarsTable FormulaModified = new VarsTable();
    String GetFileQueryByResourceName = null;
    String GetQueryByResourceName = null;
    private static int GetTableOrViewByRealName;
    private int GetTableOrViewByResourceName = 0;
    private boolean HandleRptFormula = false;
    private boolean InitAfterCreate = false;
    private boolean IsAclNameExist = false;
    private static JRLogger IsAclNameOK;
    public static final String formulaHeadName = "~~FromulaHead";
    private ParserOption IsConnectionNameExist = new ParserOption();
    private Vector IsDataSourceNameOK = new Vector();
    private static final HashMap IsMappingNameExist;
    static Class class$jet$universe$JetUDatabase;
    static final boolean $assertionsDisabled;

    public JetUDatabase() {
    }

    public JetUDatabase(String string, String string2) {
        super(string, string2);
    }

    public void InitAfterCreate() {
        this.GetFileQueryByResourceName = ReportEnv.temporaryPath;
        this.GetFileQueryByResourceName = this.GetFileQueryByResourceName == null ? "" : this.GetFileQueryByResourceName;
        this.GetTableOrViewByResourceName();
    }

    public void InitAfterLoad() {
        JetUConnection jetUConnection;
        this.HandleRptFormula = false;
        this.InitAfterCreate = false;
        this.GetFileQueryByResourceName = ReportEnv.temporaryPath;
        this.GetFileQueryByResourceName = this.GetFileQueryByResourceName == null ? "" : this.GetFileQueryByResourceName;
        String string = this.javaFrmulaName.get();
        this.GetTableOrViewByResourceName = JetObject.getNameCount(string);
        if (this.GetTableOrViewByResourceName < 0) {
            this.GetTableOrViewByResourceName = 0;
        }
        GetTableOrViewByRealName = Math.max(this.GetTableOrViewByResourceName, GetTableOrViewByRealName);
        this.GetTableOrViewByRealName(string);
        if (this.GetQueryByResourceName == null) {
            this.GetTableOrViewByResourceName();
        }
        if ((jetUConnection = this.getConnection()) != null) {
            try {
                jetUConnection.updateSupportInfo();
            }
            catch (SQLException sQLException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        this.$assertionsDisabled();
        this.GetFileQueryByResourceName();
        this.GetQueryByResourceName();
    }

    void I() {
        Vector vector = this.getChildren();
        JetObject jetObject = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUQuery) {
                ((JetUQuery)jetObject).I();
            } else if (jetObject instanceof JetUConnection) {
                ((JetUConnection)jetObject).I();
            }
            ++n2;
        }
    }

    void $assertionsDisabled() {
        this.Z(this.mapTable);
    }

    void GetFileQueryByResourceName() {
        Vector vector = this.getChildren();
        JetObject jetObject = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUQuery) {
                ((JetUQuery)jetObject).Z();
                ((JetUQuery)jetObject).Z(this.mapTable);
            }
            ++n2;
        }
    }

    void GetQueryByResourceName() {
        try {
            Vector vector = this.getChildren();
            int n = vector.size();
            JetObject jetObject = null;
            int n2 = 0;
            while (n2 < n) {
                jetObject = (JetObject)vector.elementAt(n2);
                if (jetObject instanceof JetUParameter) {
                    ((JetUParameter)jetObject).checkParameter(ParamDesc.defaultLocale);
                }
                ++n2;
            }
        }
        catch (InvalidParameterException invalidParameterException) {
            // empty catch block
        }
    }

    void GetTableOrViewByRealName(String string) {
        if (string != null && !string.equals("")) {
            int n = string.lastIndexOf(46) + 1;
            int n2 = string.lastIndexOf(strFormulaClassSuffix) + 8;
            this.GetQueryByResourceName = string.substring(n, n2);
        }
    }

    void GetTableOrViewByResourceName() {
        JetUUniverse jetUUniverse = this.getUniverse();
        String string = this.HandleRptFormula(jetUUniverse.getFullFileName());
        this.GetQueryByResourceName = string == null ? "Formular" + System.currentTimeMillis() + strFormulaClassSuffix : string + strFormulaClassSuffix;
    }

    public JetObject add(JetObject jetObject, int n) {
        if (!($assertionsDisabled || jetObject instanceof JetUConnection || jetObject instanceof JetUUserDataSource || jetObject instanceof JetUHierDataSource || jetObject instanceof JetUQuery || jetObject instanceof JetUFormula || jetObject instanceof JetUParameter || jetObject instanceof JetUSummary || jetObject instanceof JetUAcl || jetObject instanceof JetUWherePortion)) {
            throw new AssertionError((Object)("Invalid Child of JetUDatabase! " + jetObject.getClass().getName() + " Can not be child of " + this.getClass().getName()));
        }
        super.add(jetObject, n);
        return jetObject;
    }

    public JetObject remove(JetObject jetObject) {
        super.remove(jetObject);
        if (jetObject instanceof JetUFormula) {
            this.FormulaModified();
        }
        return jetObject;
    }

    public JetUUniverse getUniverse() {
        return (JetUUniverse)this.getParent();
    }

    public UMapTable getMapTable() {
        return this.mapTable;
    }

    public JetUConnection addConnection(String string, String string2, String string3, String string4, String string5, int n, String string6) {
        try {
            JetUJDBCConnection jetUJDBCConnection = new JetUJDBCConnection(string, string2, string3, string4, string5, n, string6);
            boolean bl = this.addConnection(jetUJDBCConnection);
            if (bl) {
                return jetUJDBCConnection;
            }
            return null;
        }
        catch (SQLException sQLException) {
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public boolean addConnection(JetUConnection jetUConnection) {
        if (!this.IsConnectionNameExist(jetUConnection.getResourceName())) {
            this.add(jetUConnection);
            jetUConnection.InitAfterCreate();
            this.IsAclNameExist = true;
            return true;
        }
        return false;
    }

    public boolean removeConnection(JetUConnection jetUConnection) {
        this.remove(jetUConnection);
        this.IsAclNameExist = false;
        return true;
    }

    public Vector getConnections() {
        Vector<JetUConnection> vector = new Vector<JetUConnection>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUConnection) {
                vector.addElement((JetUConnection)jetObject);
                break;
            }
            ++n2;
        }
        return vector;
    }

    public JetUConnection getConnection() {
        Vector vector = this.getConnections();
        if (vector.size() > 0) {
            return (JetUConnection)vector.elementAt(0);
        }
        return null;
    }

    public JetUConnection getConnectionByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUConnection && ((JetUConnection)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUConnection)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public JetUQuery addQuery(String string, RptPsqlQuery rptPsqlQuery) {
        JetUQuery jetUQuery = new JetUQuery(string, rptPsqlQuery);
        boolean bl = this.addQuery(jetUQuery);
        if (bl) {
            return jetUQuery;
        }
        return null;
    }

    public boolean addQuery(JetUQuery jetUQuery) {
        if (!this.IsQueryNameExist(jetUQuery.getResourceName())) {
            this.add(jetUQuery);
            jetUQuery.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeQuery(String string) {
        JetUQuery jetUQuery = this.GetQueryByResourceName(string);
        if (jetUQuery != null) {
            return this.removeQuery(jetUQuery);
        }
        return false;
    }

    public boolean removeQuery(JetUQuery jetUQuery) {
        this.remove(jetUQuery);
        return true;
    }

    public JetUDBTreeNode makeCopy(JetUCloneable jetUCloneable) {
        JetUDBTreeNode jetUDBTreeNode = jetUCloneable.copy();
        if (jetUDBTreeNode instanceof JetUQuery) {
            this.addQuery((JetUQuery)jetUDBTreeNode);
        } else if (jetUDBTreeNode instanceof JetUSummary) {
            this.addSummary((JetUSummary)jetUDBTreeNode);
        } else if (jetUDBTreeNode instanceof JetUFormula) {
            this.addFormula((JetUFormula)jetUDBTreeNode);
        }
        return jetUDBTreeNode;
    }

    public Vector getQueries() {
        Vector<JetUQuery> vector = new Vector<JetUQuery>();
        Vector vector2 = this.getChildren();
        JetObject jetObject = null;
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUQuery) {
                vector.addElement((JetUQuery)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public JetUQuery GetQueryByResourceName(String string) {
        Vector vector = this.getChildren();
        JetObject jetObject = null;
        int n = vector.size();
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUQuery && ((JetUQuery)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUQuery)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public JetUWherePortion addWherePortion(String string, String string2, String string3) {
        JetUWherePortion jetUWherePortion = new JetUWherePortion(string, string2, string3);
        boolean bl = this.addWherePortion(jetUWherePortion);
        if (bl) {
            return jetUWherePortion;
        }
        return null;
    }

    public boolean addWherePortion(JetUWherePortion jetUWherePortion) {
        if (!this.IsWherePortionNameExist(jetUWherePortion.getResourceName())) {
            this.add(jetUWherePortion);
            jetUWherePortion.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeWherePortion(String string) {
        JetUWherePortion jetUWherePortion = this.getWherePortionByResourceName(string);
        if (jetUWherePortion != null) {
            return this.removeWherePortion(jetUWherePortion);
        }
        return false;
    }

    public boolean removeWherePortion(JetUWherePortion jetUWherePortion) {
        this.remove(jetUWherePortion);
        return true;
    }

    public Vector getWherePortions() {
        Vector<JetUWherePortion> vector = new Vector<JetUWherePortion>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUWherePortion) {
                vector.addElement((JetUWherePortion)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public JetUWherePortion getWherePortionByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUWherePortion && ((JetUWherePortion)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUWherePortion)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public boolean removeHierDataSource(JetUHierDataSource jetUHierDataSource) {
        this.remove(jetUHierDataSource);
        return true;
    }

    public JetUHierDataSource addHierDataSource(ElementNode elementNode, String string) {
        JetUHierDataSource jetUHierDataSource = new JetUHierDataSource(elementNode, string);
        boolean bl = this.addHierDataSource(jetUHierDataSource);
        if (bl) {
            return jetUHierDataSource;
        }
        return null;
    }

    public boolean addHierDataSource(JetUHierDataSource jetUHierDataSource) {
        String string;
        int n = 1;
        if (!this.IsQueryNameExist(jetUHierDataSource.getResourceName())) {
            this.add(jetUHierDataSource);
            jetUHierDataSource.InitAfterCreate();
            return true;
        }
        String string2 = string = jetUHierDataSource.getResourceName();
        while (this.IsQueryNameExist(string2)) {
            string2 = string + n++;
        }
        jetUHierDataSource.setResourceName(string2);
        this.add(jetUHierDataSource);
        jetUHierDataSource.InitAfterCreate();
        return true;
    }

    public JetUUserDataSource addDataSource(EnhancedDataSourceInfo enhancedDataSourceInfo) {
        JetUUserDataSource jetUUserDataSource = new JetUUserDataSource(enhancedDataSourceInfo);
        boolean bl = this.addDataSource(jetUUserDataSource);
        if (bl) {
            return jetUUserDataSource;
        }
        return null;
    }

    public JetUUserDataSource addDataSource(DataSourceInfo dataSourceInfo) {
        JetUUserDataSource jetUUserDataSource = new JetUUserDataSource(dataSourceInfo);
        boolean bl = this.addDataSource(jetUUserDataSource);
        if (bl) {
            return jetUUserDataSource;
        }
        return null;
    }

    public boolean addDataSource(JetUUserDataSource jetUUserDataSource) {
        if (!this.IsQueryNameExist(jetUUserDataSource.getResourceName())) {
            this.add(jetUUserDataSource);
            jetUUserDataSource.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean addDataSourceAfterInit(JetUUserDataSource jetUUserDataSource) {
        if (!this.IsQueryNameExist(jetUUserDataSource.getResourceName())) {
            this.add(jetUUserDataSource);
            jetUUserDataSource.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean addHierDataSourceAfterInit(JetUHierDataSource jetUHierDataSource) {
        if (!this.IsQueryNameExist(jetUHierDataSource.getResourceName())) {
            this.add(jetUHierDataSource);
            jetUHierDataSource.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeDataSource(String string) {
        JetUUserDataSource jetUUserDataSource = this.getDataSourceByResourceName(string);
        if (jetUUserDataSource != null) {
            return this.removeDataSource(jetUUserDataSource);
        }
        return false;
    }

    public boolean removeDataSource(JetUUserDataSource jetUUserDataSource) {
        this.remove(jetUUserDataSource);
        return true;
    }

    public JetUUserDataSource getDataSourceByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUUserDataSource && ((JetUUserDataSource)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUUserDataSource)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public boolean removeHierDataSource(String string) {
        JetUHierDataSource jetUHierDataSource = this.getHierDataSourceByResourceName(string);
        if (jetUHierDataSource != null) {
            return this.removeHierDataSource(jetUHierDataSource);
        }
        return false;
    }

    public JetUHierDataSource getHierDataSourceByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUHierDataSource && ((JetUHierDataSource)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUHierDataSource)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public Vector getDataSources() {
        Vector<JetUUserDataSource> vector = new Vector<JetUUserDataSource>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUUserDataSource) {
                vector.addElement((JetUUserDataSource)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public Vector getHierDataSources() {
        Vector<JetUHierDataSource> vector = new Vector<JetUHierDataSource>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUHierDataSource) {
                vector.addElement((JetUHierDataSource)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public Vector getHDSFormulas() {
        Vector vector = this.getHierDataSources();
        Vector vector2 = new Vector();
        int n = 0;
        while (n < vector.size()) {
            Vector vector3 = ((JetUHierDataSource)vector.elementAt(n)).getWhereFormulas();
            if (vector3 != null && vector3.size() > 0) {
                vector2.addAll(vector3);
            }
            ++n;
        }
        return vector2;
    }

    public JetUFormula addFormula(String string, String string2, String string3) {
        JetUFormula jetUFormula = new JetUFormula(string, string2, string3);
        boolean bl = this.addFormula(jetUFormula);
        if (bl) {
            return jetUFormula;
        }
        return null;
    }

    public boolean addFormula(JetUFormula jetUFormula) {
        if (!this.IsMappingNameExist(jetUFormula.getResourceName())) {
            this.add(jetUFormula);
            jetUFormula.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeFormula(JetUFormula jetUFormula) {
        this.remove(jetUFormula);
        return true;
    }

    public Vector getFormulas() {
        Vector<JetUFormula> vector = new Vector<JetUFormula>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUFormula && !(jetObject instanceof JetUSummary) && !((JetUFormula)jetObject).name.get().startsWith("~~")) {
                vector.addElement((JetUFormula)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public JetUFormula getFormulaHead() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUFormula && ((JetUFormula)jetObject).name.get().equals(formulaHeadName)) {
                return (JetUFormula)jetObject;
            }
            ++n2;
        }
        JetUFormula jetUFormula = new JetUFormula(formulaHeadName, "", "");
        this.addFormula(jetUFormula);
        return jetUFormula;
    }

    public JetUFormula getFormulaByResourceName(String string) {
        JetUResourceEntity jetUResourceEntity = this.mapTable.getResourceByName(string.toUpperCase());
        return jetUResourceEntity instanceof JetUFormula ? (JetUFormula)jetUResourceEntity : null;
    }

    public JetUParameter addParameter(String string, String string2, String string3, String string4, String string5) {
        JetUParameter jetUParameter = new JetUParameter(string, string2, string3, string4, string5);
        boolean bl = this.addParameter(jetUParameter);
        if (bl) {
            return jetUParameter;
        }
        return null;
    }

    public boolean addParameter(JetUParameter jetUParameter) {
        String string = jetUParameter.getResourceName();
        Vector vector = this.getUniverse().getAllDatabases();
        boolean bl = false;
        int n = 0;
        while (n < vector.size()) {
            JetUDatabase jetUDatabase = (JetUDatabase)vector.elementAt(n);
            if (jetUDatabase.IsMappingNameExist(string)) {
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            this.add(jetUParameter);
            jetUParameter.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeParameter(JetUParameter jetUParameter) {
        this.remove(jetUParameter);
        return true;
    }

    public Vector getParameters() {
        Vector<JetUParameter> vector = new Vector<JetUParameter>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUParameter) {
                vector.addElement((JetUParameter)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public JetUParameter getParameterByResourceName(String string) {
        JetUResourceEntity jetUResourceEntity = this.mapTable.getResourceByName(string.toUpperCase());
        return jetUResourceEntity instanceof JetUParameter ? (JetUParameter)jetUResourceEntity : null;
    }

    public JetUSummary addSummary(String string, String string2, String string3, String string4, String string5) {
        JetUSummary jetUSummary = new JetUSummary(string, string2, string3, string4, string5);
        boolean bl = this.addSummary(jetUSummary);
        if (bl) {
            return jetUSummary;
        }
        return null;
    }

    public boolean addSummary(JetUSummary jetUSummary) {
        if (!this.IsMappingNameExist(jetUSummary.getResourceName())) {
            this.add(jetUSummary);
            jetUSummary.InitAfterCreate();
            return true;
        }
        return false;
    }

    public boolean removeSummary(JetUSummary jetUSummary) {
        this.remove(jetUSummary);
        return true;
    }

    public Vector getSummaries() {
        Vector<JetUSummary> vector = new Vector<JetUSummary>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUSummary) {
                vector.addElement((JetUSummary)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public JetUSummary getSummaryByResourceName(String string) {
        JetUResourceEntity jetUResourceEntity = this.mapTable.getResourceByName(string.toUpperCase());
        return jetUResourceEntity instanceof JetUSummary ? (JetUSummary)jetUResourceEntity : null;
    }

    public Vector getFormulasAndSummaries() {
        Vector<JetUFormula> vector = new Vector<JetUFormula>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUFormula && !((JetUFormula)jetObject).name.get().startsWith("~~")) {
                vector.addElement((JetUFormula)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public Vector getAllSumsValidToQuery(String string) {
        int n;
        if (string == null) {
            return this.getSummaries();
        }
        JetUQueriable jetUQueriable = this.getQueriableByResourceName(string);
        if (jetUQueriable == null) {
            return null;
        }
        Vector vector = this.getSummaries();
        if (jetUQueriable != null && (n = vector.size()) > 0) {
            int n2 = n - 1;
            while (n2 >= 0) {
                JetUSummary jetUSummary = (JetUSummary)vector.elementAt(n2);
                try {
                    if (!jetUQueriable.isFieldValidToQuery(this.getUniverse(), jetUSummary, this.name.get())) {
                        vector.removeElement(jetUSummary);
                    }
                }
                catch (FormulaHasGrammarError formulaHasGrammarError) {
                    vector.removeElement(jetUSummary);
                }
                catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                    vector.removeElement(jetUSummary);
                }
                catch (CannotFindEntity cannotFindEntity) {
                    vector.removeElement(jetUSummary);
                }
                --n2;
            }
        }
        return vector;
    }

    static boolean I(String string) {
        try {
            Long.parseLong(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public Vector getSummaries(String string, Vector vector) {
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        JetUSummary jetUSummary = null;
        Vector<JetUSummary> vector3 = new Vector<JetUSummary>();
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUSummary) {
                jetUSummary = (JetUSummary)jetObject;
                if (string == null || string.equalsIgnoreCase(jetUSummary.getFieldName())) {
                    if (vector == null || vector.size() == 0) {
                        vector3.addElement(jetUSummary);
                    } else {
                        String string2 = jetUSummary.getGroupByFld();
                        if (string2 != null && !string2.equalsIgnoreCase("")) {
                            int n3 = vector.size();
                            int n4 = 0;
                            while (n4 < n3) {
                                if (string2.equalsIgnoreCase((String)vector.elementAt(n4))) {
                                    if (IsAclNameOK.isDebugEnabled()) {
                                        IsAclNameOK.debug("adding summary..." + jetUSummary.getResourceName());
                                    }
                                    vector3.addElement(jetUSummary);
                                }
                                ++n4;
                            }
                        } else {
                            vector3.addElement(jetUSummary);
                        }
                    }
                }
            }
            ++n2;
        }
        return vector3;
    }

    public Vector getSummaries(String string, Vector vector, String string2) {
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        Vector<JetUSummary> vector3 = new Vector<JetUSummary>();
        int n2 = 0;
        while (n2 < n) {
            JetUSummary jetUSummary;
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUSummary && string.equalsIgnoreCase((jetUSummary = (JetUSummary)jetObject).getFieldName()) && string2.equalsIgnoreCase(jetUSummary.getFunction())) {
                int n3;
                String string3 = jetUSummary.getGroupByFld();
                if (string3 != null && !string3.equalsIgnoreCase("")) {
                    int n4 = vector.size();
                    n3 = 0;
                    while (n3 < n4) {
                        if (string3.equalsIgnoreCase((String)vector.elementAt(n3))) {
                            vector3.addElement(jetUSummary);
                        }
                        ++n3;
                    }
                } else {
                    n3 = vector.size();
                    int n5 = 0;
                    while (n5 < n3) {
                        String string4 = (String)vector.elementAt(n5);
                        if (string4 == null || string4.equals("")) {
                            vector3.addElement(jetUSummary);
                        }
                        ++n5;
                    }
                }
            }
            ++n2;
        }
        return vector3;
    }

    protected String[] ParseFullFieldName(String string) {
        if (string != null) {
            int n = string.indexOf(46);
            int n2 = 0;
            String[] stringArray = new String[3];
            int n3 = 0;
            while (n3 < 3) {
                if (n == -1) {
                    return null;
                }
                stringArray[n3] = string.substring(n2, n);
                n2 = n + 1;
                n = string.indexOf(46, n2);
                ++n3;
            }
            return stringArray;
        }
        return null;
    }

    public String getDesc() {
        return null;
    }

    public void setDesc(String string) {
    }

    public JetUTableView GetTableOrViewByRealName(String string, String string2) {
        JetUConnection jetUConnection = this.getConnectionByResourceName(string);
        if (jetUConnection != null) {
            return jetUConnection.GetTableOrViewByRealName(string2);
        }
        return null;
    }

    public JetUTableView GetTableOrViewByResourceName(String string, String string2) {
        JetUConnection jetUConnection = this.getConnectionByResourceName(string);
        if (jetUConnection != null) {
            return jetUConnection.GetTableOrViewByResourceName(string2);
        }
        return null;
    }

    public JetUField GetFieldByRealName(String string, String string2, String string3) {
        JetUTableView jetUTableView = this.GetTableOrViewByResourceName(string, string2);
        if (jetUTableView != null) {
            return jetUTableView.getFieldByFieldName(string3);
        }
        return null;
    }

    public boolean IsConnectionNameExist(String string) {
        return this.getConnectionByResourceName(string) != null;
    }

    public boolean IsTableNameExist(String string, String string2) {
        JetUConnection jetUConnection = this.getConnectionByResourceName(string);
        return jetUConnection.IsTableNameExist(string2);
    }

    public boolean IsQueryNameExist(String string) {
        return this.getQueriableByResourceName(string) != null;
    }

    public boolean IsDataSourceNameExist(String string) {
        return this.getDataSourceByResourceName(string) != null;
    }

    public boolean IsWherePortionNameExist(String string) {
        return this.getWherePortionByResourceName(string) != null;
    }

    public boolean IsMappingNameExist(String string) {
        return this.mapTable.getResourceByName(string.toUpperCase()) != null;
    }

    boolean I(String string, StringBuffer stringBuffer) {
        if ((string = string.trim()) != null && string.length() != 0) {
            return true;
        }
        if (stringBuffer != null) {
            stringBuffer.append(JResource.getMessage("CAT_12", (Object)string));
        }
        return false;
    }

    public boolean IsConnectionNameOK(String string, StringBuffer stringBuffer) {
        if (!this.I(string, stringBuffer)) {
            return false;
        }
        if (this.IsConnectionNameExist(string)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_13", (Object)string));
            }
            return false;
        }
        return true;
    }

    public boolean IsTableNameOK(String string, String string2, StringBuffer stringBuffer) {
        if (!this.I(string2, stringBuffer)) {
            return false;
        }
        JetUConnection jetUConnection = this.getConnectionByResourceName(string);
        if (jetUConnection.isNameExist(string2)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_14", (Object)string2));
            }
            return false;
        }
        return true;
    }

    public boolean IsProcedureNameOK(String string, String string2, StringBuffer stringBuffer) {
        if (!this.I(string2, stringBuffer)) {
            return false;
        }
        if (this.isQueriableExist(string2)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_14", (Object)string2));
            }
            return false;
        }
        return true;
    }

    public boolean IsDataSourceNameOK(String string, StringBuffer stringBuffer) {
        if (!this.I(string, stringBuffer)) {
            return false;
        }
        if (this.isQueriableExist(string)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_16", (Object)string));
            }
            return false;
        }
        return true;
    }

    public boolean IsFileQueryNameOK(String string, String string2, StringBuffer stringBuffer) {
        if (!this.I(string2, stringBuffer)) {
            return false;
        }
        if (this.isQueriableExist(string2)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_90", (Object)string2));
            }
            return false;
        }
        return true;
    }

    public boolean IsQueryNameOK(String string, StringBuffer stringBuffer) {
        if (!this.I(string, stringBuffer)) {
            return false;
        }
        if (this.isQueriableExist(string)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_88", (Object)string));
            }
            return false;
        }
        return true;
    }

    public boolean IsMappingNameOK(String string, StringBuffer stringBuffer) {
        if (!this.I(string, stringBuffer)) {
            return false;
        }
        if (this.IsMappingNameExist(string)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_16", (Object)string));
            }
            return false;
        }
        if (DbTools.isSpecialField(string) != -1) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_111", (Object)string));
            }
            return false;
        }
        return true;
    }

    public boolean IsWherePortionNameOK(String string, StringBuffer stringBuffer) {
        if (!this.I(string, stringBuffer)) {
            return false;
        }
        if (this.IsWherePortionNameExist(string)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_DB_NAMECHECK_WHEREPORTION", (Object)string));
            }
            return false;
        }
        return true;
    }

    public boolean isUDSNameOK(String string) {
        return this.IsDataSourceNameOK(string, new StringBuffer());
    }

    public boolean isColumnMappingNameOK(String string) {
        return this.IsMappingNameOK(string, new StringBuffer());
    }

    public String hintUDSNameOK(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.IsDataSourceNameOK(string, stringBuffer);
        int n = 1;
        String string2 = string;
        while (!bl) {
            string2 = string + String.valueOf(n++);
            bl = this.IsDataSourceNameOK(string2, stringBuffer);
        }
        return string2;
    }

    public String hintColumnMappingNameOK(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = this.IsMappingNameOK(string, stringBuffer);
        int n = 1;
        String string2 = string;
        while (!bl) {
            string2 = string + String.valueOf(n++);
            bl = this.IsMappingNameOK(string2, stringBuffer);
        }
        return string2;
    }

    public String getOldColumnMappingNameByIndex(String string, int n) {
        JetUUDSField jetUUDSField;
        JetUUserDataSource jetUUserDataSource = this.getDataSourceByResourceName(string);
        if (jetUUserDataSource != null && (jetUUDSField = jetUUserDataSource.getFieldByMappingIndex(n)) != null) {
            return jetUUDSField.getResourceName();
        }
        return null;
    }

    public String getOldColumnMappingNameByPath(String string, String string2) {
        JetUUDSField jetUUDSField;
        JetUUserDataSource jetUUserDataSource = this.getDataSourceByResourceName(string);
        if (jetUUserDataSource != null && (jetUUDSField = jetUUserDataSource.getFieldByPathString(string2)) != null) {
            return jetUUDSField.getResourceName();
        }
        return null;
    }

    String HandleRptFormula(String string) {
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            if (!Character.isJavaIdentifierStart(stringBuffer.charAt(0))) {
                stringBuffer.setCharAt(0, '_');
            }
            int n = stringBuffer.length();
            while (--n > 0) {
                if (Character.isJavaIdentifierPart(stringBuffer.charAt(n))) continue;
                stringBuffer.setCharAt(n, '_');
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public boolean isHaveTableViews() {
        boolean bl = false;
        Vector vector = new Vector();
        Vector vector2 = this.getConnections();
        int n = vector2.size();
        int n2 = 0;
        while (n2 < n) {
            JetUConnection jetUConnection = (JetUConnection)vector2.elementAt(n2);
            Vector vector3 = jetUConnection.getTableViews();
            if (!vector3.isEmpty()) {
                bl = true;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isHaveQuery() {
        Vector vector = this.getQueries();
        return !vector.isEmpty();
    }

    public void afterInit() {
        super.afterInit();
    }

    public Vector getQueriables() {
        int n;
        Vector vector;
        int n2;
        int n3;
        Vector vector2;
        Vector vector3 = this.getQueries();
        JetUConnection jetUConnection = this.getConnection();
        if (jetUConnection != null) {
            vector2 = jetUConnection.getFileQueries();
            n3 = vector2.size();
            n2 = 0;
            while (n2 < n3) {
                vector3.addElement(vector2.elementAt(n2));
                ++n2;
            }
            vector = jetUConnection.getProcedures();
            n3 = vector.size();
            n = 0;
            while (n < n3) {
                vector3.addElement(vector.elementAt(n));
                ++n;
            }
        }
        vector2 = this.getDataSources();
        n3 = vector2.size();
        n2 = 0;
        while (n2 < n3) {
            vector3.addElement(vector2.elementAt(n2));
            ++n2;
        }
        vector = this.getHierDataSources();
        n3 = vector.size();
        n = 0;
        while (n < n3) {
            vector3.addElement(vector.elementAt(n));
            ++n;
        }
        return vector3;
    }

    public JetUQueriable getQueriableByResourceName(String string) {
        JetUResourceContainer jetUResourceContainer = this.GetQueryByResourceName(string);
        if (jetUResourceContainer == null) {
            JetUConnection jetUConnection = this.getConnection();
            if (jetUConnection != null && (jetUResourceContainer = jetUConnection.GetFileQueryByResourceName(string)) == null) {
                jetUResourceContainer = jetUConnection.getProcedureByResourceName(string);
            }
            if (jetUResourceContainer == null) {
                jetUResourceContainer = this.getDataSourceByResourceName(string);
            }
            if (jetUResourceContainer == null) {
                jetUResourceContainer = this.getHierDataSourceByResourceName(string);
            }
        }
        return jetUResourceContainer;
    }

    public boolean isQueriableExist(String string) {
        return this.getQueriableByResourceName(string) != null;
    }

    public JetUResourceEntity getResourceByName(String string) {
        return this.getResourceByName(null, string.toUpperCase());
    }

    public JetUResourceEntity getResourceByName(String string, String string2) {
        JetUQueriable jetUQueriable;
        JetUResourceEntity jetUResourceEntity = null;
        if (string != null && (jetUQueriable = this.getQueriableByResourceName(string)) != null && jetUQueriable instanceof JetUQuery) {
            jetUResourceEntity = ((JetUQuery)jetUQueriable).getResourceByName(string2);
        }
        if (jetUResourceEntity == null) {
            jetUResourceEntity = this.mapTable.getResourceByName(string2.toUpperCase());
        }
        return jetUResourceEntity;
    }

    public Vector getAvailableResourceEntitys(String string) {
        JetUUniverse jetUUniverse = this.getUniverse();
        JetUQueriable jetUQueriable = this.getQueriableByResourceName(string);
        Vector vector = new Vector();
        if (jetUQueriable != null) {
            Vector vector2 = jetUQueriable.getFields();
            int n = vector2.size();
            int n2 = 0;
            while (n2 < n) {
                vector.addElement(vector2.elementAt(n2));
                ++n2;
            }
            Enumeration enumeration = this.mapTable.elements();
            while (enumeration.hasMoreElements()) {
                JetUResourceEntity jetUResourceEntity = (JetUResourceEntity)enumeration.nextElement();
                try {
                    if (!jetUQueriable.isFieldValidToQuery(jetUUniverse, jetUResourceEntity, this.name.get()) || vector.contains(jetUResourceEntity)) continue;
                    vector.addElement(jetUResourceEntity);
                }
                catch (FormulaHasGrammarError formulaHasGrammarError) {
                }
                catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                }
                catch (CannotFindEntity cannotFindEntity) {
                    // empty catch block
                }
            }
        }
        return vector;
    }

    public Vector getGroupByFormula(String string) {
        return this.getGroupByFormula(string, null);
    }

    public Vector getGroupByFormula(String string, String string2) {
        Vector<JetUFormula> vector = new Vector<JetUFormula>();
        JetUQueriable jetUQueriable = this.getQueriableByResourceName(string2);
        Vector vector2 = this.getFormulasAndSummaries();
        int n = vector2.size();
        try {
            int n2 = 0;
            while (n2 < n) {
                JetUFormula jetUFormula = (JetUFormula)vector2.elementAt(n2);
                if (jetUFormula.isGroupBy(string) && (string2 == null || jetUQueriable.isFieldValidToQuery(this.getUniverse(), jetUFormula.getResourceName(), this.name.get()))) {
                    vector.addElement(jetUFormula);
                }
                ++n2;
            }
        }
        catch (FormulaHasGrammarError formulaHasGrammarError) {
        }
        catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
        }
        catch (CannotFindEntity cannotFindEntity) {
            // empty catch block
        }
        return vector;
    }

    public boolean checkIfMappingFldsValidToQuery(String string, Vector vector) throws InvalidEntityException, CannotFindQuery {
        return this.checkIfMappingFldsValidToQuery(string, vector, new Hashtable());
    }

    public boolean checkIfMappingFldsValidToQuery(String string, Vector vector, Hashtable hashtable) throws InvalidEntityException, CannotFindQuery {
        JetUQueriable jetUQueriable = this.getQueriableByResourceName(string);
        if (jetUQueriable != null) {
            InvalidEntityException invalidEntityException = null;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = (String)hashtable.get(string2);
                string3 = string3 == null ? this.name.get() : string3;
                try {
                    if (jetUQueriable.isFieldValidToQuery(this.getUniverse(), string2, string3)) continue;
                    if (invalidEntityException == null) {
                        invalidEntityException = new InvalidEntityException();
                    }
                    invalidEntityException.addInvalidEntity(string2, (short)3);
                }
                catch (CannotFindEntity cannotFindEntity) {
                    if (invalidEntityException == null) {
                        invalidEntityException = new InvalidEntityException();
                    }
                    invalidEntityException.addInvalidEntity(string2, (short)1);
                }
                catch (FormulaHasGrammarError formulaHasGrammarError) {
                    if (invalidEntityException == null) {
                        invalidEntityException = new InvalidEntityException();
                    }
                    invalidEntityException.addInvalidEntity(string2, (short)2);
                }
                catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                    if (invalidEntityException == null) {
                        invalidEntityException = new InvalidEntityException();
                    }
                    invalidEntityException.addInvalidEntity(string2, (short)2);
                }
            }
            if (invalidEntityException != null) {
                throw invalidEntityException;
            }
        }
        return true;
    }

    public DbColDesc getSQLType(String string, String string2) {
        JetUResourceEntity jetUResourceEntity = this.getResourceByName(string, string2);
        if (jetUResourceEntity != null) {
            return jetUResourceEntity.getColDesc();
        }
        return null;
    }

    public SymbolInfo getParameterType(String string) {
        return this.getParameterByResourceName(string).getInfo();
    }

    public VarsTable getGVarTable() {
        return this.FormulaModified;
    }

    public ParserOption getParserOption() {
        this.IsConnectionNameExist.setSupportGlobal(true);
        return this.IsConnectionNameExist;
    }

    public DbColDesc getSQLType(String string) {
        return this.getSQLType(null, string);
    }

    public DbColDesc getDbSQLType(String string) {
        JetUResourceEntity jetUResourceEntity = this.getResourceByName(string);
        if (jetUResourceEntity != null && jetUResourceEntity instanceof JetUDBField) {
            return jetUResourceEntity.getColDesc();
        }
        return null;
    }

    public void FormulaModified() {
        this.HandleRptFormula = true;
        this.InitAfterCreate = true;
    }

    public void setFormulaModified(boolean bl) {
        this.HandleRptFormula = bl;
    }

    public boolean isFormulaModified() {
        return this.HandleRptFormula;
    }

    public void setNeedGenerateJava(boolean bl) {
        this.InitAfterCreate = bl;
    }

    public boolean isNeedGenerateJava() {
        return this.InitAfterCreate;
    }

    public String getCurFormulasFullClassName() {
        if (this.GetQueryByResourceName == null) {
            this.GetTableOrViewByResourceName();
        }
        String string = this.IsAclNameExist();
        return strFormulaPackage + this.GetQueryByResourceName + string + this.GetTableOrViewByResourceName;
    }

    private String IsAclNameExist() {
        String string = this.getResourceName();
        if (string != null && !string.equals("")) {
            if (Character.isDigit(string.charAt(string.length() - 1))) {
                string = string + '_';
            }
            string = FormulatoJava.regulateName(string);
        }
        return string;
    }

    public String getCurFormulasFullFileName() {
        if (this.GetQueryByResourceName == null) {
            this.GetTableOrViewByResourceName();
        }
        String string = this.IsAclNameExist();
        return this.GetFileQueryByResourceName + this.GetQueryByResourceName + string + this.GetTableOrViewByResourceName + strJavaFileExtension;
    }

    public void beforeParseFormulas() {
        if (this.FormulaModified == null) {
            this.FormulaModified = new VarsTable();
        }
        this.FormulaModified.clear();
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUFormula) {
                ((JetUFormula)jetObject).createRptFormula();
            } else if (jetObject instanceof JetUQuery) {
                object = ((JetUQuery)jetObject).getWhereFormula();
                if (object != null) {
                    ((JetUWhereFormula)object).createRptFormula();
                }
            } else if (jetObject instanceof JetUHierDataSource) {
                object = ((JetUHierDataSource)jetObject).getWhereFormulas();
                int n3 = object == null ? 0 : ((Vector)object).size();
                int n4 = 0;
                while (n4 < n3) {
                    JetUWhereFormula jetUWhereFormula = (JetUWhereFormula)((Vector)object).elementAt(n4);
                    jetUWhereFormula.createRptFormula();
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void afterParseFormulas() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        boolean bl = false;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUFormula) {
                ((JetUFormula)jetObject).HandleRptFormula();
            } else if (jetObject instanceof JetUQuery) {
                object = ((JetUQuery)jetObject).getWhereFormula();
                if (object != null) {
                    ((JetUFormula)object).HandleRptFormula();
                }
            } else if (jetObject instanceof JetUHierDataSource) {
                object = ((JetUHierDataSource)jetObject).getWhereFormulas();
                int n3 = object == null ? 0 : ((Vector)object).size();
                int n4 = 0;
                while (n4 < n3) {
                    JetUWhereFormula jetUWhereFormula = (JetUWhereFormula)((Vector)object).elementAt(n4);
                    jetUWhereFormula.HandleRptFormula();
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public Vector getRptFormulas() {
        return this.getRptFormulas(false);
    }

    public Vector getRptFormulas(boolean bl) {
        Vector<JetRptFormula> vector = new Vector<JetRptFormula>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            Object object;
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUFormula) {
                vector.addElement(((JetUFormula)jetObject).getRptFormula());
            } else if (jetObject instanceof JetUQuery && !bl) {
                object = ((JetUQuery)jetObject).getWhereFormula();
                if (object != null) {
                    vector.addElement(((JetUFormula)object).getRptFormula());
                }
            } else if (jetObject instanceof JetUHierDataSource && !bl) {
                object = ((JetUHierDataSource)jetObject).getWhereFormulas();
                int n3 = object == null ? 0 : ((Vector)object).size();
                int n4 = 0;
                while (n4 < n3) {
                    JetUWhereFormula jetUWhereFormula = (JetUWhereFormula)((Vector)object).elementAt(n4);
                    vector.addElement(jetUWhereFormula.getRptFormula());
                    ++n4;
                }
            }
            ++n2;
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateFormulaCodes(boolean bl, boolean bl2) throws GenerateFormulasCodeException {
        String string = null;
        String string2 = null;
        PrintStream printStream = null;
        try {
            int n = 0;
            if (this.InitAfterCreate) {
                this.GetTableOrViewByResourceName();
                n = GetTableOrViewByRealName + 1;
            } else {
                n = this.GetTableOrViewByResourceName;
            }
            String string3 = this.IsAclNameExist();
            string = this.GetQueryByResourceName + string3 + n;
            string2 = this.GetFileQueryByResourceName + this.GetQueryByResourceName + string3 + n + strJavaFileExtension;
            printStream = new PrintStream(new FileOutputStream(string2));
        }
        catch (IOException iOException) {
            throw new GenerateFormulasCodeException(iOException.getMessage());
        }
        try {
            try {
                this._parseFormulas(bl, printStream, string);
            }
            catch (ParseFormulaFailedException parseFormulaFailedException) {
                Object var9_11 = null;
                printStream.close();
                this.IsAclNameOK();
            }
            Object var9_10 = null;
            printStream.close();
            this.IsAclNameOK();
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            printStream.close();
            this.IsAclNameOK();
            throw throwable;
        }
    }

    private void IsAclNameOK() {
        String string = this.IsAclNameExist();
        if (this.InitAfterCreate) {
            String string2 = null;
            String string3 = null;
            string2 = this.GetFileQueryByResourceName + this.GetQueryByResourceName + string + this.GetTableOrViewByResourceName + strClassFileExtension;
            string3 = this.GetFileQueryByResourceName + this.GetQueryByResourceName + string + this.GetTableOrViewByResourceName + strJavaFileExtension;
            File file = new File(string3);
            File file2 = new File(string2);
            if (file.exists()) {
                file.delete();
            }
            if (file2.exists()) {
                file2.delete();
            }
            this.GetTableOrViewByResourceName = GetTableOrViewByRealName + 1;
            ++GetTableOrViewByRealName;
            this.InitAfterCreate = false;
        }
        this.javaFrmulaName.set(strFormulaPackage + this.GetQueryByResourceName + string + this.GetTableOrViewByResourceName);
    }

    public void parseFormulas(boolean bl) throws ParseFormulaFailedException {
        this._parseFormulas(bl, null, "", false);
    }

    public void parseFormulas(boolean bl, boolean bl2) throws ParseFormulaFailedException {
        this._parseFormulas(bl, null, "", bl2);
    }

    public void _parseFormulas(boolean bl, PrintStream printStream, String string) throws ParseFormulaFailedException {
        this._parseFormulas(bl, printStream, string, false);
    }

    public Vector getUDFNames() {
        return this.IsDataSourceNameOK;
    }

    public void translateComplete(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            IsAclNameOK.error(vector.elementAt(n));
            ++n;
        }
    }

    public void _parseFormulas(boolean bl, PrintStream printStream, String string, boolean bl2) throws ParseFormulaFailedException {
        this.beforeParseFormulas();
        Vector vector = this.getRptFormulas(bl2);
        ParseFormulaFailedException parseFormulaFailedException = null;
        String string2 = null;
        FormulaCompiler formulaCompiler = new FormulaCompiler(this);
        if (printStream != null) {
            string2 = formulaCompiler.compileFormulas(vector, string, this);
        } else {
            try {
                this.InitAfterCreate = true;
                formulaCompiler.checkFormulas(vector);
            }
            catch (ParseFormulaFailedException parseFormulaFailedException2) {
                parseFormulaFailedException = parseFormulaFailedException2;
            }
        }
        this.afterParseFormulas();
        if (parseFormulaFailedException != null) {
            throw parseFormulaFailedException;
        }
    }

    public Vector getAllFomulasValidToQuery(String string) {
        Vector vector;
        int n;
        JetUQueriable jetUQueriable = this.getQueriableByResourceName(string);
        if (jetUQueriable != null && (n = (vector = this.getFormulas()).size()) > 0) {
            Vector<JetUFormula> vector2 = new Vector<JetUFormula>(n);
            int n2 = 0;
            while (n2 < n) {
                JetUFormula jetUFormula = (JetUFormula)vector.elementAt(n2);
                try {
                    if (jetUQueriable.isFieldValidToQuery(this.getUniverse(), jetUFormula, this.name.get())) {
                        vector2.addElement(jetUFormula);
                    }
                }
                catch (FormulaHasGrammarError formulaHasGrammarError) {
                    IsAclNameOK.debug(formulaHasGrammarError);
                }
                catch (CannotFindFrmlRefFld cannotFindFrmlRefFld) {
                    IsAclNameOK.debug(cannotFindFrmlRefFld);
                }
                catch (CannotFindEntity cannotFindEntity) {
                    IsAclNameOK.debug(cannotFindEntity);
                }
                ++n2;
            }
            return vector2;
        }
        return null;
    }

    public JetRptFormula getFormula(String string) {
        JetUFormula jetUFormula = this.getFormulaByResourceName(string);
        if (jetUFormula != null) {
            return jetUFormula.getRptFormula();
        }
        return null;
    }

    public void clearMem() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            try {
                if (!(jetObject instanceof JetUParameter) && jetObject instanceof JetUJDBCConnection) {
                    Vector vector2 = ((JetUJDBCConnection)jetObject).getChildren();
                    int n3 = vector2.size();
                    JetObject jetObject2 = null;
                    int n4 = 0;
                    while (n4 < n3) {
                        jetObject2 = (JetObject)vector2.elementAt(n4);
                        if (jetObject2 instanceof JetUTableView) {
                            // empty if block
                        }
                        ++n4;
                    }
                }
                jetObject.delete();
            }
            catch (Exception exception) {
                IsAclNameOK.debug(exception);
            }
            ++n2;
        }
        if (this.mapTable != null) {
            this.mapTable.clearMem();
            this.mapTable = null;
        }
    }

    public void parseSummary(JetUSummary jetUSummary) throws ParseFormulaFailedException {
        JetRptFormula jetRptFormula = jetUSummary.createRptFormula();
        FormulatoJava formulatoJava = new FormulatoJava("", null);
        try {
            jetRptFormula.parseFormula(formulatoJava);
        }
        catch (FormulaSyntaxErrorException formulaSyntaxErrorException) {
            Vector<FormulaSyntaxErrorException> vector = new Vector<FormulaSyntaxErrorException>();
            vector.addElement(formulaSyntaxErrorException);
            throw new ParseFormulaFailedException(vector);
        }
        jetUSummary.HandleRptFormula();
    }

    public void objectChanged(JetUTreeNode jetUTreeNode, int n) {
        JetUUniverse jetUUniverse = this.getUniverse();
        JetUUniverse.objectChanged(jetUUniverse, jetUTreeNode, n);
    }

    public void removeExceptConn() {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (!(jetObject instanceof JetUJDBCConnection) && !(jetObject instanceof JetUConnection)) {
                this.remove(jetObject);
            }
            ++n2;
        }
    }

    public String getInstancePrefix() {
        return "Database";
    }

    public JetUAcl getAclByResourceName(String string) {
        Vector vector = this.getChildren();
        int n = vector.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector.elementAt(n2);
            if (jetObject instanceof JetUAcl && ((JetUAcl)jetObject).getResourceName().equalsIgnoreCase(string)) {
                return (JetUAcl)jetObject;
            }
            ++n2;
        }
        return null;
    }

    public boolean addAcl(JetUAcl jetUAcl) {
        if (!this.IsAclNameExist(jetUAcl.getResourceName())) {
            this.add(jetUAcl);
            return true;
        }
        return false;
    }

    public boolean IsAclNameExist(String string) {
        return this.getAclByResourceName(string) != null;
    }

    public boolean IsAclNameOK(String string, StringBuffer stringBuffer) {
        if (!this.I(string, stringBuffer)) {
            return false;
        }
        if (this.IsAclNameExist(string)) {
            if (stringBuffer != null) {
                stringBuffer.append(JResource.getMessage("CAT_88", (Object)string));
            }
            return false;
        }
        return true;
    }

    public Vector getAcls() {
        Vector<JetUAcl> vector = new Vector<JetUAcl>();
        Vector vector2 = this.getChildren();
        int n = vector2.size();
        JetObject jetObject = null;
        int n2 = 0;
        while (n2 < n) {
            jetObject = (JetObject)vector2.elementAt(n2);
            if (jetObject instanceof JetUAcl) {
                vector.addElement((JetUAcl)jetObject);
            }
            ++n2;
        }
        return vector;
    }

    public boolean removeAcl(String string) {
        JetUAcl jetUAcl = this.getAclByResourceName(string);
        if (jetUAcl != null) {
            return this.removeAcl(jetUAcl);
        }
        return false;
    }

    public boolean removeAcl(JetUAcl jetUAcl) {
        this.remove(jetUAcl);
        return true;
    }

    public String defaultAclName() {
        int n = 1;
        StringBuffer stringBuffer = new StringBuffer("");
        String string = null;
        String string2 = JResource.getMessage("SecurityEntryTag");
        while (!this.IsAclNameOK(string = string2 + n++, stringBuffer)) {
        }
        return string;
    }

    public JetUDBTreeNode getNodeByName(String string, Class clazz) {
        boolean bl;
        block5: {
            bl = false;
            try {
                bl = Class.forName("jet.universe.JetUResourceContainer").isAssignableFrom(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!IsAclNameOK.isErrorEnabled()) break block5;
                IsAclNameOK.error("", classNotFoundException);
            }
        }
        JetUDBTreeNode jetUDBTreeNode = null;
        if (bl) {
            Vector vector = this.getChildren();
            jetUDBTreeNode = JetUDBTreeNode.findNodeByName(vector, string, clazz.getName());
            if (jetUDBTreeNode == null) {
                jetUDBTreeNode = JetUDBTreeNode.findNodeByName(this.getConnection().B, string, clazz.getName());
            }
        } else {
            jetUDBTreeNode = this.getResourceByName(string);
        }
        return jetUDBTreeNode;
    }

    public JetUResourceContainer getContainerNodeByName(String string, Class clazz) {
        JetUResourceContainer jetUResourceContainer;
        block3: {
            boolean bl = false;
            jetUResourceContainer = null;
            try {
                Vector vector;
                bl = Class.forName("jet.universe.JetUResourceContainer").isAssignableFrom(clazz);
                if (bl && (jetUResourceContainer = (JetUResourceContainer)JetUDBTreeNode.findNodeByName(vector = this.getChildren(), string, clazz.getName())) == null && this.getConnection() != null) {
                    jetUResourceContainer = (JetUResourceContainer)JetUDBTreeNode.findNodeByName(this.getConnection().B, string, clazz.getName());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                if (!IsAclNameOK.isErrorEnabled()) break block3;
                IsAclNameOK.error("", classNotFoundException);
            }
        }
        return jetUResourceContainer;
    }

    public Vector getChildren(String string) {
        Vector vector = super.getChildren(string);
        if (vector.size() == 0 && this.getConnection() != null) {
            vector = this.getConnection().getChildren(string);
        }
        return vector;
    }

    public Vector getExtChildren(String string) {
        Vector vector = super.getExtChildren(string);
        if (vector.size() == 0 && this.getConnection() != null) {
            vector = this.getConnection().getExtChildren(string);
        }
        return vector;
    }

    public HashMap getIndecialMap() {
        return IsMappingNameExist;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$jet$universe$JetUDatabase == null ? (class$jet$universe$JetUDatabase = JetUDatabase.class$("jet.universe.JetUDatabase")) : class$jet$universe$JetUDatabase).desiredAssertionStatus();
        GetTableOrViewByRealName = 0;
        IsAclNameOK = JRLogger.getLogger((class$jet$universe$JetUDatabase == null ? (class$jet$universe$JetUDatabase = JetUDatabase.class$("jet.universe.JetUDatabase")) : class$jet$universe$JetUDatabase).getName());
        IsMappingNameExist = new HashMap(3);
        IsMappingNameExist.put("JavaFormulaName", new Integer(0));
        IsMappingNameExist.put("Description", new Integer(1));
        IsMappingNameExist.put("Name", new Integer(2));
    }
}

