/*
 * Decompiled with CFR 0.152.
 */
package toolkit.db.sql;

import java.util.Vector;
import toolkit.db.sql.NameFinder;
import toolkit.db.sql.PredicateBetween;
import toolkit.db.sql.PredicateComparison;
import toolkit.db.sql.PredicateExists;
import toolkit.db.sql.PredicateIn;
import toolkit.db.sql.PredicateLike;
import toolkit.db.sql.PredicateMatch;
import toolkit.db.sql.PredicateNull;
import toolkit.db.sql.PredicateOverlaps;
import toolkit.db.sql.PredicateQuantified;
import toolkit.db.sql.PredicateUnique;

public class Predicate {
    public static final int COMPARISON = 0;
    public static final int QANTIFIED = 1;
    public static final int BETWEEN = 2;
    public static final int IN = 3;
    public static final int LIKE = 4;
    public static final int NULL = 5;
    public static final int EXISTS = 6;
    public static final int UNIQUE = 7;
    public static final int MATCH = 8;
    public static final int OVERLAPS = 9;
    public int type = 0;
    public boolean localId = false;
    public boolean localResolved = false;
    public String expression = null;
    public boolean expResolved = false;
    public String fmlExpression = null;
    public boolean fmlResolved = false;
    public Object obj = null;

    public void setType(int n) {
        this.type = n;
    }

    public int getType() {
        return this.type;
    }

    public String getExpression() {
        switch (this.type) {
            case 0: {
                this.expression = ((PredicateComparison)this.obj).toString();
                break;
            }
            case 1: {
                this.expression = ((PredicateQuantified)this.obj).toString();
                break;
            }
            case 2: {
                this.expression = ((PredicateBetween)this.obj).toString();
                break;
            }
            case 3: {
                this.expression = ((PredicateIn)this.obj).toString();
                break;
            }
            case 4: {
                this.expression = ((PredicateLike)this.obj).toString();
                break;
            }
            case 5: {
                this.expression = ((PredicateNull)this.obj).toString();
                break;
            }
            case 6: {
                this.expression = ((PredicateExists)this.obj).toString();
                break;
            }
            case 7: {
                this.expression = ((PredicateUnique)this.obj).toString();
                break;
            }
            case 8: {
                this.expression = ((PredicateMatch)this.obj).toString();
                break;
            }
            case 9: {
                this.expression = ((PredicateOverlaps)this.obj).toString();
            }
        }
        return this.expression;
    }

    public boolean isLocal(NameFinder nameFinder) {
        if (nameFinder == null) {
            return this.localId;
        }
        switch (this.type) {
            case 0: {
                this.localId = ((PredicateComparison)this.obj).isLocal(nameFinder);
                break;
            }
            case 1: {
                this.localId = ((PredicateQuantified)this.obj).isLocal(nameFinder);
                break;
            }
            case 2: {
                this.localId = ((PredicateBetween)this.obj).isLocal(nameFinder);
                break;
            }
            case 3: {
                this.localId = ((PredicateIn)this.obj).isLocal(nameFinder);
                break;
            }
            case 4: {
                this.localId = ((PredicateLike)this.obj).isLocal(nameFinder);
                break;
            }
            case 5: {
                this.localId = ((PredicateNull)this.obj).isLocal(nameFinder);
                break;
            }
            case 6: {
                this.localId = ((PredicateExists)this.obj).isLocal(nameFinder);
                break;
            }
            case 7: {
                this.localId = ((PredicateUnique)this.obj).isLocal(nameFinder);
                break;
            }
            case 8: {
                this.localId = ((PredicateMatch)this.obj).isLocal(nameFinder);
                break;
            }
            case 9: {
                this.localId = ((PredicateOverlaps)this.obj).isLocal(nameFinder);
            }
        }
        return this.localId;
    }

    public void getSTW(Vector vector) {
        switch (this.type) {
            case 0: {
                ((PredicateComparison)this.obj).getSTW(vector);
                break;
            }
            case 4: {
                ((PredicateLike)this.obj).getSTW(vector);
                break;
            }
            case 5: {
                ((PredicateNull)this.obj).getSTW(vector);
            }
        }
    }

    public String toString() {
        return this.getExpression();
    }

    public String toFmlString() {
        switch (this.type) {
            case 0: {
                this.fmlExpression = ((PredicateComparison)this.obj).toFmlString();
                break;
            }
            case 1: {
                this.fmlExpression = ((PredicateQuantified)this.obj).toFmlString();
                break;
            }
            case 2: {
                this.fmlExpression = ((PredicateBetween)this.obj).toFmlString();
                break;
            }
            case 3: {
                this.fmlExpression = ((PredicateIn)this.obj).toFmlString();
                break;
            }
            case 4: {
                this.fmlExpression = ((PredicateLike)this.obj).toFmlString();
                break;
            }
            case 5: {
                this.fmlExpression = ((PredicateNull)this.obj).toFmlString();
                break;
            }
            case 6: {
                this.fmlExpression = ((PredicateExists)this.obj).toFmlString();
                break;
            }
            case 7: {
                this.fmlExpression = ((PredicateUnique)this.obj).toFmlString();
                break;
            }
            case 8: {
                this.fmlExpression = ((PredicateMatch)this.obj).toFmlString();
                break;
            }
            case 9: {
                this.fmlExpression = ((PredicateOverlaps)this.obj).toFmlString();
            }
        }
        return this.fmlExpression;
    }
}

