/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.web.util;

import com.jinfonet.web.FileService;
import com.jinfonet.web.util.ID;
import com.jinfonet.web.util.JProperties;
import com.jinfonet.web.util.StringUtil;
import com.jinfonet.web.util.Tools;
import com.jinfonet.web.util.json.JSONArray;
import com.jinfonet.web.util.json.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public final class FileUtil {
    public static final Pattern REGX_PATH = Pattern.compile("(.*[/|\\\\])(.*)");
    public static final Pattern REGX_FILE = Pattern.compile("(.*)\\.(.*)");
    public static final Pattern REGX_FILE2 = Pattern.compile("(.*)\\.(.*\\..*)");
    private static JProperties C;

    public static String getFilePath(String string) {
        if (string == null) {
            return string;
        }
        Matcher matcher = REGX_PATH.matcher(string);
        return matcher.matches() ? matcher.group(1) : "";
    }

    public static String getFileName(String string) {
        if (string == null) {
            return string;
        }
        Matcher matcher = REGX_PATH.matcher(string);
        return matcher.matches() ? matcher.group(2) : string;
    }

    public static String getFileNameWithoutSuffix(String string, Pattern ... patternArray) {
        String string2 = FileUtil.getFileName(string);
        if (string2 == null) {
            return string2;
        }
        Pattern pattern = patternArray.length >= 1 ? patternArray[0] : REGX_FILE;
        Matcher matcher = pattern.matcher(string2);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        if (pattern.equals(REGX_FILE)) {
            return string2;
        }
        return FileUtil.getFileNameWithoutSuffix(string, new Pattern[0]);
    }

    public static String getFileSuffix(String string, Pattern ... patternArray) {
        String string2 = FileUtil.getFileName(string);
        if (string2 == null) {
            return string2;
        }
        Pattern pattern = patternArray.length >= 1 ? patternArray[0] : REGX_FILE;
        Matcher matcher = pattern.matcher(string2);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        if (pattern.equals(REGX_FILE)) {
            return "";
        }
        return FileUtil.getFileSuffix(string, new Pattern[0]);
    }

    public static String getCanonicalPath(String string) {
        if (string == null) {
            return string;
        }
        char c = '/';
        if (string.indexOf(c) == -1) {
            c = File.separatorChar;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = StringUtil.split(string, c);
        int n = list.size();
        String string2 = (String)list.get(0);
        String string3 = 1 < n ? (String)list.get(1) : "";
        for (int i = 1; i <= n; ++i) {
            if (!(string2.equals("") || string2.equals("..") || string2.equals("."))) {
                arrayList.add(string2);
            }
            if (string3.equals("..") && arrayList.size() > 0) {
                arrayList.remove(arrayList.size() - 1);
            }
            string2 = string3;
            string3 = i + 1 < n ? (String)list.get(i + 1) : "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string4 : arrayList) {
            if (string4.indexOf(58) == -1) {
                stringBuilder.append(c);
            }
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    public static List listFiles(File file, FileFilter fileFilter, List arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<File>();
        }
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles(fileFilter != null ? fileFilter : new FileFilter(){

            @Override
            public boolean accept(File file) {
                return true;
            }
        });
        if (fileArray != null) {
            for (File file2 : fileArray) {
                arrayList.add(file2);
                if (!file2.isDirectory()) continue;
                FileUtil.listFiles(file2, fileFilter, arrayList);
            }
        }
        return arrayList;
    }

    public static List sortFilesByName(List list) {
        class FileNameComparator
        implements Comparator {
            FileNameComparator() {
            }

            public int compare(File file, File file2) {
                String string = file.getPath();
                String string2 = file2.getPath();
                return string.compareTo(string2);
            }
        }
        return Tools.sort(list, 0, new FileNameComparator());
    }

    public static List filterFiles(FileFilter fileFilter, List list) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (list == null) {
            return arrayList;
        }
        for (File file : list) {
            if (!fileFilter.accept(file)) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    public static long copyPath(String string, String string2, FileFilter fileFilter) throws IOException {
        string2 = string2.endsWith(File.separator) ? string2 : string2 + File.separator;
        long l = 0L;
        File file = new File(string);
        List list = FileUtil.listFiles(file, fileFilter, null);
        for (File file2 : list) {
            String string3 = file2.getPath();
            if (file2.isFile()) {
                l += FileUtil.copyFile(string3, string2 + string3.substring(string.length()));
                continue;
            }
            File file3 = new File(string2, string3.substring(string.length()));
            if (file3.exists()) continue;
            file3.mkdir();
        }
        return l;
    }

    public static long copyFile(String string, String string2) throws IOException {
        return FileUtil.copyFile(new File(string), new File(string2));
    }

    public static long copyFile(File file, File file2) throws IOException {
        if (file2.exists() && file2.lastModified() == file.lastModified()) {
            return 0L;
        }
        FileInputStream fileInputStream = null;
        OutputStream outputStream = null;
        long l = 0L;
        try {
            fileInputStream = new FileInputStream(file);
            outputStream = new FileOutputStream(file2);
            l = FileUtil.copyFile((InputStream)fileInputStream, outputStream);
            file2.setLastModified(file.lastModified());
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            try {
                ((InputStream)fileInputStream).close();
            }
            catch (Exception exception) {}
            try {
                outputStream.close();
            }
            catch (Exception exception) {}
        }
        return l;
    }

    public static long copyFile(InputStream inputStream, OutputStream outputStream) throws IOException {
        long l = 0L;
        byte[] byArray = new byte[2048];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        outputStream.flush();
        return l;
    }

    public static long copyFile(InputStream inputStream, String string) throws IOException {
        long l = 0L;
        File file = new File(string);
        if (!file.exists()) {
            file.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            l = FileUtil.copyFile(inputStream, fileOutputStream);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileOutputStream != null) {
                fileOutputStream.flush();
                ((OutputStream)fileOutputStream).close();
            }
        }
        return l;
    }

    public static void deletePath(String string) {
        if (string == null) {
            return;
        }
        File file = new File(string);
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            FileUtil.deleteFile(file);
        }
    }

    public static void deleteFile(File file) {
        if (!file.exists()) {
            return;
        }
        if (file.isFile()) {
            file.delete();
        } else {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    FileUtil.deleteFile(fileArray[i]);
                }
            }
            file.delete();
        }
    }

    public static URL getResource(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        string = string.replace('\\', '/');
        URL uRL = null;
        try {
            uRL = string.indexOf("file:") != -1 ? new URL(string) : new URL("file", "", "//" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(string);
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeJSON(Object object, String string) {
        InputStream inputStream = null;
        try {
            String string2 = "";
            if (object instanceof JSONObject.JSONObjectable) {
                string2 = ((JSONObject.JSONObjectable)object).toJSONObject().toString();
            } else if (object != null) {
                string2 = object.toString();
            }
            inputStream = new ByteArrayInputStream(string2.getBytes("UTF-8"));
            FileUtil.copyFile(inputStream, string);
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return false;
    }

    public static ID watchDir(File file) {
        List list = FileUtil.listFiles(file, null, null);
        StringBuilder stringBuilder = new StringBuilder();
        for (File file2 : list) {
            stringBuilder.append(file2.getName()).append(Long.toHexString(file2.lastModified()));
        }
        return Tools.getUniqueID(new String[]{stringBuilder.toString()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean buildZipFile(String string, List list) throws IOException {
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            for (int i = 0; i < list.size(); ++i) {
                File file = (File)list.get(i);
                try {
                    fileInputStream = new FileInputStream(file);
                    byte[] byArray = new byte[(int)file.length()];
                    int n = fileInputStream.read(byArray);
                    String string2 = FileUtil.getFileName(file.getName());
                    zipOutputStream.putNextEntry(new ZipEntry(string2));
                    zipOutputStream.write(byArray, 0, n);
                    zipOutputStream.closeEntry();
                    continue;
                }
                finally {
                    try {
                        fileInputStream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        finally {
            try {
                zipOutputStream.close();
            }
            catch (Throwable throwable) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JProperties C() {
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (C == null) {
                C = Tools.getProperties("file-extension.properties");
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return C;
        }
    }

    public static String getFileExtension(String string) {
        JProperties jProperties = FileUtil.C();
        if (jProperties != null) {
            return jProperties.getProperty(string);
        }
        return "";
    }

    public static boolean isValidFileName(String string) {
        if (string == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("[^\\\\:*?\"<>|\\/]*");
        Matcher matcher = pattern.matcher(string);
        return matcher.matches();
    }

    public static JSONArray getMIMETypeList() {
        JSONArray jSONArray = new JSONArray();
        JProperties jProperties = FileUtil.C();
        if (jProperties != null) {
            for (String string : jProperties.keySet()) {
                jSONArray.put(string);
            }
        }
        return jSONArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long writeStream(OutputStream outputStream, String string, FileService fileService, int n) {
        FileService.Handle handle = null;
        long l = 0L;
        int n2 = n <= 0 ? 4096 : n;
        try {
            byte[] byArray;
            int n3;
            handle = fileService.open(string, "r");
            while ((n3 = (byArray = fileService.read(handle, n2)).length) != 0) {
                outputStream.write(byArray, 0, n3);
                l += (long)n3;
            }
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {
            if (!(iOException.getCause() instanceof SocketException) && !(iOException instanceof FileNotFoundException)) {
                // empty if block
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                fileService.close(handle);
            }
            catch (Exception exception) {}
            try {
                outputStream.flush();
            }
            catch (Exception exception) {}
        }
        return l;
    }
}

