/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.datastream.DSContainable;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSPage;
import jet.datastream.DSSection;
import jet.datastream.DataStream;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.util.Containable;
import jet.util.IntVector;
import jet.util.TreeIterater;
import jet.util.VersionControlable;

public final class DSReference
extends JRObjectResult {
    JRObjectResult SEDU;
    int addElement = 0;
    int[] bufFile;
    int copyObject = 0;
    int dup = 0;
    private int elementAt = 0;

    private void SEDU(JRObjectResult jRObjectResult) {
        Object object = jRObjectResult;
        Containable containable = jRObjectResult.getParent();
        DSPage dSPage = null;
        IntVector intVector = new IntVector();
        while (containable != null) {
            intVector.addElement(containable.getChildren().indexOf(object));
            if (containable instanceof DSPage) {
                dSPage = (DSPage)containable;
                break;
            }
            object = containable;
            containable = ((JRObjectResult)((Object)containable)).getParent();
        }
        intVector.trimToSize();
        this.bufFile = intVector.getAllElements();
        this.addElement = dSPage.getPageNum();
    }

    public final void setRefData(JRObjectResult jRObjectResult) {
        this.SEDU = jRObjectResult;
        this.SEDU(jRObjectResult);
    }

    public final JRObjectResult getRefData() {
        JRVisiableResult jRVisiableResult = (JRVisiableResult)this.SEDU.copyObject();
        jRVisiableResult.setY(this.elementAt);
        return jRVisiableResult;
    }

    @Override
    protected final void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        this.addElement = dataInput.readShort();
        Communicator communicator = dSDataStreamable.getCommunicator();
        DataStream dataStream = (DataStream)communicator.getDataStream(0);
        if (dataInput instanceof VersionControlable) {
            DSPage dSPage = dataStream.getPage(this.addElement);
            int n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n < 262176 && n != 0) {
                this.copyObject = dataInput.readShort();
                this.dup = dataInput.readShort();
                Vector vector = dSPage.getChildren();
                DSSection dSSection = (DSSection)vector.elementAt(this.copyObject);
                TreeIterater treeIterater = new TreeIterater(dSSection, false);
                Object object = null;
                for (int i = 0; i <= this.dup; ++i) {
                    object = treeIterater.next();
                }
                this.SEDU = (JRObjectResult)object;
            } else {
                int n2 = dataInput.readShort();
                if (n2 > 0) {
                    this.bufFile = new int[n2];
                    for (int i = 0; i < n2; ++i) {
                        this.bufFile[i] = dataInput.readShort();
                    }
                }
                this.SEDU = DSReference.addElement(dSPage, this.bufFile);
            }
            if (n > 263184 || n == 0) {
                this.elementAt = dataInput.readInt();
            }
        }
        if (dataStream.bufFile != null) {
            dataStream.bufFile.seek(dataStream.bufFile.getPosition());
        }
    }

    private static JRObjectResult addElement(DSPage dSPage, int[] nArray) {
        int n = nArray.length;
        if (n < 1) {
            return null;
        }
        DSPage dSPage2 = dSPage;
        Vector vector = null;
        for (int i = n - 1; i >= 0; --i) {
            if (dSPage2 instanceof DSContainable) {
                vector = ((DSContainable)dSPage2).getChildren();
                if (vector == null || vector.size() <= nArray[i]) {
                    return null;
                }
            } else {
                return null;
            }
            dSPage2 = vector.elementAt(nArray[i]);
        }
        return (JRObjectResult)((Object)dSPage2);
    }

    @Override
    protected final void writeProperties(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.addElement);
        int n = this.bufFile == null ? 0 : this.bufFile.length;
        dataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            dataOutput.writeShort(this.bufFile[i]);
        }
        dataOutput.writeInt(this.elementAt);
    }

    @Override
    protected int propLength() {
        int n = 0;
        n += 4;
        if (this.bufFile != null) {
            n += 2 * this.bufFile.length;
        }
        return n += 4;
    }

    @Override
    public final int getObjectType() {
        return 8192;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSReference());
    }

    public DSReference dup(DSReference dSReference) {
        super.dup(dSReference);
        dSReference.SEDU = this.SEDU;
        dSReference.addElement = this.addElement;
        dSReference.copyObject = this.copyObject;
        dSReference.dup = this.dup;
        if (this.bufFile != null) {
            int n = this.bufFile.length;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                nArray[i] = this.bufFile[i];
            }
            dSReference.bufFile = nArray;
        }
        dSReference.elementAt = this.elementAt;
        return dSReference;
    }

    public int getYPos() {
        return this.elementAt;
    }

    public void setYPos(int n) {
        this.elementAt = n;
    }
}

