/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.CellStyle;
import jet.export.excel.api.ExcelCell;
import jet.export.excel.api.HyperLink;
import jet.export.excel.imp.xlsx.CellStyleImp;
import jet.export.excel.imp.xlsx.Link;
import jet.export.excel.imp.xlsx.Links;
import jet.export.excel.imp.xlsx.Merges;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.util.Util;

public abstract class Cell
implements ExcelCell {
    private int add;
    private short append;
    private CellStyleImp colNumToStr;
    private int dumpValue = -1;
    private int loadValue = 1;
    private short readBoolean = 1;
    private Link readInt;
    private boolean readShort = false;
    private Cell toString;
    private Cell valueOf;

    public Cell(int n, short s) {
        this.add = n;
        this.append = s;
    }

    void I(Cell cell) {
        this.toString = cell;
    }

    Cell I() {
        return this.toString;
    }

    void Z(Cell cell) {
        this.valueOf = cell;
    }

    Cell Z() {
        return this.valueOf;
    }

    public short getColSpan() {
        return this.readBoolean;
    }

    public int getRowSpan() {
        return this.loadValue;
    }

    public void merge(int n, short s) {
        this.loadValue = n;
        this.readBoolean = s;
    }

    public void setHyperLink(Link link) {
        this.readInt = link;
    }

    @Override
    public HyperLink getHyperLink() {
        return this.readInt;
    }

    public CellStyleImp getStyle() {
        return this.colNumToStr;
    }

    void I(int n) {
        this.dumpValue = n;
        this.colNumToStr = null;
    }

    public int getRowNum() {
        return this.add;
    }

    public short getColNum() {
        return this.append;
    }

    void write(XMLStreamWriter xMLStreamWriter, Links links, Merges merges, boolean bl) throws XlsxDocumentException {
        try {
            if (this.loadValue > 1 || this.readBoolean > 1) {
                merges.add(new Object[]{new int[]{this.add, this.add + this.loadValue - 1}, new short[]{this.append, (short)(this.append + this.readBoolean - 1)}});
            }
            if (this.readInt != null) {
                links.add(new Object[]{this.add, this.append, this.readInt});
            }
            xMLStreamWriter.writeStartElement("c");
            if (bl) {
                xMLStreamWriter.writeAttribute("r", Util.colNumToStr(this.append) + (this.add + 1));
            }
            if (this.dumpValue != -1) {
                xMLStreamWriter.writeAttribute("s", String.valueOf(this.dumpValue));
            }
            this.writeValue(xMLStreamWriter);
            xMLStreamWriter.writeEndElement();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
        catch (IOException iOException) {
            throw new XlsxDocumentException(iOException);
        }
    }

    void I(DataOutput dataOutput) throws IOException {
        this.dumpValue(dataOutput);
        dataOutput.writeInt(this.dumpValue);
        dataOutput.writeInt(this.loadValue);
        dataOutput.writeShort(this.readBoolean);
        if (this.readInt != null) {
            dataOutput.writeBoolean(true);
            this.readInt.I(dataOutput);
        } else {
            dataOutput.writeBoolean(false);
        }
    }

    void I(DataInput dataInput) throws IOException {
        this.loadValue(dataInput);
        this.dumpValue = dataInput.readInt();
        this.loadValue = dataInput.readInt();
        this.readBoolean = dataInput.readShort();
        if (dataInput.readBoolean()) {
            this.readInt = new Link();
            this.readInt.I(dataInput);
        }
        this.readShort = true;
    }

    static void skip(DataInput dataInput) throws IOException {
        dataInput.readInt();
        dataInput.readInt();
        dataInput.readShort();
        if (dataInput.readBoolean()) {
            Link.skip(dataInput);
        }
    }

    boolean C() {
        return this.readShort;
    }

    @Override
    public void setCellStyle(CellStyle cellStyle) {
        this.colNumToStr = (CellStyleImp)cellStyle;
    }

    @Override
    public void setColSpan(int n) {
        this.readBoolean = (short)n;
    }

    @Override
    public void setHyperLink(HyperLink hyperLink) {
        this.readInt = (Link)hyperLink;
    }

    @Override
    public void setRowSpan(int n) {
        this.loadValue = n;
    }

    @Override
    public CellStyle getCellStyle() {
        return this.colNumToStr;
    }

    @Override
    public int getCol() {
        return this.append;
    }

    @Override
    public int getRow() {
        return this.add;
    }

    abstract void writeValue(XMLStreamWriter var1) throws XMLStreamException;

    abstract void dumpValue(DataOutput var1) throws IOException;

    abstract void loadValue(DataInput var1) throws IOException;
}

