/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx.chart;

import java.util.Vector;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.api.chart.ChartAreaInfo;
import jet.export.excel.api.chart.ChartInfo;
import jet.export.excel.api.chart.ChartPlotAreaInfo;
import jet.export.excel.api.chart.LegendInfo;
import jet.export.excel.api.chart.TitleInfo;
import jet.export.excel.imp.xlsx.ChartDrawingPart;
import jet.export.excel.imp.xlsx.NoneRelsPart;
import jet.export.excel.imp.xlsx.OPCPackage;
import jet.export.excel.imp.xlsx.PictureShape;
import jet.export.excel.imp.xlsx.SimpleShape;
import jet.export.excel.imp.xlsx.XlsxDocumentException;
import jet.export.excel.imp.xlsx.chart.ChartAreaProps;
import jet.export.excel.imp.xlsx.chart.DataTable;
import jet.export.excel.imp.xlsx.chart.Legend;
import jet.export.excel.imp.xlsx.chart.PlotArea;
import jet.export.excel.imp.xlsx.chart.Title;
import jet.export.excel.imp.xlsx.shapeprops.FillStyle;
import jet.export.excel.imp.xlsx.shapeprops.LineStyle;
import jet.export.excel.imp.xlsx.shapeprops.NoFill;
import jet.export.excel.imp.xlsx.shapeprops.Paragraph;
import jet.export.excel.imp.xlsx.shapeprops.RelativeSizeAnchor;
import jet.export.excel.imp.xlsx.shapeprops.Shadow;
import jet.export.excel.imp.xlsx.shapeprops.TextBody;
import jet.export.excel.imp.xlsx.shapeprops.TextRunProps;

public abstract class ChartArea
implements ChartInfo {
    protected PlotArea plotArea;
    private Legend SEDU;
    private Title add;
    private Vector addNoneRelsPart = new Vector(0);
    private ChartAreaProps addPicture;
    private boolean addSimpleShape = false;

    public void setLegend(Legend legend) {
        this.SEDU = legend;
    }

    public void setTitle(Title title) {
        this.add = title;
    }

    public void setPlotArea(PlotArea plotArea) {
        this.plotArea = plotArea;
    }

    public void addPicture(PictureShape pictureShape, RelativeSizeAnchor relativeSizeAnchor) {
        this.addNoneRelsPart.add(new Object[]{pictureShape, relativeSizeAnchor});
    }

    public void addSimpleShape(SimpleShape simpleShape, RelativeSizeAnchor relativeSizeAnchor) {
        this.addNoneRelsPart.add(new Object[]{simpleShape, relativeSizeAnchor});
    }

    protected void prepareWriting() {
        if (this.plotArea == null) {
            this.plotArea = new PlotArea();
        }
        if (this.addSimpleShape) {
            this.plotArea.setDataTable(new DataTable());
        }
    }

    public void write(OPCPackage oPCPackage, XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        this.prepareWriting();
        try {
            xMLStreamWriter.writeStartDocument(oPCPackage.getEncoding(), "1.0");
            xMLStreamWriter.setPrefix("c", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.setPrefix("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.setPrefix("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            xMLStreamWriter.writeStartElement("c", "chartSpace", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.writeNamespace("c", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.writeNamespace("a", "http://schemas.openxmlformats.org/drawingml/2006/main");
            xMLStreamWriter.writeNamespace("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships");
            if (this.addPicture != null && this.addPicture.getIsRoundCorner()) {
                xMLStreamWriter.writeEmptyElement("c", "roundedCorners", "http://schemas.openxmlformats.org/drawingml/2006/chart");
                xMLStreamWriter.writeAttribute("val", "1");
            }
            xMLStreamWriter.writeStartElement("c", "chart", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            if (this.add != null) {
                this.add.write(xMLStreamWriter, noneRelsPart);
            } else {
                Title title = new Title();
                title.setValue("");
                title.setAreaInfo(new NoFill());
                title.write(xMLStreamWriter, noneRelsPart);
            }
            this.write3DProps(xMLStreamWriter, noneRelsPart);
            this.plotArea.write(xMLStreamWriter, noneRelsPart);
            if (this.SEDU != null) {
                this.SEDU.write(xMLStreamWriter, noneRelsPart);
            }
            xMLStreamWriter.writeEndElement();
            if (this.addPicture != null) {
                this.addPicture.I(xMLStreamWriter, noneRelsPart);
            }
            this.SEDU(xMLStreamWriter, noneRelsPart);
            xMLStreamWriter.writeEndElement();
            xMLStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    private void SEDU(XMLStreamWriter xMLStreamWriter, NoneRelsPart noneRelsPart) throws XlsxDocumentException {
        try {
            if (this.addNoneRelsPart.size() == 0) {
                return;
            }
            OPCPackage oPCPackage = noneRelsPart.getPack();
            int n = oPCPackage.getDrawingCount() + 1;
            oPCPackage.setDrawingCount(n);
            ChartDrawingPart chartDrawingPart = new ChartDrawingPart(oPCPackage, n);
            String string = noneRelsPart.getRelsPart(true).addNoneRelsPart(chartDrawingPart);
            xMLStreamWriter.writeEmptyElement("c", "userShapes", "http://schemas.openxmlformats.org/drawingml/2006/chart");
            xMLStreamWriter.writeAttribute("r", "http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id", string);
            for (Object[] objectArray : this.addNoneRelsPart) {
                if (objectArray[0] instanceof PictureShape) {
                    chartDrawingPart.addPicture((PictureShape)objectArray[0], (RelativeSizeAnchor)objectArray[1]);
                    continue;
                }
                if (!(objectArray[0] instanceof SimpleShape)) continue;
                chartDrawingPart.addSimpleShape((SimpleShape)objectArray[0], (RelativeSizeAnchor)objectArray[1]);
            }
        }
        catch (XMLStreamException xMLStreamException) {
            throw new XlsxDocumentException(xMLStreamException);
        }
    }

    abstract void write3DProps(XMLStreamWriter var1, NoneRelsPart var2) throws XlsxDocumentException;

    @Override
    public void setChartAreaInfo(ChartAreaInfo chartAreaInfo) {
        this.addPicture = (ChartAreaProps)chartAreaInfo;
    }

    @Override
    public void setChartLegend(LegendInfo legendInfo) {
        this.SEDU = (Legend)legendInfo;
    }

    @Override
    public void setChartPlotInfo(ChartPlotAreaInfo chartPlotAreaInfo) {
        this.plotArea = (PlotArea)chartPlotAreaInfo;
    }

    @Override
    public void setChartTitle(TitleInfo titleInfo) {
        this.setTitle((Title)titleInfo);
    }

    @Override
    public void setIsShowDataTable(boolean bl) {
        this.addSimpleShape = bl;
    }

    @Override
    public TitleInfo getChartTitle() {
        return this.add;
    }

    @Override
    public boolean addTextBox(TitleInfo titleInfo) {
        Object object;
        FillStyle fillStyle;
        SimpleShape simpleShape = new SimpleShape(2);
        Title title = (Title)titleInfo;
        LineStyle lineStyle = title.getBorder();
        if (lineStyle != null) {
            simpleShape.setBorder(lineStyle);
        }
        if ((fillStyle = title.getFillStyle()) != null) {
            simpleShape.setFillStyle(fillStyle);
        }
        if (title.getHasShadow()) {
            simpleShape.setShadow(Shadow.createDefaultShadow());
        }
        String string = title.getText();
        TextRunProps textRunProps = title.getTextProps();
        short s = title.getTextRotation();
        if (string != null || textRunProps != null || s != -91) {
            object = new Paragraph();
            if (string != null) {
                ((Paragraph)object).addTextRun(string, null);
            }
            if (textRunProps != null) {
                ((Paragraph)object).setDefaultRunProps(textRunProps);
            }
            TextBody textBody = new TextBody((Paragraph)object);
            if (s != -91) {
                textBody.setRotation(s);
            }
            simpleShape.setTextBody(textBody);
        }
        object = null;
        if (title.getIsPositionSet()) {
            double d = title.getX();
            double d2 = title.getY();
            double d3 = title.getX() + title.getWidth();
            double d4 = title.getY() + title.getHeight();
            if (d < 0.0) {
                d = 0.0;
            } else if (d > 1.0) {
                d = 1.0;
            }
            if (d2 < 0.0) {
                d2 = 0.0;
            } else if (d2 > 1.0) {
                d2 = 1.0;
            }
            if (d3 < 0.0) {
                d3 = 0.0;
            } else if (d3 > 1.0) {
                d3 = 1.0;
            }
            if (d4 < 0.0) {
                d4 = 0.0;
            } else if (d4 > 1.0) {
                d4 = 1.0;
            }
            object = new RelativeSizeAnchor(d, d2, d3, d4);
        } else {
            object = new RelativeSizeAnchor(0.0, 0.0, 0.5, 0.5);
        }
        this.addSimpleShape(simpleShape, (RelativeSizeAnchor)object);
        return true;
    }

    @Override
    public void setWidthAndHeight(float f, float f2) {
    }
}

