/*
 * Decompiled with CFR 0.152.
 */
package jet.export.ps;

import com.jinfonet.awt.ps.PSPrinter;
import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import jet.JRStopEngineException;
import jet.bean.PSParameter;
import jet.datastream.Communicator;
import jet.export.AbstractExporter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.ps.PSCache;
import jet.export.ps.PSTransfer;
import jet.export.util.ExportUtil;

public class ExportToPS
extends AbstractExporter {
    public static final String EXP = ".ps";
    private String SEDU;
    private OutputStream add;
    private PSPrinter append;
    private PSParameter checkStop;
    private ExportAuxInfo close;

    public ExportToPS(Communicator[] communicatorArray, PSParameter pSParameter) {
        this._commuList = communicatorArray;
        this.checkStop = pSParameter;
    }

    @Override
    public List exportToFile(String string) throws ExpException, JRStopEngineException {
        this._commu(string);
        ArrayList arrayList = null;
        try {
            File file = this.close.getDiskStore().createFile(this.SEDU);
            arrayList = this.SEDU(true);
            this.close.getDiskStore().fileUpdated(file);
        }
        catch (OutOfSpaceException outOfSpaceException) {
            throw new ExpException(outOfSpaceException);
        }
        catch (IOException iOException) {
            throw new ExpException(iOException);
        }
        return arrayList;
    }

    private ArrayList SEDU(boolean bl) throws ExpException, JRStopEngineException {
        JRLog.indent("Export to PS");
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, "Start build PS report...");
        }
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            this.append = bl ? new PSPrinter(new File(this.SEDU), this.checkStop.isNoMargin()) : new PSPrinter(this.add, this.checkStop.isNoMargin());
            this.append.startDoc();
            for (int i = 0; i < this._commuList.length; ++i) {
                this._commu = this._commuList[i];
                if (this._commu == null) continue;
                PSTransfer pSTransfer = new PSTransfer(this._commu, this.checkStop);
                pSTransfer.setExportInfo(new PSCache(this.close, "PostScript"));
                pSTransfer.setPrinter(this.append);
                pSTransfer.publish();
            }
        }
        catch (Exception exception) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "Export report to PS format error!", (Throwable)exception);
            }
            ExportUtil.checkStop(this._commu);
            throw new ExpException(exception);
        }
        finally {
            if (this.append != null) {
                this.append.close();
            }
        }
        if (JRLog.isTrace(4)) {
            JRLog.trace(4, "finshed build PS report...");
        }
        if (JRLog.isAd()) {
            JRLog.print("Successed produce postscript");
        }
        JRLog.deIndent("Export to PS");
        arrayList.add(this.SEDU);
        return arrayList;
    }

    @Override
    public void exportToStream(OutputStream outputStream) throws ExpException, JRStopEngineException {
        this._commuList(outputStream);
        this.SEDU(false);
    }

    private void _commu(String string) throws ExpException {
        File file = new File(string);
        if (!(file = file.getParentFile()).exists() || file.isFile()) {
            if (JRLog.isError(2)) {
                JRLog.error(2, 4406004, string);
            }
            throw new ExpException(406003);
        }
        file = null;
        if (!string.endsWith(EXP)) {
            string = string + EXP;
        }
        this.SEDU = string;
        this.add = null;
    }

    private void _commuList(OutputStream outputStream) throws ExpException {
        if (outputStream == null) {
            throw new ExpException(406004);
        }
        this.add = outputStream;
        this.SEDU = null;
    }

    @Override
    public void setAuxiliaryInfo(ExportAuxInfo exportAuxInfo) {
        this.close = exportAuxInfo;
    }
}

