/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.Painter;
import guitools.toolkit.FigurePeer;
import guitools.toolkit.TComponent;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import jet.connect.Record;
import jet.datastream.JRObjectResult;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.ExportingInfo;
import jet.thinviewer.JReportObjectRender;
import jet.util.PropertySetable;
import jet.util.image.ImageResource;

public class JReportGTBox
extends TComponent
implements JReportObjectRender,
FigurePeer {
    Color Z;
    Color C;
    int B;
    int D;
    protected int resolution;
    private ExportingInfo convertUnitToPixel;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        JRObjectResult jRObjectResult = (JRObjectResult)propertySetable;
        this.resolution = jRObjectResult.getResolution();
        this.C = this.getColorPropertyByName(jRObjectResult, "Background");
        this.Z = this.getColorPropertyByName(jRObjectResult, "BorderColor");
        this.B = this.getIntPropertyByName(jRObjectResult, "BorderWidth");
        this.D = this.getIntPropertyByName(jRObjectResult, "BorderStyle");
        this.B = Unit.convertUnitToPixel(this.B, this.resolution);
        this.setEraser(this.C != null);
    }

    @Override
    public void paintShape(Graphics graphics) {
        Dimension dimension = this.getSize();
        Painter.drawBox(graphics, 0, 0, dimension.width, dimension.height, null, this.Z, this.B, this.D);
    }

    @Override
    public void paintInterior(Graphics graphics) {
        if (this.C != null) {
            Dimension dimension = this.getSize();
            Painter.drawBox(graphics, 0, 0, dimension.width, dimension.height, this.C, this.Z, 0, 0);
        }
    }

    public void setProperty(PropertySetable propertySetable, Record record) {
    }

    protected Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    protected boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    protected int getIntPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getIntPropertyByName(jRObjectResult, string);
    }

    protected Image getImagePropertyByName(JRObjectResult jRObjectResult, String string) {
        ImageResource imageResource = CCUtil.getImagePropertyByName(jRObjectResult, string);
        if (imageResource == null) {
            return null;
        }
        return imageResource.getImage();
    }

    protected String getStringPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getStringPropertyByName(jRObjectResult, string);
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
    }

    @Override
    public void setLcView(boolean bl) {
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
        this.convertUnitToPixel = exportingInfo;
    }
}

