/*
 * Decompiled with CFR 0.152.
 */
package chart.axis;

import chart.ChartEnv;
import chart.ChartLabelBase;
import chart.axis.ChartNumericAxis;
import chart.data.ChartDataFilter;
import chart.graphics.ChartTextStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartMath;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;

public class ChartNumericRadarAxis
extends ChartNumericAxis {
    private ChartDataFilter F;
    private List SEDU;
    private ChartTextStyle WORDWRAPPER_GAP;
    private ChartLabelBase[] drawAxis;
    private float[][] drawLabels;
    private float[][] drawTickMark;
    private Line2D.Float[] get;
    private boolean getChartTextStyle;
    private float[][] getDimension;

    public ChartNumericRadarAxis(ChartNumericAxisProperties chartNumericAxisProperties, double d, double d2, List list, ChartTextStyle chartTextStyle) {
        super(chartNumericAxisProperties, d, d2);
        this.SEDU = list;
        this.WORDWRAPPER_GAP = chartTextStyle;
        this.WORDWRAPPER_GAP.setRotation(0.0);
    }

    @Override
    public void init() {
        super.init();
        boolean bl = this.getChartTextStyle = this.SEDU != null && this.SEDU.size() != 0 && this.getChartTextStyle;
        if (this.getChartTextStyle) {
            this.drawTickMark = new float[this.SEDU.size()][2];
            this.drawAxis = new ChartLabelBase[this.SEDU.size()];
            for (int i = 0; i < this.SEDU.size(); ++i) {
                String string = this.SEDU.get(i) == null ? "" : (this.F != null ? this.F.filter(this.SEDU.get(i), i) : this.SEDU.get(i).toString());
                this.drawAxis[i] = new ChartLabelBase(string);
                this.drawAxis[i].setChartTextStyle(this.WORDWRAPPER_GAP);
            }
        }
    }

    @Override
    public void locate() {
        super.locate();
        if (this.getChartTextStyle) {
            this.SEDU();
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.locate();
        float[][] fArray = new float[2][2];
        fArray[0][0] = this.getDimension[0][0];
        fArray[0][1] = this.getDimension[0][1];
        for (int i = 0; i < this.getDimension.length - 1; ++i) {
            if (i == 0) {
                if (this.properties.isShowTickMarkLabels()) {
                    super.drawLabels(graphics2D);
                }
                if (this.getChartTextStyle) {
                    this.F(graphics2D);
                }
                if (this.properties.getTickMarkType() != 0) {
                    this.numOfTicks = this.labelPoint.length;
                    super.drawTickMark(graphics2D, this.properties.getTickMarkPen(), this.labelPoint, this.properties.getTickMarkLength(), this.properties.getTickMarkType(), this.numOfTicks);
                }
            }
            fArray[1][0] = this.getDimension[i + 1][0];
            fArray[1][1] = this.getDimension[i + 1][1];
            super.drawAxis(graphics2D, fArray);
        }
    }

    private void F(Graphics2D graphics2D) {
        for (int i = 0; i < this.drawAxis.length; ++i) {
            this.drawAxis[i].locate();
            this.drawAxis[i].paint(graphics2D, this.drawTickMark[i][0], this.drawTickMark[i][1]);
        }
    }

    private void SEDU() {
        for (int i = 0; i < this.drawAxis.length; ++i) {
            this.drawAxis[i].locate();
            Rectangle2D.Float float_ = (Rectangle2D.Float)this.WORDWRAPPER_GAP.getDimension(this.drawAxis[i].getLabelText());
            this.drawTickMark[i] = this.WORDWRAPPER_GAP(this.drawLabels[i], float_.width, float_.height, i);
        }
    }

    private float[] WORDWRAPPER_GAP(float[] fArray, float f, float f2, int n) {
        double d = Math.PI;
        float[] fArray2 = new float[2];
        int n2 = ChartEnv.WORDWRAPPER_GAP;
        float f3 = this.drawAxis.length;
        double d2 = d * 2.0 / (double)f3 * (double)n;
        if (d2 % d == 0.0) {
            fArray2[0] = fArray[0] - f / 2.0f;
            fArray2[1] = fArray[1];
        } else if (d2 < d) {
            fArray2[0] = fArray[0] - f;
            fArray2[1] = fArray[1];
        } else if (ChartMath.isEquals(d2, 1.5 * d)) {
            fArray2[0] = fArray[0];
            fArray2[1] = fArray[1];
        } else {
            fArray2[0] = fArray[0];
            fArray2[1] = fArray[1] - f2;
        }
        if (ChartMath.isEquals(d2, d / 2.0) || ChartMath.isEquals(d2, 1.5 * d)) {
            fArray2[1] = fArray2[1] - f2 / 2.0f;
        } else if (d2 < d / 2.0) {
            fArray2[1] = fArray2[1] - f2;
        } else if (d2 > d && d2 < 1.5 * d) {
            fArray2[1] = fArray2[1] + f2;
        }
        return fArray2;
    }

    @Override
    public Dimension getMaxDimensionOfLabels() {
        Dimension dimension = new Dimension();
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.drawAxis == null) {
            return dimension;
        }
        for (int i = 0; i < this.drawAxis.length; ++i) {
            Rectangle2D.Float float_ = (Rectangle2D.Float)this.WORDWRAPPER_GAP.getDimension(this.drawAxis[i].getLabelText());
            f2 = float_.width > f2 ? float_.width : f2;
            f = float_.height > f ? float_.height : f2;
        }
        dimension.width = (int)f2;
        dimension.height = (int)f;
        return dimension;
    }

    public Line2D[] getRadarAxisAreaPath() {
        return this.get;
    }

    public void setRadarAxisAreaPath(Line2D.Float[] floatArray) {
        this.get = floatArray;
    }

    @Override
    public boolean searchSelectedAxis(int n, int n2) {
        if (this.get != null) {
            for (int i = 0; i < this.get.length; ++i) {
                if (!this.get[i].intersects(n - 5, n2 - 5, 10.0, 10.0)) continue;
                return true;
            }
        }
        return false;
    }

    public void setIsShowRadarColumnName(boolean bl) {
        this.getChartTextStyle = bl;
    }

    public boolean getIsShowRadarColumnName() {
        return this.getChartTextStyle;
    }

    public void setRadarColumnNamePosition(float[][] fArray) {
        this.drawLabels = fArray;
    }

    @Override
    public void setAxisPoint(float[][] fArray) {
        this.getDimension = fArray;
    }

    public float[][] getAxisPoint() {
        return this.getDimension;
    }

    public Dimension getMaxDimensionOfCategoryLabels() {
        int n;
        Dimension dimension = new Dimension();
        dimension.width = 0;
        dimension.height = 0;
        boolean bl = false;
        if (this.drawAxis != null && (n = this.drawAxis.length) != 0) {
            ChartTextStyle chartTextStyle = this.drawAxis[0].getChartTextStyle();
            if (n == 1) {
                if (this.drawAxis[0] != null) {
                    Rectangle2D.Float float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.drawAxis[0].getLabelText());
                    dimension.width = (int)(float_.width / 2.0f);
                    dimension.height = (int)float_.height;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    Rectangle2D.Float float_;
                    if (this.drawAxis[i] == null || (float_ = (Rectangle2D.Float)chartTextStyle.getDimension(this.drawAxis[i].getLabelText())) == null) continue;
                    float f = float_.width > (float)dimension.width ? float_.width : (float)dimension.width;
                    float f2 = float_.height > (float)dimension.height ? float_.height : (float)dimension.height;
                    dimension.width = (int)f;
                    dimension.height = (int)f2;
                }
            }
        }
        return dimension;
    }

    public ChartDataFilter getCategoryFilter() {
        return this.F;
    }

    public void setCategoryFilter(ChartDataFilter chartDataFilter) {
        this.F = chartDataFilter;
    }
}

