/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartCategoryAxis;
import chart.chart3d.Chart3DObject;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartCube;
import chart.chart3d.ChartMatrix;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.data.ChartTypeInfo;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.util.List;

public class Graph3DBarSt
extends Chart3DObject {
    ChartDataSet addVertex;
    protected int[] grpIdx;
    protected int[][] barIdx;
    protected boolean contour;
    private ChartPenStyle availableLength;
    private ChartCompass custommerConstant;
    ChartCube[][] draw1;
    boolean[][] draw2;
    int floatValue;
    protected ChartMatrix tempM = new ChartMatrix();
    private boolean get;
    private boolean getAbsoluteValueSumOfCategory;
    private boolean getAxisX1;
    int[] getBarWidth;
    protected ChartMatrix matrix;
    protected int col;
    protected int row;
    protected int numofTicks;
    protected ChartFillPattern[] pattern;
    float[] getCategoryName;
    int getCategorySize = 2;
    float[] getChartDataSet;
    Color[] getChartDataSetInfo;
    float getChartDataSetModel = 0.6f;
    boolean[][] getChartLink;
    private boolean getChartLinkInfo;
    private ChartShowValueCondition getChartPlatform = null;

    Graph3DBarSt(ChartDataSet chartDataSet, Chart3DPaper chart3DPaper) {
        super(chartDataSet, chart3DPaper);
        this.addVertex = chartDataSet;
        this.getBarWidth = chart3DPaper.getIntType();
        this.paper = chart3DPaper;
        this.col = chartDataSet.getCategorySize();
        this.row = chartDataSet.getSeriesSize();
        this.pattern = chart3DPaper.getChartPlatform().getFillPatternByArarry(0);
        this.getChartDataSetModel = chart3DPaper.getProperties().getGraphProperties().getThresholdFillTransparency();
    }

    @Override
    public void init() {
        Object object;
        int n;
        int n2;
        int n3 = this.dataset.getChartDataSetInfo().getChartType();
        int n4 = ChartTypeInfo.getPrimType(n3);
        this.getChartLinkInfo = n4 == 1;
        this.setCompass(this.paper.getCompass());
        this.contour = this.paper.getProperties().getGraphProperties().isContour();
        this.availableLength = this.properties.getGraphProperties().getContourPen();
        this.draw1 = new ChartCube[this.row][this.col];
        this.getCategoryName = this.paper.getUnit();
        this.getCategoryName[2] = this.paper.getLength()[2] / 2.0f;
        float f = this.getCategoryName[0] * this.paper.getProperties().getGraphProperties().getBarWidth();
        float f2 = this.getCategoryName[0] / 2.0f + f / 2.0f;
        float f3 = this.getCategoryName[2];
        float f4 = 0.0f;
        float f5 = 0.0f;
        float[][] fArray = new float[this.row][this.col];
        this.draw2 = new boolean[this.row][this.col];
        this.getChartLink = new boolean[this.row][this.col];
        float[] fArray2 = new float[this.col];
        if (this.dataset.getChartDataSetModel().isOneGroupForBar()) {
            for (n2 = 0; n2 < this.col; ++n2) {
                for (n = 0; n < this.col; ++n) {
                    fArray2[n2] = fArray2[n2] + (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n);
                }
            }
        } else {
            for (n2 = 0; n2 < this.col; ++n2) {
                fArray2[n2] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(n2);
            }
        }
        for (n2 = 0; n2 < this.row; ++n2) {
            for (n = 0; n < this.col; ++n) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    fArray[n2][n] = 0.0f;
                    continue;
                }
                fArray[n2][n] = !((ChartNumericAxisProperties)this.paper.C.getProperties()).getIsShowPercent() ? number.floatValue() : number.floatValue() / fArray2[n];
                if (!(fArray[n2][n] < 0.0f)) continue;
                this.draw2[n2][n] = true;
            }
        }
        this.getChartLink = ((Chart1DDataSet)this.dataset).isNullValue();
        if (this.paper.getProperties().getGraphProperties().isShowThresholdLine() && this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.getCategorySize = 2;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetInfo = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.getChartDataSet[1] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.getChartDataSetInfo[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
            this.getChartDataSetInfo[1] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine()) {
            this.getCategorySize = 1;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetInfo = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue();
            this.getChartDataSetInfo[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor();
        } else if (this.paper.getProperties().getGraphProperties().isShowThresholdLine2()) {
            this.getCategorySize = 1;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetInfo = new Color[this.getCategorySize];
            this.getChartDataSet[0] = (float)this.paper.getProperties().getGraphProperties().getThresholdValue2();
            this.getChartDataSetInfo[0] = this.paper.getProperties().getGraphProperties().getThresholdLineColor2();
        } else {
            this.getCategorySize = 0;
            this.getChartDataSet = new float[this.getCategorySize];
            this.getChartDataSetInfo = new Color[this.getCategorySize];
        }
        for (n2 = 0; n2 < this.getCategorySize; ++n2) {
            float f6 = 0.0f;
            for (int i = n2; i < this.getCategorySize; ++i) {
                if (!(this.getChartDataSet[n2] > this.getChartDataSet[i])) continue;
                f6 = this.getChartDataSet[i];
                this.getChartDataSet[i] = this.getChartDataSet[n2];
                this.getChartDataSet[n2] = f6;
                object = this.getChartDataSetInfo[i];
                this.getChartDataSetInfo[i] = this.getChartDataSetInfo[n2];
                this.getChartDataSetInfo[n2] = object;
            }
        }
        float[] fArray3 = new float[this.getCategorySize];
        for (int i = 0; i < this.getCategorySize; ++i) {
            fArray3[i] = this.paper.availableLength(this.getChartDataSet[i] * this.getCategoryName[1]);
            if (!(fArray3[i] < 2.0f) || fArray3[i] == 0.0f) continue;
            fArray3[i] = fArray3[i] + 5.0f;
        }
        float f7 = 0.0f;
        float f8 = this.paper.getLength()[2] / 2.0f + f3 / 2.0f;
        object = (ChartCategoryAxis)this.paper.getAxisX1();
        float f9 = this.properties.getGraphProperties().getBarWidth();
        float f10 = ((ChartCategoryAxis)object).getMinUnit(this.getCategoryName[0]);
        float f11 = f10 * f9;
        for (int i = 0; i < this.col; ++i) {
            float f12;
            float f13 = 0.0f;
            float f14 = 0.0f;
            float f15 = 0.0f;
            float f16 = 0.0f;
            float f17 = f2;
            float f18 = 0.0f;
            if (this.paper.getAxisX1().custommerConstant()) {
                Object object2 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i);
                f17 = f12 = ((ChartCategoryAxis)object).getX(object2, this.getCategoryName[0]);
                f = f11;
                f5 = f17;
            }
            for (int j = 0; j < this.row; ++j) {
                int n5;
                int n6;
                this.draw1[j][i] = new ChartCube();
                f12 = fArray[j][i];
                f7 = f12 * this.getCategoryName[1];
                f18 = f7 < 0.0f ? this.paper.availableLength(f14) : this.paper.availableLength(f13);
                int[] nArray = new int[]{this.getCategorySize, 0, 0};
                this.draw1[j][i].addVertex(f17 - f, f18, f8 - f3);
                this.draw1[j][i].addVertex(f17, f18, f8 - f3);
                this.draw1[j][i].addVertex(f17, f18, f8);
                this.draw1[j][i].addVertex(f17 - f, f18, f8);
                float f19 = 0.0f;
                if (f7 >= 0.0f) {
                    f19 = f16 = this.paper.availableLength(f7);
                    f13 = f7;
                } else {
                    f19 = f15 = this.paper.availableLength(f7);
                    f14 = f7;
                }
                if (f18 <= f19) {
                    for (n6 = 0; n6 < this.getCategorySize; ++n6) {
                        if (fArray3[n6] < f19 && fArray3[n6] > f18) {
                            this.draw1[j][i].addVertex(f17 - f, fArray3[n6], f8 - f3);
                            this.draw1[j][i].addVertex(f17, fArray3[n6], f8 - f3);
                            this.draw1[j][i].addVertex(f17, fArray3[n6], f8);
                            this.draw1[j][i].addVertex(f17 - f, fArray3[n6], f8);
                            nArray[1] = nArray[1] + 1;
                            continue;
                        }
                        if (!(fArray3[n6] <= f18)) continue;
                        nArray[2] = nArray[2] + 1;
                    }
                } else {
                    for (n6 = this.getCategorySize - 1; n6 >= 0; --n6) {
                        if (fArray3[n6] > f19 && fArray3[n6] < f18) {
                            this.draw1[j][i].addVertex(f17 - f, fArray3[n6], f8 - f3);
                            this.draw1[j][i].addVertex(f17, fArray3[n6], f8 - f3);
                            this.draw1[j][i].addVertex(f17, fArray3[n6], f8);
                            this.draw1[j][i].addVertex(f17 - f, fArray3[n6], f8);
                            nArray[1] = nArray[1] + 1;
                            continue;
                        }
                        if (!(fArray3[n6] >= f18)) continue;
                        nArray[2] = nArray[2] + 1;
                    }
                }
                this.draw1[j][i].addVertex(f17 - f, f19, f8 - f3);
                this.draw1[j][i].addVertex(f17, f19, f8 - f3);
                this.draw1[j][i].addVertex(f17, f19, f8);
                this.draw1[j][i].addVertex(f17 - f, f19, f8);
                float f20 = 0.0f;
                float f21 = 0.0f;
                if (this.paper.getAxisX1().custommerConstant()) {
                    float f22;
                    f21 = 0.0f;
                    f20 = f;
                    if (i != this.col - 1) {
                        Object object3 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i + 1);
                        f22 = ((ChartCategoryAxis)object).getX(object3, this.getCategoryName[0]);
                        f20 = f22 - f17;
                    } else if (i == this.col - 1) {
                        Object object4 = this.getChartDataSet().getChartDataSetModel().getCategoryName(i);
                        f22 = ((ChartCategoryAxis)object).getX(object4, this.getCategoryName[0]);
                        f20 = this.paper.getLength()[0] - f22;
                    }
                } else {
                    f20 = this.getCategoryName[0];
                }
                if (f18 <= f19) {
                    for (n5 = 0; n5 < this.getCategorySize; ++n5) {
                        this.draw1[j][i].addVertex(f5, fArray3[n5], f4);
                        this.draw1[j][i].addVertex(f5 + f20, fArray3[n5], f4);
                        this.draw1[j][i].addVertex(f5 + f20, fArray3[n5], f4 + this.getCategoryName[2] * 2.0f);
                        this.draw1[j][i].addVertex(f5, fArray3[n5], f4 + this.getCategoryName[2] * 2.0f);
                    }
                } else {
                    for (n5 = this.getCategorySize - 1; n5 >= 0; --n5) {
                        this.draw1[j][i].addVertex(f5, fArray3[n5], f4);
                        this.draw1[j][i].addVertex(f5 + f20, fArray3[n5], f4);
                        this.draw1[j][i].addVertex(f5 + f20, fArray3[n5], f4 + this.getCategoryName[2] * 2.0f);
                        this.draw1[j][i].addVertex(f5, fArray3[n5], f4 + this.getCategoryName[2] * 2.0f);
                    }
                }
                this.draw1[j][i].setNumber(nArray);
                this.draw1[j][i].setThresholdColor(this.getChartDataSetInfo, this.getChartDataSetModel);
                if (!this.getChartLink[j][i]) continue;
                this.draw1[j][i].isNullValueBar(true);
            }
            if (this.paper.getAxisX1().custommerConstant()) continue;
            f2 += this.getCategoryName[0];
            f5 += this.getCategoryName[0];
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        if (this.paper.I.getShowValueConditions() != null && this.paper.I.getShowValueConditions().getConditions() != null && this.paper.I.getShowValueConditions().getConditions().size() > 0) {
            this.getChartPlatform = (ChartShowValueCondition)this.paper.I.getShowValueConditions().getConditions().get(0);
        }
        int[][] nArray = new int[this.row][this.col];
        nArray = this.orderCol();
        int[] nArray2 = new int[]{0, this.col - 1};
        if (this.paper.getFilterConstant() != null) {
            nArray2 = this.paper.getFilterConstant();
        }
        for (int i = 0; i < this.col; ++i) {
            int n = i;
            if (!this.getAbsoluteValueSumOfCategory) {
                n = this.col - i - 1;
            }
            if (n < nArray2[0] || n > nArray2[1]) continue;
            for (int j = 0; j < this.row; ++j) {
                int n2 = j;
                if (!this.getAxisX1) {
                    n2 = this.row - j - 1;
                }
                for (int k = 0; k < this.row; ++k) {
                    if (this.status == 1 && k == this.selectedSeriesIndex) {
                        this.draw1[k][n].setSelectedStatus(true);
                    } else {
                        this.draw1[k][n].setSelectedStatus(false);
                    }
                    if (nArray[k][n] != n2) continue;
                    this.floatValue = this.custommerConstant.shownFace(this.draw1[k][n].tVertex, 0);
                    if (this.draw2[k][n]) {
                        this.SEDU();
                    }
                    this.draw1[k][n].setPattern(this.pattern[k]);
                    this.draw1[k][n].setConditionalFill(this.getChartPlatform);
                    if (this.getChartPlatform != null) {
                        int n3 = this.getChartPlatform.getConditionType();
                        switch (n3) {
                            case 1: 
                            case 5: {
                                int n4 = this.getChartPlatform.getExpressionIndex(k, n);
                                ChartFillPattern chartFillPattern = n4 != -1 ? this.getChartPlatform.getSubCondition(n4).getFillColor() : this.getChartPlatform.getOtherColor();
                                this.draw1[k][n].setPattern(chartFillPattern);
                            }
                        }
                    }
                    if (this.getAxisX1) {
                        if (n2 == 0) {
                            this.draw1[k][n].setBVPosition(true, true, false);
                        } else if (n2 == this.row - 1) {
                            this.draw1[k][n].setBVPosition(false, true, true);
                        } else {
                            this.draw1[k][n].setBVPosition(false, true, false);
                        }
                        if (!this.draw2[k][n]) {
                            this.draw1[k][n].draw1(graphics2D, this.floatValue, this.contour, true, this.availableLength);
                            continue;
                        }
                        this.draw1[k][n].draw2(graphics2D, this.floatValue, this.contour, false, this.availableLength);
                        continue;
                    }
                    if (n2 == 0) {
                        this.draw1[k][n].setBVPosition(false, true, true);
                    } else if (n2 == this.row - 1) {
                        this.draw1[k][n].setBVPosition(true, true, false);
                    } else {
                        this.draw1[k][n].setBVPosition(false, true, false);
                    }
                    if (!this.draw2[k][n]) {
                        this.draw1[k][n].draw2(graphics2D, this.floatValue, this.contour, true, this.availableLength);
                        continue;
                    }
                    this.draw1[k][n].draw1(graphics2D, this.floatValue, this.contour, false, this.availableLength);
                }
            }
        }
    }

    @Override
    public void locate() {
    }

    private void SEDU() {
        int n;
        int[] nArray = new int[6];
        int n2 = 0;
        for (n = 0; n < 6; ++n) {
            nArray[n] = this.floatValue >> n & 1;
        }
        this.floatValue = 0;
        for (n = 5; n >= 0; --n) {
            n2 = n % 2 == 0 ? n + 1 : n - 1;
            this.floatValue += nArray[n2];
            if (n == 0) continue;
            this.floatValue <<= 1;
        }
    }

    @Override
    void transform(ChartMatrix chartMatrix) {
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.draw1[i][j].transform(chartMatrix);
                this.draw1[i][j].updateXUnit();
            }
        }
        this.addVertex();
    }

    private void addVertex() {
        this.col();
        this.availableLength();
        this.contour();
    }

    private void availableLength() {
        this.get = (this.paper.getShownFace() >> 5 & 1) == 1;
    }

    private void col() {
        this.getAbsoluteValueSumOfCategory = (this.paper.getShownFace() & 1) != 1;
    }

    private void contour() {
        this.getAxisX1 = (this.paper.getShownFace() >> 3 & 1) == 1;
    }

    public int[][] orderCol() {
        int[][] nArray = new int[this.row][this.col];
        int[] nArray2 = new int[this.row];
        int[] nArray3 = new int[this.row];
        for (int i = 0; i < this.col; ++i) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            for (int j = 0; j < this.row; ++j) {
                int n4;
                if (this.draw1[0][0].vertex[0][1] <= this.draw1[j][i].vertex[7][1]) {
                    if (n < this.row) {
                        ++n;
                    }
                    nArray[j][i] = this.row - n;
                    nArray2[n - 1] = j;
                    for (n4 = 0; n4 < n; ++n4) {
                        if (!(this.draw1[nArray2[n4]][i].vertex[0][1] <= this.draw1[j][i].vertex[0][1])) continue;
                        n3 = nArray[nArray2[n4]][i];
                        nArray[nArray2[n4]][i] = nArray[j][i];
                        nArray[j][i] = n3;
                    }
                    continue;
                }
                if (n2 < this.row) {
                    ++n2;
                }
                nArray[j][i] = n2 - 1;
                nArray3[n2 - 1] = j;
                for (n4 = 0; n4 < n2; ++n4) {
                    if (!(this.draw1[nArray3[n4]][i].vertex[0][1] >= this.draw1[j][i].vertex[0][1])) continue;
                    n3 = nArray[nArray3[n4]][i];
                    nArray[nArray3[n4]][i] = nArray[j][i];
                    nArray[j][i] = n3;
                }
            }
        }
        return nArray;
    }

    public void setCompass(ChartCompass chartCompass) {
        this.custommerConstant = chartCompass;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return null;
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.draw1[n][n2].toHtml();
    }

    @Override
    public Shape[][] getItemShapes(int n) {
        Shape[][] shapeArray = new Shape[this.row][this.col];
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                shapeArray[i][j] = this.getShapeByItem(i, j);
            }
        }
        return shapeArray;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        int[][] nArray = new int[this.row][this.col];
        nArray = this.orderCol();
        String[] stringArray = null;
        for (int i = 0; i < this.col; ++i) {
            int n3 = i;
            if (this.getAbsoluteValueSumOfCategory) {
                n3 = this.col - i - 1;
            }
            for (int j = 0; j < this.row; ++j) {
                int n4 = j;
                if (this.getAxisX1) {
                    n4 = this.row - j - 1;
                }
                for (int k = 0; k < this.row; ++k) {
                    if (nArray[k][n3] != n4) continue;
                    this.floatValue = this.paper.getShownFace();
                    if (this.draw2[k][n3]) {
                        this.SEDU();
                    }
                    if (!this.draw1[k][n3].inBar(k, n3, n, n2)) continue;
                    if (this.paper.getProperties().isShowCategoryAndSeries()) {
                        stringArray = new String[3];
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        stringArray = chartHintLabel.hintLabelShowCategoryAndSeries(k, n3);
                    } else {
                        stringArray = new String[]{this.dataset.getFormatedHintValue(((Chart1DDataSet)this.dataset).getOriginValue(k, n3))};
                    }
                    this.selectedSeriesIndex = k;
                    this.drilldown = new int[2];
                    this.drilldown[0] = k;
                    this.drilldown[1] = n3;
                    return stringArray;
                }
            }
        }
        this.selectedSeriesIndex = -1;
        return null;
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        return 0;
    }

    public boolean isBench() {
        return this.getChartLinkInfo;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[][] nArray = new int[this.row][this.col];
        nArray = this.orderCol();
        int[] nArray2 = null;
        for (int i = 0; i < this.col; ++i) {
            int n3 = i;
            if (this.getAbsoluteValueSumOfCategory) {
                n3 = this.col - i - 1;
            }
            for (int j = 0; j < this.row; ++j) {
                int n4 = j;
                if (this.getAxisX1) {
                    n4 = this.row - j - 1;
                }
                for (int k = 0; k < this.row; ++k) {
                    if (nArray[k][n3] != n4) continue;
                    this.floatValue = this.paper.getShownFace();
                    if (this.draw2[k][n3]) {
                        this.SEDU();
                    }
                    if (!this.draw1[k][n3].inBar(k, n3, n, n2)) continue;
                    ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(k, n3);
                    if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                        nArray2 = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(k)).get(n3)).getChartLinkInfo();
                    }
                    return nArray2;
                }
            }
        }
        return null;
    }
}

