/*
 * Decompiled with CFR 0.152.
 */
package jet.cs.ui.schedule.disk;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Properties;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jet.JCliResource;
import jet.cs.ReportListIntf;
import jet.cs.ui.JRButton;
import jet.cs.ui.schedule.disk.TargetEditor;

public class DiskPathPanel
extends JPanel
implements ActionListener {
    private JLabel SEDU = new JLabel("Type");
    private JComboBox addActionListener = new JComboBox();
    private JLabel append = new JLabel(JCliResource.getMessage((String)"CS_MSG_81") + ":");
    private JTextField equals = new JTextField();
    private JRButton findDir = new JRButton("...");
    private JLabel get = new JLabel(JCliResource.getMessage((String)"CS_MSG_82") + ":");
    private JTextField getMessage = new JTextField();
    private TargetEditor getPathType = null;
    private boolean getSelectedIndex = false;
    private boolean getSource = false;
    private ReportListIntf getText = null;
    private String getValues = null;
    private String insertItemAt = null;
    private String isEditedOK = null;
    private String length = "jrs.nonbursting$";

    public DiskPathPanel(ReportListIntf reportListIntf, String string) {
        this.getText = reportListIntf;
        this.getValues = string;
        if (string.equals("jrs.to_rsd") || string.equals("jrs.to_rst")) {
            this.getSelectedIndex = true;
        }
        this.SEDU();
    }

    private void SEDU() {
        this.setLayout(null);
        this.addActionListener.insertItemAt("Publish to server resource tree", 0);
        this.addActionListener.insertItemAt("Publish to server disk path", 1);
        this.addActionListener.setSelectedIndex(0);
        this.SEDU.setBounds(0, 0, 50, 20);
        this.addActionListener.setBounds(50, 0, 200, 20);
        this.add(this.SEDU);
        this.add(this.addActionListener);
        if (this.getValues.equals("jrs.to_html")) {
            this.insertItemAt = "jrs.html_dir";
            this.isEditedOK = "jrs.html";
        } else if (this.getValues.equals("jrs.to_pdf")) {
            this.insertItemAt = "jrs.pdf_dir";
            this.isEditedOK = "jrs.pdf";
        } else if (this.getValues.equals("jrs.to_text")) {
            this.insertItemAt = "jrs.text_dir";
            this.isEditedOK = "jrs.text";
        } else if (this.getValues.equals("jrs.to_excel")) {
            this.insertItemAt = "jrs.excel_dir";
            this.isEditedOK = "jrs.excel";
        } else if (this.getValues.equals("jrs.to_ps")) {
            this.insertItemAt = "jrs.ps_dir";
            this.isEditedOK = "jrs.ps";
        } else if (this.getValues.equals("jrs.to_rtf")) {
            this.insertItemAt = "jrs.rtf_dir";
            this.isEditedOK = "jrs.rtf";
        } else if (this.getValues.equals("jrs.to_xml")) {
            this.insertItemAt = "jrs.xml_dir";
            this.isEditedOK = "jrs.xml";
        } else if (this.getValues.equals("jrs.to_rsd")) {
            this.insertItemAt = "jrs.rsd_dir";
            this.isEditedOK = "jrs.rsd";
        } else if (this.getValues.equals("jrs.to_rst")) {
            this.insertItemAt = "jrs.rst_dir";
            this.isEditedOK = "jrs.rst";
        }
        this.addActionListener.addActionListener(this);
        if (this.getSelectedIndex) {
            this.append.setBounds(0, 25, 50, 20);
            this.equals.setBounds(50, 25, 200, 20);
            this.equals.setEditable(false);
            this.findDir.setBounds(255, 25, 30, 20);
            this.get.setBounds(0, 50, 50, 20);
            this.getMessage.setBounds(50, 50, 150, 20);
            this.findDir.addActionListener((ActionListener)this);
            this.add(this.append);
            this.add(this.equals);
            this.add((Component)this.findDir);
            this.add(this.get);
            this.add(this.getMessage);
        } else {
            this.getPathType = new TargetEditor(this.getText, this.getValues, this.insertItemAt, this.isEditedOK);
            this.getPathType.setBounds(0, 25, 330, 90);
            this.add(this.getPathType);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.addActionListener) {
            this.addActionListener();
        } else if (object == this.findDir) {
            this.append();
        }
    }

    private void addActionListener() {
        if (this.getSelectedIndex) {
            boolean bl = this.addActionListener.getSelectedIndex() == 1;
            this.equals.setEditable(bl);
            this.findDir.setVisible(!bl);
        } else {
            this.getPathType.setPathType(this.getPathType(), this.getSource);
        }
    }

    private void append() {
        String string = this.getText.findDir();
        if (string != null && string.trim().length() > 0) {
            this.equals.setText(string);
        }
    }

    private void equals(int n, boolean bl) {
        this.addActionListener.setSelectedIndex(n);
        if ((n == 0 || n == 1) && this.getSelectedIndex) {
            boolean bl2 = n == 1;
            this.equals.setEditable(bl2);
            this.findDir.setVisible(!bl2);
        }
        if (!this.getSelectedIndex) {
            this.getPathType.setPathType(n, bl);
        }
    }

    public void setValues(int n, Hashtable hashtable, boolean bl) {
        this.getSource = bl;
        this.equals(n, bl);
        if (this.getValues.equals("jrs.to_rsd")) {
            this.equals.setText((String)hashtable.get("jrs.rsd_dir"));
            this.getMessage.setText((String)hashtable.get("jrs.rsd"));
        } else if (this.getValues.equals("jrs.to_rst")) {
            this.equals.setText((String)hashtable.get("jrs.rst_dir"));
            this.getMessage.setText((String)hashtable.get("jrs.rst"));
        } else {
            this.getPathType.setValues(n, hashtable, bl);
        }
    }

    public int getPathType() {
        return this.addActionListener.getSelectedIndex();
    }

    public Properties getValues(boolean bl) {
        this.getSource = bl;
        if (this.getSelectedIndex) {
            Properties properties = new Properties();
            if (bl) {
                properties.setProperty(this.length + this.insertItemAt, this.equals.getText());
                properties.setProperty(this.length + this.isEditedOK, this.getMessage.getText());
            } else {
                properties.setProperty(this.insertItemAt, this.equals.getText());
                properties.setProperty(this.isEditedOK, this.getMessage.getText());
            }
            return properties;
        }
        return this.getPathType.getValues(bl);
    }

    @Override
    public void setEnabled(boolean bl) {
        this.SEDU.setEnabled(bl);
        this.addActionListener.setEnabled(bl);
        this.append.setEnabled(bl);
        this.equals.setEnabled(bl);
        this.findDir.setEnabled(bl);
        this.get.setEnabled(bl);
        this.getMessage.setEnabled(bl);
    }

    public boolean isDiskNameValid() {
        String string = this.getMessage.getText();
        return string != null && string.trim().length() > 0;
    }

    public boolean isDiskPathValid() {
        String string = this.equals.getText();
        return string != null && string.trim().length() > 0;
    }

    public boolean hasEdited() {
        if (this.getSelectedIndex) {
            String string = this.equals.getText();
            String string2 = this.getMessage.getText();
            return string != null && string.trim().length() > 0 && string2 != null && string2.trim().length() > 0;
        }
        return this.getPathType.isEditedOK();
    }

    public Rectangle getPathBounds() {
        if (this.getSelectedIndex) {
            return new Rectangle(0, 0, 330, 80);
        }
        return new Rectangle(0, 0, 330, 120);
    }

    public Rectangle getFormatBounds() {
        if (this.getSelectedIndex) {
            return new Rectangle(0, 80, 390, 350);
        }
        return new Rectangle(0, 120, 390, 350);
    }
}

