  package samples.APICatalog;

 
import java.io.FileOutputStream;
import java.util.Vector;



import jet.api.BLNodeInformation;
import jet.api.BVAggregationInfo;
import jet.api.BVGroupInfo;
import jet.api.BusinessViewCategoryInfo;
import jet.api.DesignerUserInfo;
import jet.api.MultipliedCatalogAPI;
import jet.api.MultipliedDesigner;

public class TestCatalogBC {

	/**
	 * This class shows how to create Business Views and Report Cubes in a
	 * catalog ( Requires:C:\Report\Designer\Demo\Reports\SampleReports\SampleReports.cat
	 */

	MultipliedDesigner desg = null;
	MultipliedCatalogAPI catalog = null;

	/**
	 * @param Uid
	 *            The name of licensed user
	 * @param key
	 *            The design API or server design API license key
	 * @param catalogPath
	 *            The path of the folder that contains the catalog
	 * @param the
	 *            name of catalog
	 * @return object of Designer,If failed return null.
	 */
	public void init(String Uid, String key, String catalogPath, String catalogfile) {

		DesignerUserInfo userInfo = new DesignerUserInfo(Uid, key);
		try {
			desg = new MultipliedDesigner(catalogPath, catalogfile, MultipliedDesigner.CAT, userInfo);
			catalog = desg.getCatalogAPI();
			
			 
			desg.setLog(new FileOutputStream(".\\desgLog.txt"), "8859_1");
			catalog.setLog(new FileOutputStream(".\\catLog.txt"), "8859_1");
 
			System.out.println("\n Debug: Designer object: " + desg);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	/**
	 * Insert Business view
	 * 
	 * @param catalog
	 *            the object of CatalogAPI
	 * @param dataSource
	 *            dataSourceName
	 * @throws Exception
	 */
	public void insertBV(String dataSource) throws Exception {
		String bvHandle = catalog.insertBusinessView(dataSource, null, "APIBV");

		catalog.insertBusinessViewTable(bvHandle, "Customers");


		catalog.insertBusinessViewTable(bvHandle, "Orders");
		catalog.insertBusinessViewTable(bvHandle, "Orders Detail");

		BusinessViewCategoryInfo   businessViewCategoryInfo = new  BusinessViewCategoryInfo("Category");
		BVGroupInfo groupInfo = new BVGroupInfo("Order Date", "group_Orders_ORDERDATE");
		businessViewCategoryInfo.addBVGroup(groupInfo);
		catalog.insertBusinessViewCategory(bvHandle, businessViewCategoryInfo); 

		// Insert dimension into category, the parent handle is category's
		// handle
		Vector<BLNodeInformation> dimInfos = new Vector<BLNodeInformation>();
		groupInfo = new BVGroupInfo("City", "group_Customers_CITY");

		String grpHandle = catalog.insertBusinessViewGroup(bvHandle, groupInfo);
		dimInfos.add(catalog.getBLNodeInformation(grpHandle));

		BVAggregationInfo aggInfo = new BVAggregationInfo("Customers_Customer ID", "Count", "Agg_count_CUSTOMERID");

		catalog.insertBusinessViewAggregation(bvHandle, aggInfo);

		aggInfo = new BVAggregationInfo("Unit Price", "Sum", "Measure_sum_UNITPRICE");
		catalog.insertBusinessViewAggregation(bvHandle, aggInfo);

	}

	/**
	 * Save all, release all resource.
	 * 
	 * @param desg
	 *            the object of Designer
	 * @param catalog
	 *            the object of CatalogAPI
	 */
	public void saveAndClose() {
		try {
			catalog.save();
			catalog.closeLog();
			desg.closeLog();
			desg.exit();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void main(String[] args) {
		TestCatalogBC op = new TestCatalogBC();

		op.init("Jinfonet", "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "C:\\JReport\\Designer\\Demo\\Reports\\SampleReports", "SampleReports.cat");

		if (op.catalog != null) {
			// Get all dataSources.
			String[] dataSource = op.catalog.getDataSources(); 
			for (String s : dataSource) {
				System.out.println("dataSourceName: " + s);
			}
			if (dataSource.length > 0) {

				try {
					op.insertBV(dataSource[0]);
				} catch (Exception e) {
					e.printStackTrace();
				}
				System.out.println("Catalog SampleReports.cat has been updated");

				op.saveAndClose();
			} else {
				System.out.println("No dataSource in catalog!");
			}
		} else {
			System.out.println("Null object of CatalogAPI");
		}

	}

}
