
<%@ page import="java.io.*,java.util.*,javax.servlet.http.*" %>
<%@ page import="javax.servlet.*" %>
<%@ page import="jet.server.api.http.HttpUtil" %>
<%@ page import="jet.server.api.http.HttpUserSessionManager" %>
<%@ page import="jet.server.servlets.JRServlet" %>
<%@ page import="com.example.MyExternalAuthorized" %>

<html>
<head>
<title>Turn On Single Sign On - Set Http External Authorized</title>
</head>
<body>
<% 
    // This page registers the HttpExternalAuthorized
    // class with JReport Server, turning on Single Sign On.
    //
    // It demonstrates how this can be done dynamically.
    // Compare this to registering the HttpExternalAuthorized
    // in the start up script by setting the system property
    // with -Djrs.httpExternalAuthorized=CustomHttpExternalAuthorized.
    //
    // This jsp page is intended to be linked to from 
    // the index page for setting up the state
    // of JReport Server before running the various
    // scenarios that show how Single Sign On works.
   
    HttpUtil.initEnv(System.getProperties());

    HttpUserSessionManager ssnMan = HttpUtil.getHttpRptServer().getHttpUserSessionManager();

    // create an instance of an HttpExternalAuthorized object 
    // and tell JReport Server to use it.
    // Use the implementation of HttpExternalAuthorized that is
    // defined in a package with a name that can be imported 
    // to a JSP page.
    ssnMan.setHttpExternalAuthorized(new MyExternalAuthorized());

    // redirect back to the index page.
    // use action value to cause the browser to get a fresh copy of the page.
    long time= new Date().getTime();
%>
%<script language="javascript" type="text/javascript">
    location.replace('customIndex.jsp?action="<%=time %>"');
</script>
</body>
</html>

