/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.ExportImportManager;

import com.ttv.manager.Common.UFileSystem;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Package.PackageExport;
import com.ttv.manager.Package.PackageExportStateEnum;
import com.ttv.manager.Package.PendingUploadStatusEnum;
import com.ttv.manager.Package.PendingUploadValues;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSContentException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSObjectStateException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.ContentException;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.FileSystem;
import com.ttv.zBandInterface.FileType;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.ObjectStateException;
import com.ttv.zBandInterface.PendingUpload;
import com.ttv.zBandInterface.PendingUploadStateEnum;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.ProgramExport;
import com.ttv.zBandInterface.ProgramExportStateEnum;
import java.net.MalformedURLException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.rpc.ServiceException;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportImportManager {
    private static final Category log = Category.getInstance(ExportImportManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, ExportImportManager> ourInstances = new HashMap();
    private String username = null;

    public static synchronized ExportImportManager getInstance(String username) {
        ExportImportManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new ExportImportManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private ExportImportManager(String username) {
        this.username = username;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<PackageExport> getPackageExports() throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getPackageExports() start:");
        ArrayList<PackageExport> packageExportList = new ArrayList<PackageExport>();
        try {
            ProgramExport[] programExports = WSLocator.getzBandInterface(this.username).getProgramExports();
            if (programExports != null) {
                for (int i = 0; i < programExports.length; ++i) {
                    packageExportList.add(this.translateProgramExport(programExports[i]));
                    log.debug((Object)("Package Name = " + programExports[i].getProgramname()));
                }
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (WSInvalidLoginException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        catch (WSConnectException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        log.debug((Object)("getPackageExports() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return packageExportList;
    }

    public boolean startPackageExport(String hostAddress, String packageId, String location) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException, WSPermissionException, WSContentException, WSDatabaseException, WSInvalidValueException, MalformedURLException, ServiceException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"startPackageExport() start:");
        boolean pkgStart = false;
        try {
            pkgStart = WSLocator.getzBandInterface(this.username, hostAddress).startProgramExport(packageId, location);
        }
        catch (ObjectStateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSObjectStateException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("startPackageExport() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return pkgStart;
    }

    public boolean queuePackageExport(String packageId) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException, WSPermissionException, WSDatabaseException, WSInvalidValueException {
        long begin = System.currentTimeMillis();
        boolean pkgStart = false;
        try {
            pkgStart = WSLocator.getzBandInterface(this.username).queueProgramExport(packageId);
            return pkgStart;
        }
        catch (ObjectStateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSObjectStateException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancelPackageExport(String packageId) throws WSConnectException, WSInvalidLoginException, WSDatabaseException {
        long begin = System.currentTimeMillis();
        boolean pkgStart = false;
        try {
            pkgStart = WSLocator.getzBandInterface(this.username).cancelProgramExport(packageId);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (WSServerDownException e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
        }
        finally {
            log.debug((Object)("cancelPackageExport() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return pkgStart;
    }

    private PackageExport translateProgramExport(ProgramExport programExport) {
        PackageExport pkgExport = new PackageExport();
        pkgExport.setPackageid(programExport.getProgramid());
        pkgExport.setPackageName(programExport.getProgramname());
        pkgExport.setHostname(programExport.getHostname());
        pkgExport.setPercentcomplete(programExport.getPercentcomplete());
        pkgExport.setTimeremaining(programExport.getTimeremaining());
        pkgExport.setSize(programExport.getSize());
        pkgExport.setLocation(programExport.getLocation());
        log.debug((Object)("programExport.getSize(): " + programExport.getSize()));
        if (programExport.getStatus().equals(ProgramExportStateEnum.Complete)) {
            pkgExport.setStatus(PackageExportStateEnum.Complete);
        } else if (programExport.getStatus().equals(ProgramExportStateEnum.Exporting)) {
            pkgExport.setStatus(PackageExportStateEnum.Exporting);
        } else if (programExport.getStatus().equals(ProgramExportStateEnum.Failed)) {
            pkgExport.setStatus(PackageExportStateEnum.Failed);
        } else if (programExport.getStatus().equals(ProgramExportStateEnum.Queued)) {
            pkgExport.setStatus(PackageExportStateEnum.Queued);
        } else if (programExport.getStatus().equals(ProgramExportStateEnum.Waiting)) {
            pkgExport.setStatus(PackageExportStateEnum.Waiting);
        }
        return pkgExport;
    }

    private UFileSystem translateFileSystem(FileSystem fileSystem) {
        UFileSystem uFileSystem = new UFileSystem();
        if (fileSystem.getType().equals(FileType.File)) {
            uFileSystem.setIsdirectory(false);
        } else {
            uFileSystem.setIsdirectory(true);
        }
        uFileSystem.setLastmodified(fileSystem.getLastmodified());
        uFileSystem.setName(fileSystem.getName());
        uFileSystem.setSize(fileSystem.getSize());
        uFileSystem.setFreespace(fileSystem.getFreespace());
        uFileSystem.setLabel(fileSystem.getLabel());
        log.debug((Object)("fileSystem.getLabel(): " + fileSystem.getLabel()));
        return uFileSystem;
    }

    public ArrayList<UFileSystem> browseFiles(String directory) throws WSContentException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        FileSystem[] filesystems;
        long begin = System.currentTimeMillis();
        log.debug((Object)"browseFiles() start:");
        try {
            filesystems = WSLocator.getzBandInterface(this.username).browseFileSystem(directory);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ArrayList<UFileSystem> uFileSystemList = new ArrayList<UFileSystem>();
        if (filesystems != null) {
            for (int i = 0; i < filesystems.length; ++i) {
                FileSystem fileSystem = filesystems[i];
                if (fileSystem == null) continue;
                uFileSystemList.add(this.translateFileSystem(fileSystem));
            }
        }
        log.debug((Object)("browseFiles() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return uFileSystemList;
    }

    public ArrayList<UFileSystem> browseFiles(String hostAddress, String directory) throws WSContentException, WSInvalidLoginException, WSServerDownException, WSConnectException, MalformedURLException, ServiceException {
        FileSystem[] filesystems;
        long begin = System.currentTimeMillis();
        log.debug((Object)"browseFiles() start:");
        try {
            filesystems = WSLocator.getzBandInterface(this.username, hostAddress).browseFileSystem(directory);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ArrayList<UFileSystem> uFileSystemList = new ArrayList<UFileSystem>();
        if (filesystems != null) {
            for (int i = 0; i < filesystems.length; ++i) {
                FileSystem fileSystem = filesystems[i];
                if (fileSystem == null) continue;
                uFileSystemList.add(this.translateFileSystem(fileSystem));
            }
        }
        log.debug((Object)("browseFiles() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return uFileSystemList;
    }

    public void uploadContent(String filePath) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException, WSPermissionException, WSContentException, WSInvalidValueException, WSDatabaseException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"uploadContent start:");
        try {
            WSLocator.getzBandInterface(this.username).uploadToLocal(filePath);
        }
        catch (ObjectStateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSObjectStateException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("uploadContent() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Uploaded content [" + filePath + "] by user [" + this.username + "]"));
    }

    public void uploadContent(String filePath, String hostAddress) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException, WSPermissionException, WSContentException, WSInvalidValueException, WSDatabaseException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"uploadContent start:");
        try {
            WSLocator.getzBandInterface(this.username, hostAddress).uploadToLocal(filePath);
        }
        catch (ObjectStateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSObjectStateException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (ContentException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSContentException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (MalformedURLException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        catch (ServiceException e) {
            audit.error((Object)("Exception is:" + (Object)((Object)e)), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("uploadContent() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Uploaded content [" + filePath + "] by user [" + this.username + "]"));
    }

    public void cancelUpload(String filePath) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSPermissionException, WSInvalidValueException, WSDatabaseException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"cancelUpLoad start:");
        try {
            WSLocator.getzBandInterface(this.username).cancelUpload(filePath);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        log.debug((Object)("cancelUpLoad() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Upload cancelled for [" + filePath + "] by user [" + this.username + "]"));
    }

    private PendingUploadValues translatePendingUpload(PendingUpload pendingUpload) {
        PendingUploadValues pendingUploadValues = new PendingUploadValues();
        pendingUploadValues.setFileid(pendingUpload.getFileid());
        pendingUploadValues.setPercentcomplete(pendingUpload.getPercentcomplete());
        pendingUploadValues.setSize(pendingUpload.getSize());
        pendingUploadValues.setTimeremaining(pendingUpload.getTimeremaining());
        if (pendingUpload.getStatus().equals(PendingUploadStateEnum.Complete)) {
            pendingUploadValues.setStatus(PendingUploadStatusEnum.Complete);
        } else if (pendingUpload.getStatus().equals(PendingUploadStateEnum.Failed)) {
            pendingUploadValues.setStatus(PendingUploadStatusEnum.Failed);
        } else if (pendingUpload.getStatus().equals(PendingUploadStateEnum.Uploading)) {
            pendingUploadValues.setStatus(PendingUploadStatusEnum.Uploading);
        } else if (pendingUpload.getStatus().equals(PendingUploadStateEnum.Waiting)) {
            pendingUploadValues.setStatus(PendingUploadStatusEnum.Waiting);
        }
        return pendingUploadValues;
    }

    public ArrayList<PendingUploadValues> getPendingUploads() throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getPendingUploads() start:");
        ArrayList<PendingUploadValues> result = new ArrayList<PendingUploadValues>();
        PendingUpload[] pendingUploads = null;
        try {
            pendingUploads = WSLocator.getzBandInterface(this.username).getPendingUploads();
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        if (pendingUploads != null) {
            for (int i = 0; i < pendingUploads.length; ++i) {
                PendingUpload pendingUpload = pendingUploads[i];
                if (pendingUpload == null) continue;
                result.add(this.translatePendingUpload(pendingUpload));
            }
        }
        log.debug((Object)("getPendingUploads() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }
}

