/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.QueueManager;

import com.ttv.manager.ConfigurationManager.ConfigurationManager;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Metadata.MetadataEnum;
import com.ttv.manager.Metadata.MetadataValues;
import com.ttv.manager.Package.PackageEncryptEnum;
import com.ttv.manager.Pitch.PitchDetails;
import com.ttv.manager.Pitch.PitchDetailsFilter;
import com.ttv.manager.Pitch.PitchDetailsFilterByEnum;
import com.ttv.manager.Pitch.PitchDetailsResult;
import com.ttv.manager.Pitch.PitchDetailsSortByEnum;
import com.ttv.manager.Pitch.PitchFilter;
import com.ttv.manager.Pitch.PitchFilterByEnum;
import com.ttv.manager.Pitch.PitchResult;
import com.ttv.manager.Pitch.PitchSortByEnum;
import com.ttv.manager.Pitch.PitchStatusEnum;
import com.ttv.manager.Pitch.PitchValues;
import com.ttv.manager.Queue.QueueTypeEnum;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSInternalErrorException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.util.CommonUtils;
import com.ttv.manager.util.FilterProperty;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.ChannelTypeEnum;
import com.ttv.zBandInterface.ClientInventory;
import com.ttv.zBandInterface.ClientInventoryFilter;
import com.ttv.zBandInterface.ClientInventorySortByEnum;
import com.ttv.zBandInterface.ClientInventoryStatusEnum;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidFilterValueException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.Job;
import com.ttv.zBandInterface.JobFilter;
import com.ttv.zBandInterface.JobPriorityEnum;
import com.ttv.zBandInterface.JobSortByEnum;
import com.ttv.zBandInterface.JobStatusEnum;
import com.ttv.zBandInterface.Metadata;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.ProgramPreEncryptionEnum;
import com.ttv.zBandInterface.holders.ClientInventoryArrayHolder;
import com.ttv.zBandInterface.holders.JobArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.xml.rpc.holders.LongHolder;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueueManager {
    private Logger log = Logger.getLogger(QueueManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, QueueManager> ourInstances = new HashMap();
    private String username = null;

    public static synchronized QueueManager getInstance(String username) {
        QueueManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new QueueManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private QueueManager(String username) {
        this.username = username;
    }

    private JobFilter translatePitchFilter(PitchFilter pitchFilter) {
        JobFilter jobFilter = new JobFilter();
        jobFilter.setAscending(pitchFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToJobFilterPropertyList(pitchFilter.getFilterPropertyList());
        jobFilter.setFilter(CommonUtils.serializeFilter(fp));
        jobFilter.setIndex(pitchFilter.getIndex());
        if (pitchFilter.getLimit() == null) {
            jobFilter.setLimit(ConfigurationManager.getInstance(this.username).getPitchsPerPage());
        } else {
            jobFilter.setLimit(pitchFilter.getLimit());
        }
        if (pitchFilter.getSortby().equals(PitchSortByEnum.NextTime.getValue())) {
            jobFilter.setSortby(JobSortByEnum.NextTime);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Status.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Status);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Queue.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Channel);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Package.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Program);
        }
        return jobFilter;
    }

    private PitchValues translateJob(Job job) {
        PitchValues pitchValues = new PitchValues();
        pitchValues.setBandwidth(job.getBandwidth());
        String queueid = job.getChannelid();
        pitchValues.setQueueid(queueid);
        pitchValues.setCatchersconfirmed(job.getClientsconfirmed());
        pitchValues.setCatcherspending(job.getClientspending());
        pitchValues.setCompletionTime(job.getCompletion().getTime());
        pitchValues.setExpanding(job.getExpanding());
        pitchValues.setRate(job.getRate());
        pitchValues.setId(job.getId());
        pitchValues.setPreencryptionProgress(job.getPreencryptionprogress());
        if (job.getType().equals(ChannelTypeEnum.MCAST)) {
            pitchValues.setQueueType(QueueTypeEnum.MCAST.getValue());
        } else if (job.getType().equals(ChannelTypeEnum.UCAST)) {
            pitchValues.setQueueType(QueueTypeEnum.UCAST.getValue());
        }
        if (job.getPreencryption().equals(ProgramPreEncryptionEnum.Default)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.Default.getValue());
        } else if (job.getPreencryption().equals(ProgramPreEncryptionEnum.Disabled)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.Disabled.getValue());
        } else if (job.getPreencryption().equals(ProgramPreEncryptionEnum.Encrypted)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.Encrypted.getValue());
        } else if (job.getPreencryption().equals(ProgramPreEncryptionEnum.Encrypting)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.Encrypting.getValue());
        } else if (job.getPreencryption().equals(ProgramPreEncryptionEnum.ToBeEncrypted)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.ToBeEncrypted.getValue());
        }
        boolean editTarget = false;
        Metadata[] metadatas = job.getMetadata();
        ArrayList<MetadataValues> metadataValuesList = new ArrayList<MetadataValues>();
        if (metadatas != null) {
            for (int i = 0; i < metadatas.length; ++i) {
                Metadata metadata = metadatas[i];
                if (metadata == null) continue;
                MetadataValues metadataValues = CommonUtils.translateMetadata(metadata);
                if (metadataValues.getProperty().equals(MetadataEnum.MP_RePitch.getValue()) && metadataValues.getValue().equals("T")) {
                    editTarget = true;
                }
                this.log.debug((Object)("JOB METADATA VALUES = " + metadataValues.getProperty() + metadataValues.getValue()));
                metadataValuesList.add(metadataValues);
            }
        }
        pitchValues.setMetadataValuesList(metadataValuesList);
        pitchValues.setServiceid(job.getServiceid());
        pitchValues.setCatchergroupname(job.getClientgroupname());
        pitchValues.setNexttime(job.getNexttime().getTime());
        pitchValues.setOnhold(job.getOnhold());
        pitchValues.setPercentcomplete(job.getPercentcomplete());
        pitchValues.setPackageid(job.getProgramid());
        pitchValues.setStarttime(job.getStarttime().getTime());
        pitchValues.setPackagename(job.getProgramname());
        pitchValues.setQueuename(job.getChannelname());
        if (job.getStatus().equals(JobStatusEnum.Complete)) {
            pitchValues.setStatus(PitchStatusEnum.Complete.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Staged)) {
            pitchValues.setStatus(PitchStatusEnum.Staged.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Failed)) {
            pitchValues.setStatus(PitchStatusEnum.Failed.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Repairing)) {
            pitchValues.setStatus(PitchStatusEnum.Repairing.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Transmitting)) {
            pitchValues.setStatus(PitchStatusEnum.Transmitting.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Waiting)) {
            pitchValues.setStatus(PitchStatusEnum.Waiting.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.WaitingForAcknowledgement)) {
            pitchValues.setStatus(PitchStatusEnum.WaitingForAck.getValue());
        }
        this.log.debug((Object)("pitch status is : " + pitchValues.getStatus()));
        if (pitchValues.getStatus().equalsIgnoreCase(PitchStatusEnum.Waiting.getValue())) {
            Date date = new Date();
            long currTimeInMinutes = date.getTime() / 60000L;
            long nextTimeInMinutes = pitchValues.getNexttime().getTime() / 60000L;
            if (nextTimeInMinutes - currTimeInMinutes > 30L && editTarget) {
                pitchValues.setTargetEditable(true);
            } else if (pitchValues.getQueueType().equalsIgnoreCase(QueueTypeEnum.UCAST.getValue())) {
                pitchValues.setTargetEditable(true);
            } else {
                pitchValues.setTargetEditable(false);
            }
        } else {
            pitchValues.setTargetEditable(false);
        }
        return pitchValues;
    }

    public PitchValues getPitch(String pitchId) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"getPitch() start:");
        try {
            PitchValues pitchValues;
            Job job = WSLocator.getzBandInterface(this.username).getJob(pitchId);
            PitchValues pitchValues2 = pitchValues = this.translateJob(job);
            return pitchValues2;
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            this.log.debug((Object)("getPitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public PitchResult getPitchs(PitchFilter pitchFilter) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInternalErrorException, WSInvalidValueException, WSInvalidFilterValueException, WSDatabaseException, WSInvalidFilterException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"getPitchs() start:");
        PitchResult result = new PitchResult();
        if (pitchFilter == null) {
            return this.getPitchs();
        }
        JobFilter jobFilter = this.translatePitchFilter(pitchFilter);
        JobArrayHolder jobArrayHolder = new JobArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getJobs(jobFilter, jobArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Job[] jobs = jobArrayHolder.value;
        ArrayList<PitchValues> pitchValuesList = new ArrayList<PitchValues>();
        if (jobs != null) {
            for (int i = 0; i < jobs.length; ++i) {
                Job job = jobs[i];
                if (job == null) continue;
                PitchValues pitchValues = this.translateJob(job);
                pitchValuesList.add(pitchValues);
            }
        }
        result = new PitchResult(pitchValuesList, new Long(count.value));
        this.log.debug((Object)("getPitchs() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    public PitchResult getPitchs() throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInternalErrorException, WSInvalidValueException, WSInvalidFilterValueException, WSDatabaseException, WSInvalidFilterException {
        PitchFilter pitchFilter = new PitchFilter();
        pitchFilter.setAscending(new Boolean(true));
        pitchFilter.setIndex(new Long(0L));
        pitchFilter.setSortby(PitchSortByEnum.NextTime.getValue());
        return this.getPitchs(pitchFilter);
    }

    public void rescheduleBefore(ArrayList<String> pitchIdList, String relativepitchid) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException, WSInvalidValueException, WSPermissionException {
        this.log.debug((Object)"rescheduleBefore() start:");
        long begin = System.currentTimeMillis();
        try {
            if (pitchIdList.size() > 0) {
                Job job = new Job();
                job.setProgramid("");
                job.setStarttime(Calendar.getInstance());
                job.setNexttime(Calendar.getInstance());
                job.setPriority(JobPriorityEnum.Normal);
                job.setBandwidth(90L);
                job.setExpanding(true);
                job.setProgramname("");
                job.setChannelname("");
                job.setChannelid("");
                String[] pitchIdarray = pitchIdList.toArray(new String[pitchIdList.size()]);
                WSLocator.getzBandInterface(this.username).rescheduleJobBefore(pitchIdarray, job, relativepitchid);
            } else {
                this.log.error((Object)"pitchIdList for the rescheduleAfter is null or empty");
            }
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            this.log.debug((Object)("rescheduleBefore() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Rescheduled pitchs by user [" + this.username + "]"));
        }
    }

    public void rescheduleAfter(ArrayList<String> pitchIdList, String relativepitchid) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException, WSInvalidValueException, WSPermissionException {
        this.log.debug((Object)"rescheduleAfter() start:");
        long begin = System.currentTimeMillis();
        try {
            if (pitchIdList != null && pitchIdList.size() > 0) {
                Job job = new Job();
                job.setProgramid("");
                job.setStarttime(Calendar.getInstance());
                job.setNexttime(Calendar.getInstance());
                job.setPriority(JobPriorityEnum.Normal);
                job.setBandwidth(90L);
                job.setExpanding(true);
                job.setProgramname("");
                job.setChannelname("");
                job.setChannelid("");
                String[] pitchIdarray = pitchIdList.toArray(new String[pitchIdList.size()]);
                WSLocator.getzBandInterface(this.username).rescheduleJobAfter(pitchIdarray, job, relativepitchid);
            } else {
                this.log.error((Object)"pitchIdList for the rescheduleAfter is null or empty");
            }
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        finally {
            this.log.debug((Object)("rescheduleAfter() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            audit.info((Object)("Rescheduled pitchs by user [" + this.username + "]"));
        }
    }

    public void rescheduleByDateTime(String pitchId, Calendar datetime) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidValueException, WSPermissionException {
        this.log.debug((Object)"rescheduleByDateTime() start:");
        long begin = System.currentTimeMillis();
        String[] pId = new String[1];
        if (pitchId != null && pitchId.length() > 0) {
            pId[0] = pitchId;
            try {
                Job job = new Job();
                job.setStarttime(datetime);
                job.setNexttime(datetime);
                job.setProgramid("");
                job.setPriority(JobPriorityEnum.Normal);
                job.setBandwidth(90L);
                job.setExpanding(true);
                job.setProgramname("");
                job.setChannelname("");
                job.setChannelid("");
                WSLocator.getzBandInterface(this.username).rescheduleJob(pId, job, datetime);
            }
            catch (PermissionException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSPermissionException)emgr.TranslateException(e);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (InvalidValueException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidValueException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
        } else {
            this.log.error((Object)"Pitch id for the rescheduleByDateTime is null or empty");
        }
        this.log.debug((Object)("rescheduleByDateTime() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Rrescheduled pitch for Id [" + pitchId + "] by user [" + this.username + "]"));
    }

    public void rescheduleTopOfQueue(String pitchId) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidValueException, WSPermissionException {
        this.log.debug((Object)"rescheduleTopOfQueue() start:");
        long begin = System.currentTimeMillis();
        String[] pId = new String[1];
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(0L);
        if (pitchId != null && pitchId.length() > 0) {
            pId[0] = pitchId;
            try {
                Job job = new Job();
                job.setStarttime(now);
                job.setNexttime(now);
                job.setProgramid("");
                job.setPriority(JobPriorityEnum.Normal);
                job.setBandwidth(90L);
                job.setExpanding(true);
                job.setProgramname("");
                job.setChannelname("");
                job.setChannelid("");
                WSLocator.getzBandInterface(this.username).rescheduleJob(pId, job, now);
            }
            catch (PermissionException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSPermissionException)emgr.TranslateException(e);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (InvalidValueException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidValueException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
        } else {
            this.log.error((Object)"Pitch id for the top of the queue is null or empty");
        }
        this.log.debug((Object)("rescheduleTopOfQueue() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Rescheduled pitch for Id [" + pitchId + "] by user [" + this.username + "]"));
    }

    public void rescheduleBottomOfQueue(String pitchId, String queueId) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSPermissionException {
        PitchFilter pitchFilter = new PitchFilter();
        ArrayList<FilterProperty> pendingPitchesFilterPropertylist = new ArrayList<FilterProperty>();
        String[] selectedstatusList = new String[]{PitchStatusEnum.Waiting.getValue(), PitchStatusEnum.WaitingForAck.getValue(), PitchStatusEnum.Repairing.getValue(), PitchStatusEnum.Transmitting.getValue(), PitchStatusEnum.Staged.getValue()};
        String statusstring = "";
        for (int i = 0; i < selectedstatusList.length; ++i) {
            statusstring = i == 0 ? selectedstatusList[i] : statusstring + "|" + selectedstatusList[i];
        }
        pendingPitchesFilterPropertylist.add(new FilterProperty(PitchFilterByEnum.Status.getValue(), statusstring));
        pendingPitchesFilterPropertylist.add(new FilterProperty(PitchFilterByEnum.Queue.getValue(), queueId));
        pitchFilter.setFilterPropertyList(pendingPitchesFilterPropertylist);
        pitchFilter.setAscending(false);
        pitchFilter.setIndex(1L);
        pitchFilter.setLimit(1L);
        JobFilter jobFilter = this.translatePitchFilter(pitchFilter);
        JobArrayHolder jobArrayHolder = new JobArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getJobs(jobFilter, jobArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        Job[] jobs = jobArrayHolder.value;
        if (jobs.length == 0) {
            this.rescheduleTopOfQueue(pitchId);
        } else {
            Job lastJob = jobs[0];
            String[] pId = new String[1];
            if (pitchId != null && pitchId.length() > 0) {
                pId[0] = pitchId;
                Job newJob = new Job();
                newJob.setStarttime(lastJob.getCompletion());
                newJob.setNexttime(lastJob.getCompletion());
                newJob.setProgramid("");
                newJob.setPriority(JobPriorityEnum.Normal);
                newJob.setBandwidth(90L);
                newJob.setExpanding(true);
                newJob.setProgramname("");
                newJob.setChannelname("");
                newJob.setChannelid("");
                try {
                    WSLocator.getzBandInterface(this.username).rescheduleJob(pId, newJob, lastJob.getCompletion());
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException("Could not connect to the Pitcher");
                }
            }
        }
    }

    public void stopPitch(String pitchid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        this.log.debug((Object)"stopPitch() start:");
        long begin = System.currentTimeMillis();
        try {
            WSLocator.getzBandInterface(this.username).holdJob(pitchid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        this.log.debug((Object)("stopPitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Stopped pitch with pitch id [" + pitchid + "] by user [" + this.username + "]"));
    }

    public void restartPitch(String pitchid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        this.log.debug((Object)"restartPitch() start:");
        long begin = System.currentTimeMillis();
        try {
            WSLocator.getzBandInterface(this.username).releaseJob(pitchid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        this.log.debug((Object)("restartPitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Restarted pitch with pitch id [" + pitchid + "] by user [" + this.username + "]"));
    }

    private ClientInventoryFilter translatePitchDetailsFilter(PitchDetailsFilter pitchDetailsFilter) {
        ClientInventoryFilter clientInvFilter = new ClientInventoryFilter();
        clientInvFilter.setAscending(pitchDetailsFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToJobDetailsFilterPropertyList(pitchDetailsFilter.getFilterPropertyList());
        clientInvFilter.setFilter(CommonUtils.serializeFilter(fp));
        clientInvFilter.setIndex(pitchDetailsFilter.getIndex());
        clientInvFilter.setLimit(ConfigurationManager.getInstance(this.username).getPitchsPerPage());
        if (pitchDetailsFilter.getSortby().equals(PitchDetailsSortByEnum.CatcherId)) {
            clientInvFilter.setSortby(ClientInventorySortByEnum.ClientId);
        } else if (pitchDetailsFilter.getSortby().equals(PitchDetailsSortByEnum.PackageId)) {
            clientInvFilter.setSortby(ClientInventorySortByEnum.ProgramId);
        } else if (pitchDetailsFilter.getSortby().equals(PitchDetailsSortByEnum.Status)) {
            clientInvFilter.setSortby(ClientInventorySortByEnum.Status);
        }
        return clientInvFilter;
    }

    public PitchDetailsResult getPitchDetails(PitchDetailsFilter pitchDetailsFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ExceptionManager emgr;
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"getPitchDetails() start:");
        if (pitchDetailsFilter == null) {
            this.log.error((Object)"pitchDetailsFilter is null");
            throw new WSInvalidValueException("pitchDetailsFilter is null");
        }
        ArrayList<FilterProperty> otherfilterpropertylist = new ArrayList<FilterProperty>();
        String pitchid = null;
        ArrayList<FilterProperty> filterpropertylist = pitchDetailsFilter.getFilterPropertyList();
        for (FilterProperty fp : filterpropertylist) {
            if (fp.getFilterby().equalsIgnoreCase(PitchDetailsFilterByEnum.PitchId.getValue())) {
                pitchid = fp.getFilter();
                continue;
            }
            if (fp.getFilterby().equalsIgnoreCase(PitchDetailsFilterByEnum.PackageId.getValue()) || fp.getFilterby().equalsIgnoreCase(PitchDetailsFilterByEnum.ServiceId.getValue()) || fp.getFilterby().equalsIgnoreCase(PitchDetailsFilterByEnum.PitchStatus.getValue())) continue;
            otherfilterpropertylist.add(fp);
        }
        boolean pitchFailedStatus = false;
        if (pitchid != null && !pitchid.isEmpty()) {
            try {
                FilterProperty fp1;
                Job job = WSLocator.getzBandInterface(this.username).getJob(pitchid);
                ArrayList<FilterProperty> newfilterpropertylist = new ArrayList<FilterProperty>();
                if (job.getStatus().equals(JobStatusEnum.Failed)) {
                    pitchFailedStatus = true;
                }
                if (job.getType().equals(ChannelTypeEnum.MCAST) && job.getStatus().equals(JobStatusEnum.Waiting)) {
                    fp1 = new FilterProperty();
                    fp1.setFilterby(PitchDetailsFilterByEnum.PitchId.getValue());
                    fp1.setFilter("");
                    newfilterpropertylist.add(fp1);
                    FilterProperty fp2 = new FilterProperty();
                    fp2.setFilterby(PitchDetailsFilterByEnum.PackageId.getValue());
                    fp2.setFilter(job.getProgramid());
                    newfilterpropertylist.add(fp2);
                    FilterProperty fp3 = new FilterProperty();
                    fp3.setFilterby(PitchDetailsFilterByEnum.ServiceId.getValue());
                    fp3.setFilter(job.getServiceid());
                    newfilterpropertylist.add(fp3);
                } else {
                    fp1 = new FilterProperty();
                    fp1.setFilterby(PitchDetailsFilterByEnum.PitchId.getValue());
                    fp1.setFilter(job.getId());
                    newfilterpropertylist.add(fp1);
                }
                newfilterpropertylist.addAll(otherfilterpropertylist);
                pitchDetailsFilter.setFilterPropertyList(newfilterpropertylist);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr2 = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr2.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException("Could not connect to the Pitcher");
            }
        } else {
            this.log.error((Object)"pitchid is not found in the filter");
            throw new WSInvalidFilterException("pitchid is not found in the filter");
        }
        ClientInventoryFilter clientInvFilter = this.translatePitchDetailsFilter(pitchDetailsFilter);
        ClientInventoryArrayHolder clientInvHolder = new ClientInventoryArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getClientInventories(clientInvFilter, clientInvHolder, count);
        }
        catch (InvalidFilterException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        ClientInventory[] clientInventories = clientInvHolder.value;
        ArrayList<PitchDetails> pitchDetailsList = new ArrayList<PitchDetails>();
        if (clientInventories != null) {
            for (int i = 0; i < clientInventories.length; ++i) {
                ClientInventory clientInventory = clientInventories[i];
                if (clientInventory == null) continue;
                PitchDetails pitchDetails = new PitchDetails();
                pitchDetails.setCatcherid(clientInventory.getClientid());
                pitchDetails.setPackageid(clientInventory.getProgramid());
                pitchDetails.setPercentcomplete(clientInventory.getPercentcomplete());
                pitchDetails.setCatchername(clientInventory.getClientname());
                pitchDetails.setPackagename(clientInventory.getProgramname());
                pitchDetails.setErrorcode(clientInventory.getErrorcode());
                if (clientInventory.getStatus().equals(ClientInventoryStatusEnum.Complete)) {
                    pitchDetails.setStatus("Complete");
                } else if (clientInventory.getStatus().equals(ClientInventoryStatusEnum.Deleted)) {
                    if (pitchFailedStatus) {
                        pitchDetails.setStatus("Failed");
                    } else {
                        pitchDetails.setStatus("Deleted");
                    }
                } else if (clientInventory.getStatus().equals(ClientInventoryStatusEnum.Fragmented)) {
                    if (pitchFailedStatus) {
                        pitchDetails.setStatus("Failed");
                    } else {
                        pitchDetails.setStatus("Partially Received");
                    }
                } else if (clientInventory.getStatus().equals(ClientInventoryStatusEnum.Published)) {
                    pitchDetails.setStatus("Complete and Exported");
                } else if (clientInventory.getStatus().equals(ClientInventoryStatusEnum.Unconfirmed)) {
                    if (pitchFailedStatus) {
                        pitchDetails.setStatus("Failed");
                    } else {
                        pitchDetails.setStatus("No ACK Received");
                    }
                }
                pitchDetailsList.add(pitchDetails);
            }
        }
        this.log.debug((Object)("getPitchDetails() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return new PitchDetailsResult(pitchDetailsList, new Long(count.value));
    }

    public PitchDetailsResult getPitchDetails(String packageid, Long index) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        PitchDetailsFilter pitchDetailsFilter = new PitchDetailsFilter();
        pitchDetailsFilter.setAscending(new Boolean(true));
        FilterProperty filterProperty = new FilterProperty();
        filterProperty.setFilterby(PitchDetailsFilterByEnum.PackageId.getValue());
        filterProperty.setFilter(packageid);
        ArrayList<FilterProperty> filter = new ArrayList<FilterProperty>();
        filter.add(filterProperty);
        pitchDetailsFilter.setFilterPropertyList(filter);
        pitchDetailsFilter.setIndex(index);
        pitchDetailsFilter.setSortby(PitchDetailsSortByEnum.PackageId);
        return this.getPitchDetails(pitchDetailsFilter);
    }

    public void deletePitch(String pitchid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        this.log.debug((Object)"deletePitch() start:");
        long begin = System.currentTimeMillis();
        try {
            WSLocator.getzBandInterface(this.username).deleteJob(pitchid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException("Could not connect to the Pitcher");
        }
        this.log.debug((Object)("deletePitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Deleted pitch with pitchid [" + pitchid + "] by user [" + this.username + "]"));
    }

    public void deletePitchs(ArrayList<String> pitchidList) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        this.log.debug((Object)"deletePitchs() start:");
        long begin = System.currentTimeMillis();
        for (String pitchid : pitchidList) {
            this.deletePitch(pitchid);
        }
        this.log.debug((Object)("deletePitchs() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Deleted pitchs by user [" + this.username + "]"));
    }
}

