/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.util;

import com.ttv.manager.Metadata.MetadataValues;
import com.ttv.manager.util.FilterProperty;
import com.ttv.zBandInterface.Metadata;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.log4j.Category;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonUtils {
    private static final Category log = Category.getInstance(CommonUtils.class);
    private static final String comma = ",";
    private static final String equalOperator = "=";

    public static synchronized MetadataValues translateMetadata(Metadata metadata) {
        MetadataValues metadataValues = null;
        if (metadata.getProperty() != null) {
            String metadataValue = metadata.getValue();
            if (metadataValue == null) {
                metadataValue = "";
            }
            metadataValues = new MetadataValues(metadata.getProperty(), metadataValue);
        }
        return metadataValues;
    }

    public static synchronized ArrayList<FilterProperty> translateToProviderFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                if (!"Provider".equals(fp.getFilterby())) continue;
                FilterProperty wsfp = new FilterProperty("Name", fp.getFilter());
                wsFilterPropertyList.add(wsfp);
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToProgramFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                if ("Package".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Provider".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ProviderId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Metadata".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Metadata", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Not Staged".equals(fp.getFilterby())) {
                    String mpStaged_F = "mpStaged=F";
                    FilterProperty wsfp2 = new FilterProperty("Metadata", mpStaged_F);
                    wsFilterPropertyList.add(wsfp2);
                    continue;
                }
                if ("Package Type".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("TemplateId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if (!"FilePath".equals(fp.getFilterby())) continue;
                wsfp = new FilterProperty("FileId", fp.getFilter());
                wsFilterPropertyList.add(wsfp);
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToClientFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                if ("Contact".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ContactId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Enabled".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Enabled", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Catcher".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Service".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ServiceId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("CatcherGroupId".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ClientGroupId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Host Name".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Hostname", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("InActive".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("InactiveFor", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("DiskSpace".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("DiskFreeBelow", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if (!"MulticastState".equals(fp.getFilterby())) continue;
                wsfp = new FilterProperty("MulticastState", fp.getFilter());
                wsFilterPropertyList.add(wsfp);
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToClientGroupFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                if ("Catcher Group".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Service".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ServiceId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("CatcherId".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ClientId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Type".equals(fp.getFilterby())) {
                    String filter = fp.getFilter();
                    if (filter.equals("Individual")) {
                        filter = "Individual";
                    } else if (filter.equals("Normal")) {
                        filter = "Normal";
                    } else if (filter.equals("Special")) {
                        filter = "Special";
                    }
                    FilterProperty wsfp2 = new FilterProperty("Type", filter);
                    wsFilterPropertyList.add(wsfp2);
                    continue;
                }
                if (!"Catcher Name".equals(fp.getFilterby())) continue;
                wsfp = new FilterProperty("ClientName", fp.getFilter());
                wsFilterPropertyList.add(wsfp);
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToJobFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                if ("UCCatcher".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("UCClientHostname", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                }
                if ("MCCatcher".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("MCClientHostname", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Queue".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ChannelId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Package".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Name", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if (!"Status".equals(fp.getFilterby())) continue;
                String[] statusarray = fp.getFilter().split("\\|");
                String wsfilter = "";
                if (statusarray != null) {
                    for (int i = 0; i < statusarray.length; ++i) {
                        if (statusarray[i].equals("Failed")) {
                            if (i == 0) {
                                wsfilter = "Failed";
                                continue;
                            }
                            wsfilter = wsfilter + "|" + "Failed";
                            continue;
                        }
                        if (statusarray[i].equals("Repairing")) {
                            if (i == 0) {
                                wsfilter = "Repairing";
                                continue;
                            }
                            wsfilter = wsfilter + "|" + "Repairing";
                            continue;
                        }
                        if (statusarray[i].equals("Transmitting")) {
                            if (i == 0) {
                                wsfilter = "Transmitting";
                                continue;
                            }
                            wsfilter = wsfilter + "|" + "Transmitting";
                            continue;
                        }
                        if (statusarray[i].equals("Waiting")) {
                            if (i == 0) {
                                wsfilter = "Waiting";
                                continue;
                            }
                            wsfilter = wsfilter + "|" + "Waiting";
                            continue;
                        }
                        if (statusarray[i].equals("WaitingForAck")) {
                            if (i == 0) {
                                wsfilter = "WaitingForAcknowledgement";
                                continue;
                            }
                            wsfilter = wsfilter + "|" + "WaitingForAcknowledgement";
                            continue;
                        }
                        if (statusarray[i].equals("Complete")) {
                            if (i == 0) {
                                wsfilter = "Complete";
                                continue;
                            }
                            wsfilter = wsfilter + "|" + "Complete";
                            continue;
                        }
                        if (!statusarray[i].equals("Staged")) continue;
                        wsfilter = i == 0 ? "Staged" : wsfilter + "|" + "Staged";
                    }
                }
                FilterProperty wsfp2 = new FilterProperty("Status", wsfilter);
                wsFilterPropertyList.add(wsfp2);
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized ArrayList<FilterProperty> translateToJobDetailsFilterPropertyList(ArrayList<FilterProperty> filterPropertyList) {
        ArrayList<FilterProperty> wsFilterPropertyList = new ArrayList<FilterProperty>();
        if (filterPropertyList != null) {
            for (FilterProperty fp : filterPropertyList) {
                FilterProperty wsfp;
                if ("PitchId".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("JobId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Package".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ProgramId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Service".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ServiceId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Catcher".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("ClientId", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if ("Status".equals(fp.getFilterby())) {
                    wsfp = new FilterProperty("Status", fp.getFilter());
                    wsFilterPropertyList.add(wsfp);
                    continue;
                }
                if (!"ChannelType".equals(fp.getFilterby())) continue;
                wsfp = new FilterProperty("ChannelType", fp.getFilter());
                wsFilterPropertyList.add(wsfp);
            }
        }
        return wsFilterPropertyList;
    }

    public static synchronized String serializeFilter(ArrayList<FilterProperty> filterPropertyList) {
        String result = "";
        if (filterPropertyList != null) {
            Iterator<FilterProperty> iter = filterPropertyList.iterator();
            while (iter.hasNext()) {
                FilterProperty filterProperty = iter.next();
                result = result + filterProperty.getFilterby();
                result = result + equalOperator;
                result = result + filterProperty.getFilter();
                if (!iter.hasNext()) continue;
                result = result + comma;
            }
        }
        log.debug((Object)("Filter criteria sent to ws[" + result + "]"));
        return result;
    }

    public static Date date(String date, String pattern) {
        Date result = null;
        SimpleDateFormat sdf = new SimpleDateFormat();
        if (date != null && date.length() > 0) {
            if (pattern != null && pattern.length() > 0) {
                sdf.applyPattern(pattern);
                try {
                    result = sdf.parse(date.trim());
                }
                catch (ParseException e) {}
            } else {
                try {
                    result = sdf.parse(date.trim());
                }
                catch (ParseException e) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    public static Date dateVal(String s) {
        Date result = null;
        if (s != null & s.length() > 0) {
            String p;
            String[] patterns;
            String[] arr$ = patterns = new String[]{"EEE MMM dd HH:mm:ss z yyyy", "yyyyMMdd HHmmssSSS", "yyMMdd HHmmssSSS", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy/MM/dd HH:mm:ss.SSS", "MM/dd/yyyy HH:mm:ss.SSS", "yyyy-MM-dd", "yyyy/MM/dd", "HH:mm:ss.SSS", "HH:mm:ss"};
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (result = CommonUtils.date(s, p = arr$[i$])) == null; ++i$) {
            }
        }
        return result;
    }
}

