/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.ConfigurationManager;

import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Setting.SettingValues;
import com.ttv.manager.Setting.SettingValuesTypeEnum;
import com.ttv.manager.Setting.SystemSettingNamesEnum;
import com.ttv.manager.Setting.SystemSettingSectionEnum;
import com.ttv.manager.Setting.TimeZoneValues;
import com.ttv.manager.Setting.UserSettingNamesEnum;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.Setting;
import com.ttv.zBandInterface.SettingTypeEnum;
import com.ttv.zBandInterface.TimeZones;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.log4j.Category;

public class ConfigurationManager {
    private static final Category log = Category.getInstance(ConfigurationManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, ConfigurationManager> ourInstances = new HashMap();
    public static final Long DEFAULT_ITEMS_PER_PAGE = new Long(15L);
    public static final Long DEFAULT_PITCHES_PER_PAGE = new Long(25L);
    public static final Long DEFAULT_REFRESH_TIME = new Long(60L);
    public static final String DEFAULT_TIME_ZONE = Calendar.getInstance().getTimeZone().getID();
    public static final String DEFAULT_PACKAGE_PAGE_COLUMNS = new String("package,provider,licensestartdate,licenseenddate,size,expirytime,status");
    public static final String DEFAULT_PITCH_PAGE_COLUMNS = new String("package,starttime,catchergroup,mbps,status");
    public static final Long WS_PROCESSING_TIMEOUT = new Long(60L);
    private String username = null;
    private static final String SENDER_NO_CONNECTION_MSG = "Could not connect to the Sender";

    public static synchronized ConfigurationManager getInstance(String username) {
        ConfigurationManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new ConfigurationManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private ConfigurationManager(String username) {
        this.username = username;
    }

    private SettingValues translateSetting(Setting setting) {
        SettingValues settingValues = new SettingValues();
        settingValues.setId(setting.getId());
        settingValues.setName(setting.getName());
        settingValues.setSection(setting.getSection());
        settingValues.setDescription(setting.getDescription());
        if (setting.getType().getValue().equals("String")) {
            settingValues.setType(SettingValuesTypeEnum.String.getValue());
            settingValues.setValue(setting.getValue());
        } else if (setting.getType().getValue().equals("NonEmptyString")) {
            settingValues.setType(SettingValuesTypeEnum.NonEmptyString.getValue());
            settingValues.setValue(setting.getValue());
        } else if (setting.getType().getValue().equals("Integer")) {
            settingValues.setType(SettingValuesTypeEnum.Integer.getValue());
            settingValues.setValue(setting.getValue());
        } else if (setting.getType().getValue().equals("Boolean")) {
            settingValues.setType(SettingValuesTypeEnum.Boolean.getValue());
            settingValues.setValue(setting.getValue());
        } else if (setting.getType().getValue().equals("Email")) {
            settingValues.setType(SettingValuesTypeEnum.Email.getValue());
            settingValues.setValue(setting.getValue());
        } else if (setting.getType().getValue().equals("EmailList")) {
            settingValues.setType(SettingValuesTypeEnum.EmailList.getValue());
            settingValues.setValue(setting.getValue());
        } else if (setting.getType().getValue().equals("Path")) {
            settingValues.setType(SettingValuesTypeEnum.Path.getValue());
            settingValues.setValue(setting.getValue());
        } else if (setting.getType().getValue().equals("TimeZone")) {
            settingValues.setType(SettingValuesTypeEnum.TimeZone.getValue());
            settingValues.setValue(setting.getValue());
        } else if (setting.getType().getValue().equals("Columns")) {
            settingValues.setType(SettingValuesTypeEnum.Columns.getValue());
            settingValues.setValue(setting.getValue());
        }
        settingValues.setDefaultvalue(setting.getDefaultvalue());
        settingValues.setUnit(setting.getUnit());
        settingValues.setIsdefault(setting.getIsdefault());
        settingValues.setRestartrequired(setting.getRestartrequired());
        return settingValues;
    }

    private Setting translateSettingValues(SettingValues settingValues) {
        Setting setting = new Setting();
        setting.setId(settingValues.getId());
        setting.setName(settingValues.getName());
        setting.setSection(settingValues.getSection());
        if (settingValues.getType().equals("String")) {
            setting.setType(SettingTypeEnum.String);
            setting.setValue(settingValues.getValue());
        } else if (settingValues.getType().equals("NonEmptyString")) {
            setting.setType(SettingTypeEnum.NonEmptyString);
            setting.setValue(settingValues.getValue());
        } else if (settingValues.getType().equals("Integer")) {
            setting.setType(SettingTypeEnum.Integer);
            setting.setValue(settingValues.getValue());
        } else if (settingValues.getType().equals("Boolean")) {
            setting.setType(SettingTypeEnum.Boolean);
            setting.setValue(settingValues.getValue());
        } else if (settingValues.getType().equals("Email")) {
            setting.setType(SettingTypeEnum.Email);
            setting.setValue(settingValues.getValue());
        } else if (settingValues.getType().equals("EmailList")) {
            setting.setType(SettingTypeEnum.EmailList);
            setting.setValue(settingValues.getValue());
        } else if (settingValues.getType().equals("Path")) {
            setting.setType(SettingTypeEnum.Path);
            setting.setValue(settingValues.getValue());
        } else if (settingValues.getType().equals("TimeZone")) {
            setting.setType(SettingTypeEnum.TimeZone);
            setting.setValue(settingValues.getValue());
        } else if (settingValues.getType().equals("Columns")) {
            setting.setType(SettingTypeEnum.Columns);
            setting.setValue(settingValues.getValue());
        }
        setting.setUnit(settingValues.getUnit());
        setting.setIsdefault(settingValues.getIsdefault());
        return setting;
    }

    private ArrayList<SettingValues> getSystemSettings(boolean advanced, String sectionId) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getSettings() start:");
        ArrayList<SettingValues> settingValuesList = new ArrayList<SettingValues>();
        try {
            Setting[] settings = WSLocator.getzBandInterface(this.username).getSystemSettings(advanced, sectionId);
            if (settings != null) {
                for (int i = 0; i < settings.length; ++i) {
                    SettingValues sv = this.translateSetting(settings[i]);
                    sv.setSystem(true);
                    settingValuesList.add(sv);
                    log.debug((Object)("Setting Name: " + settings[i].getName()));
                }
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            log.debug((Object)("getSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return settingValuesList;
    }

    public ArrayList<SettingValues> getNonAdvancedSystemSettings() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)"getSystemSettings() start:");
        long begin = System.currentTimeMillis();
        ArrayList<SettingValues> nonadvanced_systemSettingList = this.getSystemSettings(false, null);
        log.debug((Object)("getSystemSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return nonadvanced_systemSettingList;
    }

    public ArrayList<String> getAllSystemSettingSections() throws WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getAllSystemSettingSection() start");
        ArrayList<String> sectionList = new ArrayList<String>();
        try {
            String[] sections = WSLocator.getzBandInterface(this.username).getSystemSettingSections(true);
            if (sections != null) {
                for (int i = 0; i < sections.length; ++i) {
                    sectionList.add(sections[i]);
                    log.debug((Object)("Section Name: " + sections[i]));
                }
            }
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            log.debug((Object)("getAllSystemSettingSection() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        return sectionList;
    }

    public ArrayList<SettingValues> getSystemSettings(String sectionId) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)"getSystemSettings() start:");
        long begin = System.currentTimeMillis();
        ArrayList<SettingValues> systemSettingList = this.getSystemSettings(true, sectionId);
        log.debug((Object)("getSystemSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return systemSettingList;
    }

    public ArrayList<SettingValues> getAllSystemSettings() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)"getSystemSettings() start:");
        long begin = System.currentTimeMillis();
        ArrayList<SettingValues> systemSettingList = this.getSystemSettings(true, null);
        log.debug((Object)("getSystemSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return systemSettingList;
    }

    public ArrayList<SettingValues> getUserSettings() throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getUserSettings() start:");
        ArrayList<SettingValues> userSettingList = new ArrayList<SettingValues>();
        try {
            Setting[] settings = WSLocator.getzBandInterface(this.username).getUserSettings();
            for (int i = 0; i < settings.length; ++i) {
                SettingValues sv = this.translateSetting(settings[i]);
                sv.setSystem(false);
                userSettingList.add(sv);
                log.debug((Object)("Setting Name: " + settings[i].getName()));
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            log.debug((Object)("getSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
        log.debug((Object)("getUserSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return userSettingList;
    }

    public SettingValues getUserSetting(String settingId) throws WSDatabaseException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        long begin = System.currentTimeMillis();
        log.debug((Object)("getUserSetting() " + settingId + " start:"));
        try {
            Setting setting = WSLocator.getzBandInterface(this.username).getUserSetting(settingId);
            SettingValues sv = this.translateSetting(setting);
            sv.setSystem(false);
            SettingValues settingValues = sv;
            return settingValues;
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            log.debug((Object)("getUserSetting() " + settingId + " complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public SettingValues getSystemSetting(String settingId, String sectionName) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException, WSInvalidValueException {
        long begin = System.currentTimeMillis();
        log.debug((Object)("getSystemSetting() " + settingId + " start:"));
        try {
            Setting setting = WSLocator.getzBandInterface(this.username).getSystemSetting(settingId, sectionName);
            SettingValues sv = this.translateSetting(setting);
            sv.setSystem(true);
            SettingValues settingValues = sv;
            return settingValues;
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            log.debug((Object)("getSystemSetting() " + settingId + " complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public void updateUserSetting(SettingValues settingValues) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)("Updating setting [" + settingValues.getName() + "with setting id [" + settingValues.getId() + "]"));
        Setting setting = this.translateSettingValues(settingValues);
        try {
            WSLocator.getzBandInterface(this.username).updateUserSetting(setting);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        audit.info((Object)("Setting updated [" + settingValues.getName() + "] with setting id [" + settingValues.getId() + "] to [" + settingValues.getValue() + "]"));
    }

    public void updateSystemSetting(SettingValues settingValues) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)("Updating setting [" + settingValues.getName() + "with setting id [" + settingValues.getId() + "]"));
        Setting setting = this.translateSettingValues(settingValues);
        try {
            WSLocator.getzBandInterface(this.username).updateSystemSetting(setting);
            audit.info((Object)("Setting [" + settingValues.getName() + "] updated to [" + settingValues.getValue() + "] by user [" + this.username + "]"));
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
    }

    public void updateUserSettingDefaultValue(SettingValues settingValues) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)("Updating Default Value of setting [" + settingValues.getName() + "]"));
        Setting setting = this.translateSettingValues(settingValues);
        try {
            WSLocator.getzBandInterface(this.username).updateUserSettingDefault(setting);
            audit.info((Object)("Setting [" + settingValues.getName() + "] default value updated to [" + settingValues.getValue() + "] by user [" + this.username + "]"));
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
    }

    public void updateUserSettingToDefault(String settingId) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)("calling updateUserSettingToDefault(). Updating setting [" + settingId + "]"));
        try {
            WSLocator.getzBandInterface(this.username).updateUserSettingToDefault(settingId);
            audit.info((Object)("Setting updated [" + settingId + "] to default value by user [" + this.username + "]"));
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
    }

    public void updateSystemSettingToDefault(String settingId, String sectionName) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)("calling updateSystemSettingToDefault(). Updating setting [" + settingId + "]"));
        try {
            WSLocator.getzBandInterface(this.username).updateSystemSettingToDefault(settingId, sectionName);
            audit.info((Object)("Setting updated [" + settingId + "] to default value by user [" + this.username + "]"));
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
    }

    public Long getItemsPerPage() {
        try {
            SettingValues settingvalue = this.getUserSetting(UserSettingNamesEnum.ItemsPerPage.getValue());
            return new Long(settingvalue.getValue());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ItemsPerPage, using defaults");
            return DEFAULT_ITEMS_PER_PAGE;
        }
    }

    public Long getPageRefreshTime() {
        try {
            SettingValues settingvalue = this.getUserSetting(UserSettingNamesEnum.PageRefreshTime.getValue());
            return new Long(settingvalue.getValue());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: RefreshTime, using defaults");
            return DEFAULT_REFRESH_TIME;
        }
    }

    public Long getPitchPageRefreshTime() {
        try {
            SettingValues settingvalue = this.getUserSetting(UserSettingNamesEnum.PitchPageRefreshTime.getValue());
            return new Long(settingvalue.getValue());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: QueueRefreshTime, using defaults");
            return DEFAULT_REFRESH_TIME;
        }
    }

    public Long getPitchsPerPage() {
        try {
            SettingValues settingvalue = this.getUserSetting(UserSettingNamesEnum.PitchesPerPage.getValue());
            return new Long(settingvalue.getValue());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: PitchsPerPage, using defaults");
            return DEFAULT_PITCHES_PER_PAGE;
        }
    }

    public Long getWsProcessingTimeout() {
        try {
            SettingValues settingvalue = this.getSystemSetting(SystemSettingNamesEnum.WSProcessingTimeout.getValue(), SystemSettingSectionEnum.Manager.getValue());
            return new Long(settingvalue.getValue());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: WSPProcessingTimeout, using defaults");
            return WS_PROCESSING_TIMEOUT;
        }
    }

    public String getPackagePageColumns() {
        try {
            SettingValues settingvalue = this.getUserSetting(UserSettingNamesEnum.ConfigurableColumnPackagePage.getValue());
            return settingvalue.getValue();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ConfigurableColumnPackagePage, using defaults");
            return DEFAULT_PACKAGE_PAGE_COLUMNS;
        }
    }

    public String getPitchPageColumns() {
        try {
            SettingValues settingvalue = this.getUserSetting(UserSettingNamesEnum.ConfigurableColumnPitchesPage.getValue());
            return settingvalue.getValue();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: ConfigurableColumnPitchesPage, using defaults");
            return DEFAULT_PITCH_PAGE_COLUMNS;
        }
    }

    public String getTimeZone() {
        try {
            SettingValues settingvalue = this.getUserSetting(UserSettingNamesEnum.TimeZone.getValue());
            TimeZones[] timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
            for (int i = 0; i < timeZones.length; ++i) {
                if (timeZones[i].getId() != Integer.parseInt(settingvalue.getValue())) continue;
                return timeZones[i].getJavaname();
            }
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            log.error((Object)"Error getting the configuration: TimeZone, using defaults");
        }
        return DEFAULT_TIME_ZONE;
    }

    private ArrayList<TimeZoneValues> translateTimeZones() throws WSDatabaseException, WSPermissionException, WSConnectException, WSServerDownException, WSInvalidLoginException {
        ArrayList<TimeZoneValues> timeZoneList;
        try {
            TimeZones[] timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
            timeZoneList = new ArrayList<TimeZoneValues>();
            for (int i = 0; i < timeZones.length; ++i) {
                TimeZones timeZone = timeZones[i];
                TimeZoneValues tzValue = new TimeZoneValues();
                tzValue.setId(new Integer(timeZone.getId()));
                tzValue.setDisplayname(timeZone.getDisplayname());
                tzValue.setJavaname(timeZone.getJavaname());
                timeZoneList.add(tzValue);
            }
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        return timeZoneList;
    }

    public ArrayList<TimeZoneValues> getTimeZones() throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"getTimeZones() start:");
        ArrayList<TimeZoneValues> tzValuesList = this.translateTimeZones();
        log.debug((Object)("getTimeZones() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return tzValuesList;
    }

    public String getJavaTimeZone(int id) throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        String javaTimeZone;
        long begin = System.currentTimeMillis();
        log.debug((Object)"getJavaTimeZone() start:");
        try {
            TimeZones timezone = WSLocator.getzBandInterface(this.username).getTimeZone(id);
            javaTimeZone = timezone.getJavaname();
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        log.debug((Object)("getSystemSettings() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return javaTimeZone;
    }

    public int getTimeZoneId(String javaName) throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        TimeZones[] timeZones;
        int timeZoneId = -1;
        try {
            timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        for (int i = 0; i < timeZones.length; ++i) {
            if (!timeZones[i].getJavaname().equals(javaName)) continue;
            return i;
        }
        return timeZoneId;
    }

    public String getTimeZoneDisplayValue(String javaName) throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        TimeZones[] timeZones;
        String timeZoneDisplayValue = "";
        try {
            timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        for (int i = 0; i < timeZones.length; ++i) {
            if (!timeZones[i].getJavaname().equals(javaName)) continue;
            return timeZones[i].getDisplayname();
        }
        return timeZoneDisplayValue;
    }

    public String getTimeZoneDisplayValue(int TimeZoneId) throws WSDatabaseException, WSPermissionException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        TimeZones[] timeZones;
        String timeZoneDisplayValue = "";
        try {
            timeZones = WSLocator.getzBandInterface(this.username).getTimeZones();
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        for (int i = 0; i < timeZones.length; ++i) {
            if (timeZones[i].getId() != TimeZoneId) continue;
            return timeZones[i].getDisplayname();
        }
        return timeZoneDisplayValue;
    }
}

