/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.ExceptionManager;

import com.ttv.manager.WSException.WSContentException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSDifferentServiceException;
import com.ttv.manager.WSException.WSDuplicateException;
import com.ttv.manager.WSException.WSEncryptionViolationException;
import com.ttv.manager.WSException.WSInternalErrorException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidMetadataException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSLicenseException;
import com.ttv.manager.WSException.WSLinkObjectException;
import com.ttv.manager.WSException.WSObjectStateException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.zBandInterface.ContentException;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.DifferentServiceException;
import com.ttv.zBandInterface.DuplicateException;
import com.ttv.zBandInterface.EncryptionViolationException;
import com.ttv.zBandInterface.InternalErrorException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidFilterValueException;
import com.ttv.zBandInterface.InvalidMetadataException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.LicenseException;
import com.ttv.zBandInterface.LinkObjectException;
import com.ttv.zBandInterface.ObjectStateException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.ZBandWSException;
import java.util.HashMap;
import org.apache.log4j.Category;

public class ExceptionManager {
    private static HashMap<String, ExceptionManager> ourInstances = new HashMap();
    private static final Category log = Category.getInstance(ExceptionManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private String username = null;
    private static HashMap<String, String> literalMap = new HashMap();

    public static synchronized ExceptionManager getInstance(String username) {
        ExceptionManager ourInstance = ourInstances.get(username);
        if (literalMap.isEmpty()) {
            ExceptionManager.InitializeLiteralMap();
        }
        if (ourInstance == null) {
            ourInstance = new ExceptionManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private ExceptionManager(String username) {
        this.username = username;
    }

    private static void InitializeLiteralMap() {
        literalMap.put("archived program", "Archived Package");
        literalMap.put("archived programs", "Archived Packages");
        literalMap.put("channel", "Queue");
        literalMap.put("channels", "Queues");
        literalMap.put("client", "Catcher");
        literalMap.put("clients", "Catchers");
        literalMap.put("client group", "Catcher Group");
        literalMap.put("client groups", "Catcher Groups");
        literalMap.put("client group member", "Catcher Group Member");
        literalMap.put("client group members", "Catcher Group Members");
        literalMap.put("client inventory", "Catcher Inventory");
        literalMap.put("client inventories", "Catcher Inventories");
        literalMap.put("job", "Pitch");
        literalMap.put("jobs", "Pitches");
        literalMap.put("policy user", "User");
        literalMap.put("policy users", "Users");
        literalMap.put("program template", "Package Type");
        literalMap.put("program templates", "Package Types");
        literalMap.put("program", "Package");
        literalMap.put("programs", "Packages");
    }

    private String TranslateMessage(String zbandmessage, String zbandliteral) {
        zbandliteral = zbandliteral.toLowerCase().trim();
        log.debug((Object)("zband literal : " + zbandliteral));
        log.debug((Object)("zband message : " + zbandmessage));
        String managermessage = zbandmessage;
        if (literalMap.containsKey(zbandliteral)) {
            String managerliteral = literalMap.get(zbandliteral);
            managermessage = zbandmessage.replaceAll(zbandliteral, managerliteral);
            log.debug((Object)("manager message : " + managermessage));
        }
        return managermessage;
    }

    public Exception TranslateException(ZBandWSException e) {
        if (e instanceof DuplicateException) {
            DuplicateException de = (DuplicateException)e;
            String mgrexceptionmessage = this.TranslateMessage(de.getFaultString(), de.getObjecttype());
            log.error((Object)("Following DuplicateException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            audit.error((Object)("Following DuplicateException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            return new WSDuplicateException(mgrexceptionmessage);
        }
        if (e instanceof DatabaseException) {
            DatabaseException de = (DatabaseException)e;
            String mgrexceptionmessage = this.TranslateMessage(de.getFaultString(), de.getObjecttype());
            log.error((Object)("Following DatabaseException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            audit.error((Object)("Following DatabaseException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            return new WSDatabaseException(mgrexceptionmessage);
        }
        if (e instanceof LinkObjectException) {
            LinkObjectException loe = (LinkObjectException)e;
            String mgrexceptionmessage = this.TranslateMessage(loe.getFaultString(), loe.getObjecttype());
            log.error((Object)("Following LinkObjectException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            audit.error((Object)("Following LinkObjectException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            return new WSLinkObjectException(mgrexceptionmessage);
        }
        if (e instanceof PermissionException) {
            PermissionException pe = (PermissionException)e;
            String mgrexceptionmessage = this.TranslateMessage(pe.getFaultString(), pe.getObjecttype());
            log.error((Object)("Following PermissionException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            audit.error((Object)("Following PermissionException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            return new WSPermissionException(mgrexceptionmessage);
        }
        if (e instanceof LicenseException) {
            LicenseException le = (LicenseException)e;
            String mgrexceptionmessage = this.TranslateMessage(le.getFaultString(), le.getObjecttype());
            log.error((Object)("Following LicenseException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            audit.error((Object)("Following LicenseException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            return new WSLicenseException(mgrexceptionmessage);
        }
        if (e instanceof EncryptionViolationException) {
            EncryptionViolationException eve = (EncryptionViolationException)e;
            String mgrexceptionmessage = this.TranslateMessage(eve.getFaultString(), eve.getObjecttype());
            log.error((Object)("Following EncryptionViolationException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            audit.error((Object)("Following EncryptionViolationException occured during " + this.username + " operation \n" + mgrexceptionmessage));
            return new WSEncryptionViolationException(mgrexceptionmessage);
        }
        if (e instanceof DifferentServiceException) {
            DifferentServiceException dse = (DifferentServiceException)e;
            log.error((Object)("Following DifferentServiceException occured during " + this.username + " operation \n" + dse.getFaultString()));
            audit.error((Object)("Following DifferentServiceException occured during " + this.username + " operation \n" + dse.getFaultString()));
            return new WSDifferentServiceException(dse.getFaultString());
        }
        if (e instanceof ObjectStateException) {
            ObjectStateException obse = (ObjectStateException)e;
            log.error((Object)("Following ModifyRunningJobException occured during " + this.username + " operation \n" + obse.getFaultString()));
            audit.error((Object)("Following ModifyRunningJobException occured during " + this.username + " operation \n" + obse.getFaultString()));
            return new WSObjectStateException(obse.getFaultString());
        }
        if (e instanceof ContentException) {
            ContentException ce = (ContentException)e;
            log.error((Object)("Following ContentException occured during " + this.username + " operation \n" + ce.getFaultString()));
            audit.error((Object)("Following ContentException occured during " + this.username + " operation \n" + ce.getFaultString()));
            return new WSContentException(ce.getFaultString());
        }
        if (e instanceof InvalidValueException) {
            InvalidValueException ive = (InvalidValueException)e;
            log.error((Object)("Following InvalidValueException occured during " + this.username + " operation \n" + ive.getFaultString()));
            audit.error((Object)("Following InvalidValueException occured during " + this.username + " operation \n" + ive.getFaultString()));
            return new WSInvalidValueException(ive.getFaultString());
        }
        if (e instanceof InvalidFilterException) {
            InvalidFilterException ife = (InvalidFilterException)e;
            log.error((Object)("Following InvalidFilterException occured during " + this.username + " operation \n" + ife.getFaultString()));
            audit.error((Object)("Following InvalidFilterException occured during " + this.username + " operation \n" + ife.getFaultString()));
            return new WSInvalidFilterException(ife.getFaultString());
        }
        if (e instanceof InvalidFilterValueException) {
            InvalidFilterValueException ifve = (InvalidFilterValueException)e;
            log.error((Object)("Following InvalidFilterValueException occured during " + this.username + " operation \n" + ifve.getFaultString()));
            audit.error((Object)("Following InvalidFilterValueException occured during " + this.username + " operation \n" + ifve.getFaultString()));
            return new WSInvalidFilterValueException(ifve.getFaultString());
        }
        if (e instanceof InvalidMetadataException) {
            InvalidMetadataException ime = (InvalidMetadataException)e;
            log.error((Object)("Following InvalidMetadataException occured during " + this.username + " operation \n" + ime.getFaultString()));
            audit.error((Object)("Following InvalidMetadataException occured during " + this.username + " operation \n" + ime.getFaultString()));
            return new WSInvalidMetadataException(ime.getFaultString());
        }
        if (e instanceof InternalErrorException) {
            InternalErrorException iee = (InternalErrorException)e;
            log.error((Object)("Following InternalErrorException occured during " + this.username + " operation \n" + iee.getFaultString()));
            audit.error((Object)("Following InternalErrorException occured during " + this.username + " operation \n" + iee.getFaultString()));
            return new WSInternalErrorException(iee.getFaultString());
        }
        log.error((Object)("Following Exception occured during " + this.username + " operation \n" + e.getFaultString()));
        audit.error((Object)("Following Exception occured during " + this.username + " operation \n" + e.getFaultString()));
        return new Exception(e.getFaultString());
    }
}

