/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.QueueManager;

import com.ttv.manager.Catcher.CatcherFilter;
import com.ttv.manager.Catcher.CatcherFilterByEnum;
import com.ttv.manager.Catcher.CatcherValues;
import com.ttv.manager.Catcher.CatchersResult;
import com.ttv.manager.CatcherGroup.CatcherGroupTypeEnum;
import com.ttv.manager.DeviceManager.DeviceManager;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Metadata.MetadataEnum;
import com.ttv.manager.Metadata.MetadataValues;
import com.ttv.manager.Package.PackageEncryptEnum;
import com.ttv.manager.Pitch.PitchDetails;
import com.ttv.manager.Pitch.PitchDetailsFilter;
import com.ttv.manager.Pitch.PitchDetailsResult;
import com.ttv.manager.Pitch.PitchDetailsSortByEnum;
import com.ttv.manager.Pitch.PitchDetailsStatusEnum;
import com.ttv.manager.Pitch.PitchFilter;
import com.ttv.manager.Pitch.PitchResult;
import com.ttv.manager.Pitch.PitchSortByEnum;
import com.ttv.manager.Pitch.PitchStatusEnum;
import com.ttv.manager.Pitch.PitchValues;
import com.ttv.manager.Queue.QueueTypeEnum;
import com.ttv.manager.Target.PitchTarget;
import com.ttv.manager.Target.PitchTargetFilter;
import com.ttv.manager.Target.PitchTargetResult;
import com.ttv.manager.Target.PitchTargetSortByEnum;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSDifferentServiceException;
import com.ttv.manager.WSException.WSInternalErrorException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSLinkObjectException;
import com.ttv.manager.WSException.WSObjectStateException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.util.CommonUtils;
import com.ttv.manager.util.FilterProperty;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.ChannelTypeEnum;
import com.ttv.zBandInterface.ClientGroupTypeEnum;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.DifferentServiceException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidFilterValueException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.Job;
import com.ttv.zBandInterface.JobDetail;
import com.ttv.zBandInterface.JobDetailFilter;
import com.ttv.zBandInterface.JobDetailSortByEnum;
import com.ttv.zBandInterface.JobDetailStatusEnum;
import com.ttv.zBandInterface.JobFilter;
import com.ttv.zBandInterface.JobSortByEnum;
import com.ttv.zBandInterface.JobStatusEnum;
import com.ttv.zBandInterface.JobTarget;
import com.ttv.zBandInterface.JobTargetFilter;
import com.ttv.zBandInterface.JobTargetSortByEnum;
import com.ttv.zBandInterface.LinkObjectException;
import com.ttv.zBandInterface.Metadata;
import com.ttv.zBandInterface.ObjectStateException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.ProgramPreEncryptionEnum;
import com.ttv.zBandInterface.holders.JobArrayHolder;
import com.ttv.zBandInterface.holders.JobDetailArrayHolder;
import com.ttv.zBandInterface.holders.JobTargetArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.rpc.holders.LongHolder;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;

public class QueueManager {
    private Logger log = Logger.getLogger(QueueManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, QueueManager> ourInstances = new HashMap();
    private String username = null;
    private static final String SENDER_NO_CONNECTION_MSG = "Could not connect to the Sender";

    public static synchronized QueueManager getInstance(String username) {
        QueueManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new QueueManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private QueueManager(String username) {
        this.username = username;
    }

    private JobFilter translatePitchFilter(PitchFilter pitchFilter) throws WSInvalidFilterException, WSInvalidFilterValueException {
        JobFilter jobFilter = new JobFilter();
        jobFilter.setAscending(pitchFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToJobFilterPropertyList(pitchFilter.getFilterPropertyList());
        jobFilter.setFilter(CommonUtils.serializeFilter(fp));
        jobFilter.setIndex(pitchFilter.getIndex());
        jobFilter.setLimit(pitchFilter.getLimit());
        if (pitchFilter.getSortby().equals(PitchSortByEnum.NextTime.getValue())) {
            jobFilter.setSortby(JobSortByEnum.NextTime);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Status.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Status);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Queue.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Channel);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Package.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Program);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.LicenseStartDate.getValue())) {
            jobFilter.setSortby(JobSortByEnum.LicenseStart);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.LicenseEndDate.getValue())) {
            jobFilter.setSortby(JobSortByEnum.LicenseEnd);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.MetadataVersion.getValue())) {
            jobFilter.setSortby(JobSortByEnum.MetadataVersion);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Provider.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Provider);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.ClientGroup.getValue())) {
            jobFilter.setSortby(JobSortByEnum.ClientGroup);
        }
        return jobFilter;
    }

    private PitchValues translateJob(Job job) {
        PitchValues pitchValues = new PitchValues();
        String queueid = job.getChannelid();
        pitchValues.setQueueid(queueid);
        pitchValues.setReceiversconfirmed(job.getClientsconfirmed());
        pitchValues.setReceiverspending(job.getClientspending());
        pitchValues.setCompletionTime(job.getCompletion());
        pitchValues.setRate(job.getRate());
        pitchValues.setId(job.getId());
        if (job.getType().equals(ChannelTypeEnum.MCAST)) {
            pitchValues.setQueueType(QueueTypeEnum.MCAST.getValue());
        } else if (job.getType().equals(ChannelTypeEnum.Aspera)) {
            pitchValues.setQueueType(QueueTypeEnum.Aspera.getValue());
        } else if (job.getType().equals(ChannelTypeEnum.HTTP)) {
            pitchValues.setQueueType(QueueTypeEnum.HTTP.getValue());
        }
        boolean editTarget = false;
        Metadata[] metadatas = job.getMetadata();
        ArrayList<MetadataValues> metadataValuesList = new ArrayList<MetadataValues>();
        if (metadatas != null) {
            for (int i = 0; i < metadatas.length; ++i) {
                Metadata metadata = metadatas[i];
                if (metadata == null) continue;
                MetadataValues metadataValues = CommonUtils.translateMetadata(metadata);
                if (metadataValues.getProperty().equals(MetadataEnum.MP_RePitch.getValue()) && metadataValues.getValue().equals("T")) {
                    editTarget = true;
                }
                this.log.debug((Object)("JOB METADATA VALUES = " + metadataValues.getProperty() + metadataValues.getValue()));
                metadataValuesList.add(metadataValues);
            }
        }
        pitchValues.setMetadataValuesList(metadataValuesList);
        pitchValues.setServiceid(job.getServiceid());
        pitchValues.setReceivergroupname(job.getClientgroupname());
        pitchValues.setNexttime(job.getStarttime());
        pitchValues.setOnhold(job.getOnhold());
        Long percentage = new Long(job.getPercentcomplete() != null ? job.getPercentcomplete().longValue() : 0L);
        pitchValues.setPercentcomplete(percentage);
        pitchValues.setPackageid(job.getProgramid());
        pitchValues.setStarttime(job.getScheduledtime());
        pitchValues.setPackagename(job.getProgramname());
        pitchValues.setQueuename(job.getChannelname());
        if (job.getPreencryption().equals(ProgramPreEncryptionEnum.Default)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.Default.getValue());
        } else if (job.getPreencryption().equals(ProgramPreEncryptionEnum.Disabled)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.Disabled.getValue());
        } else if (job.getPreencryption().equals(ProgramPreEncryptionEnum.Encrypted)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.Encrypted.getValue());
        } else if (job.getPreencryption().equals(ProgramPreEncryptionEnum.Encrypting)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.Encrypting.getValue());
        } else if (job.getPreencryption().equals(ProgramPreEncryptionEnum.ToBeEncrypted)) {
            pitchValues.setEncryptStatus(PackageEncryptEnum.ToBeEncrypted.getValue());
        }
        if (job.getStatus().equals(JobStatusEnum.Complete)) {
            pitchValues.setStatus(PitchStatusEnum.Complete.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Staged)) {
            pitchValues.setStatus(PitchStatusEnum.Staged.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Failed)) {
            pitchValues.setStatus(PitchStatusEnum.Failed.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Repairing)) {
            pitchValues.setStatus(PitchStatusEnum.Repairing.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Transmitting)) {
            pitchValues.setStatus(PitchStatusEnum.Transmitting.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Waiting)) {
            pitchValues.setStatus(PitchStatusEnum.Waiting.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.WaitingForAcknowledgement)) {
            pitchValues.setStatus(PitchStatusEnum.WaitingForAck.getValue());
        } else if (job.getStatus().equals(JobStatusEnum.Encrypting)) {
            pitchValues.setStatus(PitchStatusEnum.Encrypting.getValue());
        }
        pitchValues.setProvidername(job.getProvidername());
        pitchValues.setLicensestart(job.getLicensestart());
        pitchValues.setLicenseend(job.getLicenseend());
        pitchValues.setMetadataversion(job.getMetadataversion());
        pitchValues.setErrorcode(job.getErrorcode());
        return pitchValues;
    }

    private JobDetailFilter translatePitchDetailsFilter(PitchDetailsFilter pitchDetailsFilter) throws WSInvalidFilterException {
        JobDetailFilter jobdetailfilter = new JobDetailFilter();
        jobdetailfilter.setAscending(pitchDetailsFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToJobDetailsFilterPropertyList(pitchDetailsFilter.getFilterPropertyList());
        jobdetailfilter.setFilter(CommonUtils.serializeFilter(fp));
        jobdetailfilter.setIndex(pitchDetailsFilter.getIndex());
        jobdetailfilter.setLimit(pitchDetailsFilter.getLimit());
        if (pitchDetailsFilter.getSortby().equals(PitchDetailsSortByEnum.CatcherName)) {
            jobdetailfilter.setSortby(JobDetailSortByEnum.ClientName);
        } else if (pitchDetailsFilter.getSortby().equals(PitchDetailsSortByEnum.CatcherId)) {
            jobdetailfilter.setSortby(JobDetailSortByEnum.ClientId);
        } else if (pitchDetailsFilter.getSortby().equals(PitchDetailsSortByEnum.PitchId)) {
            jobdetailfilter.setSortby(JobDetailSortByEnum.JobId);
        }
        return jobdetailfilter;
    }

    private JobTargetFilter translatePitchTargetFilter(PitchTargetFilter pitchTargetFilter) {
        JobTargetFilter jobtargetFilter = new JobTargetFilter();
        jobtargetFilter.setAscending(pitchTargetFilter.getAscending());
        jobtargetFilter.setIndex(pitchTargetFilter.getIndex());
        jobtargetFilter.setFilter(CommonUtils.serializeFilter(pitchTargetFilter.getFilter()));
        if (pitchTargetFilter.getSortby().equals(PitchTargetSortByEnum.CatcherGroupName)) {
            jobtargetFilter.setSortby(JobTargetSortByEnum.ClientGroup);
        }
        jobtargetFilter.setLimit(pitchTargetFilter.getLimit());
        return jobtargetFilter;
    }

    private PitchTarget translateJobTarget(JobTarget jobtarget) {
        PitchTarget pitchTarget = new PitchTarget();
        pitchTarget.setCatchergroupId(jobtarget.getClientgroupid());
        pitchTarget.setCatcherGroupName(jobtarget.getClientgroupname());
        pitchTarget.setServiceId(jobtarget.getServiceid());
        if (jobtarget.getClientgrouptype().equals(ClientGroupTypeEnum.Individual)) {
            pitchTarget.setCatcherGroupType(CatcherGroupTypeEnum.Individual);
        } else if (jobtarget.getClientgrouptype().equals(ClientGroupTypeEnum.Normal)) {
            pitchTarget.setCatcherGroupType(CatcherGroupTypeEnum.Normal);
        } else if (jobtarget.getClientgrouptype().equals(ClientGroupTypeEnum.Special)) {
            pitchTarget.setCatcherGroupType(CatcherGroupTypeEnum.Special);
        }
        return pitchTarget;
    }

    private JobTarget translatePitchTarget(String pitchId, PitchTarget pitchTarget) {
        JobTarget jobtarget = new JobTarget();
        jobtarget.setJobid(pitchId);
        jobtarget.setClientgroupid(pitchTarget.getCatchergroupId());
        jobtarget.setClientgroupname(pitchTarget.getCatcherGroupName());
        if (pitchTarget.getCatcherGroupType().equals(CatcherGroupTypeEnum.Individual)) {
            jobtarget.setClientgrouptype(ClientGroupTypeEnum.Individual);
        } else if (pitchTarget.getCatcherGroupType().equals(CatcherGroupTypeEnum.Normal)) {
            jobtarget.setClientgrouptype(ClientGroupTypeEnum.Normal);
        } else if (pitchTarget.getCatcherGroupType().equals(CatcherGroupTypeEnum.Special)) {
            jobtarget.setClientgrouptype(ClientGroupTypeEnum.Special);
        }
        return jobtarget;
    }

    private void deletePitchTarget(String pitchid, String catcherGroupId) throws WSPermissionException, WSDatabaseException, WSObjectStateException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"deletePitchTarget() start:");
        try {
            WSLocator.getzBandInterface(this.username).deleteJobTarget(pitchid, catcherGroupId);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (ObjectStateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSObjectStateException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        audit.info((Object)(" : deleted Unicast target with pitch id [" + pitchid + "] by user [" + this.username + "]"));
        this.log.debug((Object)("deletePitchTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    private void addPitchTarget(String pitchId, PitchTarget pitchTarget) throws WSPermissionException, WSDatabaseException, WSObjectStateException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSDifferentServiceException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"addPitchTarget() start:");
        JobTarget jobtarget = this.translatePitchTarget(pitchId, pitchTarget);
        try {
            WSLocator.getzBandInterface(this.username).createJobTarget(jobtarget);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (ObjectStateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSObjectStateException)emgr.TranslateException(e);
        }
        catch (LinkObjectException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSLinkObjectException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (DifferentServiceException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDifferentServiceException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        this.log.debug((Object)("addPitchTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }

    public PitchValues getPitch(String pitchId) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"getPitch() start:");
        try {
            PitchValues pitchValues;
            Job job = WSLocator.getzBandInterface(this.username).getJob(pitchId);
            PitchValues pitchValues2 = pitchValues = this.translateJob(job);
            return pitchValues2;
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            this.log.debug((Object)("getPitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public PitchResult getPitchs(PitchFilter pitchFilter) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInternalErrorException, WSInvalidValueException, WSInvalidFilterValueException, WSDatabaseException, WSInvalidFilterException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"getPitchs() start:");
        PitchResult result = new PitchResult();
        if (pitchFilter == null) {
            return this.getPitchs();
        }
        JobFilter jobFilter = this.translatePitchFilter(pitchFilter);
        JobArrayHolder jobArrayHolder = new JobArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getJobs(jobFilter, jobArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        Job[] jobs = jobArrayHolder.value;
        ArrayList<PitchValues> pitchValuesList = new ArrayList<PitchValues>();
        if (jobs != null) {
            for (int i = 0; i < jobs.length; ++i) {
                Job job = jobs[i];
                if (job == null) continue;
                PitchValues pitchValues = this.translateJob(job);
                pitchValuesList.add(pitchValues);
            }
        }
        result = new PitchResult(pitchValuesList, new Long(count.value));
        this.log.debug((Object)("getPitchs() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return result;
    }

    public PitchResult getPitchs() throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInternalErrorException, WSInvalidValueException, WSInvalidFilterValueException, WSDatabaseException, WSInvalidFilterException {
        PitchFilter pitchFilter = new PitchFilter();
        pitchFilter.setAscending(new Boolean(true));
        pitchFilter.setIndex(new Long(0L));
        pitchFilter.setSortby(PitchSortByEnum.NextTime.getValue());
        return this.getPitchs(pitchFilter);
    }

    public void stopPitch(String pitchid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        this.log.debug((Object)"stopPitch() start:");
        long begin = System.currentTimeMillis();
        try {
            WSLocator.getzBandInterface(this.username).holdJob(pitchid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        this.log.debug((Object)("stopPitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Stopped pitch with pitch id [" + pitchid + "] by user [" + this.username + "]"));
    }

    public void restartPitch(String pitchid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        this.log.debug((Object)"restartPitch() start:");
        long begin = System.currentTimeMillis();
        try {
            WSLocator.getzBandInterface(this.username).releaseJob(pitchid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        this.log.debug((Object)("restartPitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Restarted pitch with pitch id [" + pitchid + "] by user [" + this.username + "]"));
    }

    public PitchDetailsResult getPitchDetails(PitchDetailsFilter pitchDetailsFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"getPitchDetails() start:");
        if (pitchDetailsFilter == null) {
            this.log.error((Object)"pitchDetailsFilter is null");
            throw new WSInvalidValueException("pitchDetailsFilter is null");
        }
        JobDetailFilter jobdetailfilter = this.translatePitchDetailsFilter(pitchDetailsFilter);
        JobDetailArrayHolder jobdetailholder = new JobDetailArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getJobDetails(jobdetailfilter, jobdetailholder, count);
            JobDetail[] jobdetails = jobdetailholder.value;
            ArrayList<PitchDetails> pitchDetailsList = new ArrayList<PitchDetails>();
            if (jobdetails != null) {
                for (int i = 0; i < jobdetails.length; ++i) {
                    JobDetail jobdetail = jobdetails[i];
                    if (jobdetail == null) continue;
                    PitchDetails pitchDetails = new PitchDetails();
                    pitchDetails.setReceiverid(jobdetail.getClientid());
                    pitchDetails.setPackageid(jobdetail.getProgramid());
                    pitchDetails.setPercentcomplete(jobdetail.getPercentcomplete());
                    pitchDetails.setReceivername(jobdetail.getClientname());
                    pitchDetails.setPackagename(jobdetail.getProgramname());
                    pitchDetails.setErrorcodeStr(jobdetail.getErrorcode());
                    if (jobdetail.getStatus().equals(JobDetailStatusEnum.Waiting)) {
                        pitchDetails.setStatus(PitchDetailsStatusEnum.Waiting.getValue());
                    } else if (jobdetail.getStatus().equals(JobDetailStatusEnum.Disabled)) {
                        pitchDetails.setStatus(PitchDetailsStatusEnum.Disabled.getValue());
                    } else if (jobdetail.getStatus().equals(JobDetailStatusEnum.Transmitting)) {
                        pitchDetails.setStatus(PitchDetailsStatusEnum.Transmitting.getValue());
                    } else if (jobdetail.getStatus().equals(JobDetailStatusEnum.Unconfirmed)) {
                        pitchDetails.setStatus(PitchDetailsStatusEnum.Unconfirmed.getValue());
                    } else if (jobdetail.getStatus().equals(JobDetailStatusEnum.Fragmented)) {
                        pitchDetails.setStatus(PitchDetailsStatusEnum.Fragmented.getValue());
                    } else if (jobdetail.getStatus().equals(JobDetailStatusEnum.Failed)) {
                        pitchDetails.setStatus(PitchDetailsStatusEnum.Failed.getValue());
                    } else if (jobdetail.getStatus().equals(JobDetailStatusEnum.Complete)) {
                        pitchDetails.setStatus(PitchDetailsStatusEnum.Complete.getValue());
                    } else if (jobdetail.getStatus().equals(JobDetailStatusEnum.Published)) {
                        pitchDetails.setStatus(PitchDetailsStatusEnum.Published.getValue());
                    }
                    pitchDetailsList.add(pitchDetails);
                }
            }
            PitchDetailsResult pitchDetailsResult = new PitchDetailsResult(pitchDetailsList, new Long(count.value));
            return pitchDetailsResult;
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            this.log.debug((Object)("getPitchDetails() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public void deletePitch(String pitchid) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        this.log.debug((Object)"deletePitch() start:");
        long begin = System.currentTimeMillis();
        try {
            WSLocator.getzBandInterface(this.username).deleteJob(pitchid);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        this.log.debug((Object)("deletePitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Deleted pitch with pitchid [" + pitchid + "] by user [" + this.username + "]"));
    }

    public void deletePitchs(ArrayList<String> pitchidList) throws WSPermissionException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        this.log.debug((Object)"deletePitchs() start:");
        long begin = System.currentTimeMillis();
        for (String pitchid : pitchidList) {
            this.deletePitch(pitchid);
        }
        this.log.debug((Object)("deletePitchs() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Deleted pitchs by user [" + this.username + "]"));
    }

    public PitchTargetResult getPitchTargets(PitchTargetFilter pitchTargetFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"getPitchTargets() start:");
        LongHolder count = new LongHolder(0L);
        JobTargetFilter jobTargetFilter = this.translatePitchTargetFilter(pitchTargetFilter);
        JobTargetArrayHolder jobTargetArrayHolder = new JobTargetArrayHolder();
        try {
            WSLocator.getzBandInterface(this.username).getJobTargets(jobTargetFilter, jobTargetArrayHolder, count);
            ArrayList<PitchTarget> pitchTargetsList = new ArrayList<PitchTarget>();
            JobTarget[] jobtargets = jobTargetArrayHolder.value;
            if (jobtargets != null) {
                for (int i = 0; i < jobtargets.length; ++i) {
                    JobTarget jobtarget = jobtargets[i];
                    if (jobtarget == null) continue;
                    pitchTargetsList.add(this.translateJobTarget(jobtarget));
                }
            }
            PitchTargetResult pitchTargetResult = new PitchTargetResult(pitchTargetsList, new Long(count.value));
            return pitchTargetResult;
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            this.log.debug((Object)("getPitchTargets() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public void addPitchTargets(String pitchId, ArrayList<PitchTarget> pitchTargets) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSObjectStateException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSDifferentServiceException {
        if (pitchTargets != null) {
            for (PitchTarget pitchTarget : pitchTargets) {
                this.addPitchTarget(pitchId, pitchTarget);
            }
        }
    }

    public void deletePitchTargets(String pitchId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSObjectStateException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (catcherGroupIds != null) {
            for (String catcherGroupId : catcherGroupIds) {
                this.deletePitchTarget(pitchId, catcherGroupId);
            }
        }
    }

    public void expandPitchTargetCatcherGroup(String catcherGroupId, String pitchId) throws WSInvalidFilterException, WSDatabaseException, WSObjectStateException, WSLinkObjectException, WSInvalidValueException, WSInvalidFilterValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSPermissionException, WSDifferentServiceException {
        long begin = System.currentTimeMillis();
        this.log.debug((Object)"expandPitchTargetCatcherGroup() start:");
        CatcherFilter catcherfilter = new CatcherFilter();
        ArrayList<FilterProperty> catcherfilterPropertylist = new ArrayList<FilterProperty>();
        catcherfilterPropertylist.add(new FilterProperty(CatcherFilterByEnum.CatcherGroupId.getValue(), "=", catcherGroupId));
        catcherfilterPropertylist.add(new FilterProperty(CatcherFilterByEnum.Enabled.getValue(), "=", "true"));
        catcherfilter.setFilterPropertyList(catcherfilterPropertylist);
        CatchersResult cResult = DeviceManager.getInstance(this.username).getCatchers(catcherfilter);
        ArrayList<CatcherValues> filteredCatchers = cResult.getCatcherValuesList();
        for (CatcherValues catcher : filteredCatchers) {
            PitchTarget pitchtarget = new PitchTarget();
            pitchtarget.setCatchergroupId(catcher.getId());
            pitchtarget.setCatcherGroupName(catcher.getName());
            pitchtarget.setCatcherGroupType(CatcherGroupTypeEnum.Individual);
            pitchtarget.setServiceId(catcher.getServiceid());
            this.addPitchTarget(pitchId, pitchtarget);
        }
        this.deletePitchTarget(pitchId, catcherGroupId);
        this.log.debug((Object)("expandPitchTargetCatcherGroup() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
    }
}

