/*
 * Decompiled with CFR 0.152.
 */
package com.ttv.manager.ScheduleManager;

import com.ttv.manager.CatcherGroup.CatcherGroupValues;
import com.ttv.manager.ConfigurationManager.ConfigurationManager;
import com.ttv.manager.ContentManager.ContentManager;
import com.ttv.manager.DeviceManager.DeviceManager;
import com.ttv.manager.ExceptionManager.ExceptionManager;
import com.ttv.manager.Metadata.MetadataEnum;
import com.ttv.manager.Metadata.MetadataValues;
import com.ttv.manager.Package.PackageValues;
import com.ttv.manager.Pitch.PitchFilter;
import com.ttv.manager.Pitch.PitchFilterByEnum;
import com.ttv.manager.Pitch.PitchResult;
import com.ttv.manager.Pitch.PitchSortByEnum;
import com.ttv.manager.Pitch.PitchStatusEnum;
import com.ttv.manager.Pitch.PitchValues;
import com.ttv.manager.Queue.QueueTypeEnum;
import com.ttv.manager.QueueManager.QueueManager;
import com.ttv.manager.Schedule.ScheduleByEnum;
import com.ttv.manager.Schedule.ScheduleCatcherGroups;
import com.ttv.manager.Schedule.SchedulePackages;
import com.ttv.manager.StagedPitch.StagedPitchValues;
import com.ttv.manager.StagedPitch.StagedPitchsResult;
import com.ttv.manager.WSException.WSConnectException;
import com.ttv.manager.WSException.WSContentException;
import com.ttv.manager.WSException.WSDatabaseException;
import com.ttv.manager.WSException.WSInternalErrorException;
import com.ttv.manager.WSException.WSInvalidFilterException;
import com.ttv.manager.WSException.WSInvalidFilterValueException;
import com.ttv.manager.WSException.WSInvalidLoginException;
import com.ttv.manager.WSException.WSInvalidMetadataException;
import com.ttv.manager.WSException.WSInvalidValueException;
import com.ttv.manager.WSException.WSLinkObjectException;
import com.ttv.manager.WSException.WSObjectStateException;
import com.ttv.manager.WSException.WSPermissionException;
import com.ttv.manager.WSException.WSServerDownException;
import com.ttv.manager.WSException.WSValueNullException;
import com.ttv.manager.util.CommonUtils;
import com.ttv.manager.util.FilterProperty;
import com.ttv.manager.util.WSLocator;
import com.ttv.zBandInterface.ChannelTypeEnum;
import com.ttv.zBandInterface.DatabaseException;
import com.ttv.zBandInterface.InvalidFilterException;
import com.ttv.zBandInterface.InvalidFilterValueException;
import com.ttv.zBandInterface.InvalidMetadataException;
import com.ttv.zBandInterface.InvalidValueException;
import com.ttv.zBandInterface.Job;
import com.ttv.zBandInterface.JobFilter;
import com.ttv.zBandInterface.JobScheduleByEnum;
import com.ttv.zBandInterface.JobSortByEnum;
import com.ttv.zBandInterface.JobStatusEnum;
import com.ttv.zBandInterface.JobTarget;
import com.ttv.zBandInterface.JobTargetFilter;
import com.ttv.zBandInterface.JobTargetFilterByEnum;
import com.ttv.zBandInterface.LinkObjectException;
import com.ttv.zBandInterface.Metadata;
import com.ttv.zBandInterface.ObjectStateException;
import com.ttv.zBandInterface.PermissionException;
import com.ttv.zBandInterface.holders.JobArrayHolder;
import com.ttv.zBandInterface.holders.JobTargetArrayHolder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.TimeZone;
import javax.xml.rpc.holders.LongHolder;
import org.apache.log4j.Category;

public class ScheduleManager {
    private static final Category log = Category.getInstance(ScheduleManager.class);
    private static final Category audit = Category.getInstance((String)"AUDIT");
    private static HashMap<String, ScheduleManager> ourInstances = new HashMap();
    private String username = null;
    private static final String SENDER_NO_CONNECTION_MSG = "Could not connect to the Sender";

    public static synchronized ScheduleManager getInstance(String username) {
        ScheduleManager ourInstance = ourInstances.get(username);
        if (ourInstance == null) {
            ourInstance = new ScheduleManager(username);
            ourInstances.put(username, ourInstance);
        }
        return ourInstance;
    }

    private ScheduleManager(String username) {
        this.username = username;
    }

    private JobFilter translatePitchFilter(PitchFilter pitchFilter) throws WSInvalidFilterException, WSInvalidFilterValueException {
        log.debug((Object)"inside translatePitchFilter");
        JobFilter jobFilter = new JobFilter();
        jobFilter.setAscending(pitchFilter.getAscending());
        ArrayList<FilterProperty> fp = CommonUtils.translateToJobFilterPropertyList(pitchFilter.getFilterPropertyList());
        jobFilter.setFilter(CommonUtils.serializeFilter(fp));
        jobFilter.setIndex(pitchFilter.getIndex());
        jobFilter.setLimit(ConfigurationManager.getInstance(this.username).getPitchsPerPage());
        jobFilter.setLimit(pitchFilter.getLimit());
        if (pitchFilter.getSortby().equals(PitchSortByEnum.NextTime.getValue())) {
            jobFilter.setSortby(JobSortByEnum.NextTime);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Status.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Status);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Queue.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Channel);
        } else if (pitchFilter.getSortby().equals(PitchSortByEnum.Package.getValue())) {
            jobFilter.setSortby(JobSortByEnum.Program);
        }
        log.debug((Object)"End of translatePitchFilter");
        return jobFilter;
    }

    private JobScheduleByEnum tanslatePitchScheduleByEnum(ScheduleByEnum scheduletype) {
        if (scheduletype.getValue().equalsIgnoreCase(ScheduleByEnum.BottomOfQueue.getValue())) {
            return JobScheduleByEnum.BottomOfQueue;
        }
        if (scheduletype.getValue().equalsIgnoreCase(ScheduleByEnum.TopOfQueue.getValue())) {
            return JobScheduleByEnum.TopOfQueue;
        }
        if (scheduletype.getValue().equalsIgnoreCase(ScheduleByEnum.DateTime.getValue())) {
            return JobScheduleByEnum.DateTime;
        }
        if (scheduletype.getValue().equalsIgnoreCase(ScheduleByEnum.ScheduleAfter.getValue())) {
            return JobScheduleByEnum.DateTime;
        }
        if (scheduletype.getValue().equalsIgnoreCase(ScheduleByEnum.ScheduleBefore.getValue())) {
            return JobScheduleByEnum.DateTime;
        }
        return JobScheduleByEnum.TopOfQueue;
    }

    private Job translatePitchValue(PitchValues pitchvalue) {
        Job job = new Job();
        job.setProgramid(pitchvalue.getPackageid());
        job.setChannelid(pitchvalue.getQueueid());
        job.setScheduledtime(pitchvalue.getStarttime());
        job.setStarttime(pitchvalue.getNexttime());
        job.setProgramname("");
        job.setChannelname("");
        job.setErrorcode("");
        if (pitchvalue.getQueueType().equals(QueueTypeEnum.MCAST.getValue())) {
            job.setType(ChannelTypeEnum.MCAST);
        } else if (pitchvalue.getQueueType().equals(QueueTypeEnum.Aspera.getValue())) {
            job.setType(ChannelTypeEnum.Aspera);
        } else if (pitchvalue.getQueueType().equals(QueueTypeEnum.HTTP.getValue())) {
            job.setType(ChannelTypeEnum.HTTP);
        }
        job.setOnhold(pitchvalue.getIsOnhold());
        if (pitchvalue.getStatus().equals(PitchStatusEnum.Staged.getValue())) {
            job.setStatus(JobStatusEnum.Staged);
        } else if (pitchvalue.getStatus().equals(PitchStatusEnum.Complete.getValue())) {
            job.setStatus(JobStatusEnum.Complete);
        } else if (pitchvalue.getStatus().equals(PitchStatusEnum.Waiting.getValue())) {
            job.setStatus(JobStatusEnum.Waiting);
        } else if (pitchvalue.getStatus().equals(PitchStatusEnum.WaitingForAck.getValue())) {
            job.setStatus(JobStatusEnum.WaitingForAcknowledgement);
        } else if (pitchvalue.getStatus().equals(PitchStatusEnum.Failed.getValue())) {
            job.setStatus(JobStatusEnum.Failed);
        } else if (pitchvalue.getStatus().equals(PitchStatusEnum.Transmitting.getValue())) {
            job.setStatus(JobStatusEnum.Transmitting);
        } else if (pitchvalue.getStatus().equals(PitchStatusEnum.Repairing.getValue())) {
            job.setStatus(JobStatusEnum.Repairing);
        } else if (pitchvalue.getStatus().equals(PitchStatusEnum.Encrypting.getValue())) {
            job.setStatus(JobStatusEnum.Encrypting);
        }
        return job;
    }

    private Calendar getPitchStartTime(ScheduleByEnum scheduleBy, String scheduleByValue) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        ConfigurationManager configMgr = ConfigurationManager.getInstance(this.username);
        String userTimeZone = configMgr.getTimeZone();
        GregorianCalendar pitchStartTime = new GregorianCalendar(TimeZone.getTimeZone(userTimeZone));
        if (scheduleBy.equals(ScheduleByEnum.TopOfQueue)) {
            pitchStartTime.setTimeInMillis(0L);
        } else if (!scheduleBy.equals(ScheduleByEnum.BottomOfQueue)) {
            if (scheduleBy.equals(ScheduleByEnum.DateTime)) {
                Long millis = new Long(scheduleByValue);
                pitchStartTime.setTimeInMillis(millis);
            } else if (scheduleBy.equals(ScheduleByEnum.ScheduleBefore)) {
                Job beforeThisJob;
                String pitchBeforeId = scheduleByValue;
                try {
                    beforeThisJob = WSLocator.getzBandInterface(this.username).getJob(pitchBeforeId);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
                }
                Calendar beforeThisDate = beforeThisJob.getStarttime();
                pitchStartTime.setTimeInMillis(beforeThisDate.getTimeInMillis() - 1000L);
            } else if (scheduleBy.equals(ScheduleByEnum.ScheduleAfter)) {
                Job afterThisJob;
                String pitchAfterId = scheduleByValue;
                try {
                    afterThisJob = WSLocator.getzBandInterface(this.username).getJob(pitchAfterId);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
                }
                Calendar afterThisDate = afterThisJob.getStarttime();
                pitchStartTime.setTimeInMillis(afterThisDate.getTimeInMillis() + 1000L);
            }
        }
        return pitchStartTime;
    }

    private SchedulePackages createSchedPackages(PackageValues packageValues) {
        SchedulePackages schedulePackages = new SchedulePackages();
        schedulePackages.setId(packageValues.getId());
        schedulePackages.setName(packageValues.getName());
        return schedulePackages;
    }

    private ArrayList<ScheduleCatcherGroups> createSchedCatcherGroups(ArrayList<CatcherGroupValues> catcherGroupList) {
        ArrayList<ScheduleCatcherGroups> scheduleCatcherGroupsList = new ArrayList<ScheduleCatcherGroups>();
        for (CatcherGroupValues catcherGroupValues : catcherGroupList) {
            ScheduleCatcherGroups scg = new ScheduleCatcherGroups();
            scg.setId(catcherGroupValues.getId());
            scg.setServiceid(catcherGroupValues.getServiceid());
            scheduleCatcherGroupsList.add(scg);
        }
        return scheduleCatcherGroupsList;
    }

    private CatcherGroupValues translateJobTarget(JobTarget jobtarget) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        DeviceManager dmgr = DeviceManager.getInstance(this.username);
        return dmgr.getCatcherGroup(jobtarget.getClientgroupid());
    }

    private ArrayList<CatcherGroupValues> getCatcherGroupsForPitch(String pitchid) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        ArrayList<CatcherGroupValues> catcherGroupTargets = new ArrayList<CatcherGroupValues>();
        JobTargetFilter jobtargetFilter = new JobTargetFilter();
        String filter = JobTargetFilterByEnum.JobId.getValue() + "=" + pitchid;
        jobtargetFilter.setFilter(filter);
        JobTargetArrayHolder jobtargetArrayHolder = new JobTargetArrayHolder();
        LongHolder count = new LongHolder(0L);
        try {
            WSLocator.getzBandInterface(this.username).getJobTargets(jobtargetFilter, jobtargetArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        JobTarget[] jobtargets = jobtargetArrayHolder.value;
        if (jobtargets != null) {
            for (int i = 0; i < jobtargets.length; ++i) {
                JobTarget jobtarget = jobtargets[i];
                if (jobtarget == null) continue;
                catcherGroupTargets.add(this.translateJobTarget(jobtarget));
            }
        }
        return catcherGroupTargets;
    }

    private ScheduleByEnum getScheduleBy(ArrayList<MetadataValues> metadataValuesList) {
        ScheduleByEnum scheduleBy = ScheduleByEnum.BottomOfQueue;
        for (MetadataValues metadataValues : metadataValuesList) {
            if (!metadataValues.getProperty().endsWith(MetadataEnum.MP_ScheduleType.getValue())) continue;
            scheduleBy = ScheduleByEnum.fromString(metadataValues.getValue());
            break;
        }
        return scheduleBy;
    }

    private String getScheduleValue(ArrayList<MetadataValues> metadataValuesList) {
        String scheduleValue = "";
        for (MetadataValues metadataValues : metadataValuesList) {
            if (!metadataValues.getProperty().endsWith(MetadataEnum.MP_ScheduleValue.getValue())) continue;
            scheduleValue = metadataValues.getValue();
            break;
        }
        return scheduleValue;
    }

    private void unmarkStagedMetadata(PackageValues packageValues) throws WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException {
        ArrayList<MetadataValues> metadataValuesList = packageValues.getmetadataValuesList();
        for (MetadataValues metadataValues : metadataValuesList) {
            if (!metadataValues.getProperty().endsWith(MetadataEnum.MP_Staged.getValue())) continue;
            metadataValues.setValue("");
            break;
        }
        ContentManager.getInstance(this.username).updatePackage(packageValues);
    }

    private void editStagedMetadata(PackageValues packageValues, ScheduleByEnum scheduleBy, String scheduleValue) throws WSInvalidMetadataException, WSPermissionException, WSContentException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInternalErrorException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSObjectStateException {
        ArrayList<MetadataValues> metadataValuesList = packageValues.getmetadataValuesList();
        for (MetadataValues metadataValues : metadataValuesList) {
            if (metadataValues.getProperty().endsWith(MetadataEnum.MP_ScheduleType.getValue())) {
                metadataValues.setValue(scheduleBy.getValue());
            }
            if (!metadataValues.getProperty().endsWith(MetadataEnum.MP_ScheduleValue.getValue())) continue;
            metadataValues.setValue(scheduleValue);
        }
        ContentManager.getInstance(this.username).updatePackage(packageValues);
    }

    private Calendar scheduleBottomOfQueue(String queueId) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidFilterValueException, WSPermissionException {
        long begin = System.currentTimeMillis();
        log.debug((Object)("scheduleBottomOfQueue Start: [t=" + (double)System.currentTimeMillis() / 1000.0 + "]"));
        ConfigurationManager configMgr = ConfigurationManager.getInstance(this.username);
        String userTimeZone = configMgr.getTimeZone();
        GregorianCalendar pitchStartTime = new GregorianCalendar(TimeZone.getTimeZone(userTimeZone));
        PitchFilter pitchFilter = new PitchFilter();
        ArrayList<FilterProperty> pendingPitchesFilterPropertylist = new ArrayList<FilterProperty>();
        String[] selectedstatusList = new String[5];
        selectedstatusList[0] = PitchStatusEnum.Waiting.getValue();
        String statusstring = "";
        for (int i = 0; i < selectedstatusList.length; ++i) {
            statusstring = i == 0 ? selectedstatusList[i] : statusstring + "|" + selectedstatusList[i];
        }
        pendingPitchesFilterPropertylist.add(new FilterProperty(PitchFilterByEnum.Status.getValue(), statusstring));
        pendingPitchesFilterPropertylist.add(new FilterProperty(PitchFilterByEnum.QueueId.getValue(), queueId));
        pitchFilter.setFilterPropertyList(pendingPitchesFilterPropertylist);
        pitchFilter.setAscending(false);
        pitchFilter.setIndex(1L);
        pitchFilter.setLimit(1L);
        JobFilter jobFilter = this.translatePitchFilter(pitchFilter);
        JobArrayHolder jobArrayHolder = new JobArrayHolder();
        LongHolder count = new LongHolder();
        try {
            WSLocator.getzBandInterface(this.username).getJobs(jobFilter, jobArrayHolder, count);
        }
        catch (InvalidFilterException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (InvalidFilterValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidFilterValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        Job[] jobs = jobArrayHolder.value;
        if (jobs == null) {
            pitchStartTime.setTimeInMillis(0L);
        } else if (jobs.length == 0) {
            pitchStartTime.setTimeInMillis(0L);
        } else {
            Job lastJob = jobs[0];
            pitchStartTime.setTimeInMillis(lastJob.getCompletion().getTimeInMillis());
        }
        log.debug((Object)("scheduleBottomOfQueue complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        return pitchStartTime;
    }

    public void appendTarget(String pitchId, ArrayList<ScheduleCatcherGroups> catcherGroupsList, ScheduleByEnum scheduleBy, String scheduleByValue) throws WSValueNullException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSDatabaseException, WSLinkObjectException, WSPermissionException, WSInvalidValueException, WSObjectStateException, WSInvalidMetadataException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"appendTarget() start:");
        if (catcherGroupsList == null || catcherGroupsList.size() == 0) {
            log.error((Object)"Catchers are not selected");
            throw new WSValueNullException("Catchers are not selected");
        }
        try {
            Job currentJob = WSLocator.getzBandInterface(this.username).getJob(pitchId);
            Calendar startTime = this.getPitchStartTime(scheduleBy, scheduleByValue);
            currentJob.setScheduledtime(startTime);
            Metadata[] metadata = new Metadata[1];
            log.debug((Object)("METADATA ENUM = " + MetadataEnum.MP_RePitch.getValue()));
            metadata[0] = new Metadata(MetadataEnum.MP_RePitch.getValue(), "T");
            currentJob.setMetadata(metadata);
            WSLocator.getzBandInterface(this.username).setJob(currentJob);
            for (ScheduleCatcherGroups catchergroup : catcherGroupsList) {
                JobTarget jobtarget = new JobTarget(pitchId, catchergroup.getId(), null, null, null);
                WSLocator.getzBandInterface(this.username).createJobTarget(jobtarget);
            }
        }
        catch (ObjectStateException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSObjectStateException)emgr.TranslateException(e);
        }
        catch (InvalidMetadataException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidMetadataException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        log.debug((Object)("appendTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Catchers/groups count [" + catcherGroupsList.size() + "] appended to target by user [" + this.username + "]"));
    }

    public void jobTarget(ArrayList<PitchValues> pitchList, ArrayList<ScheduleCatcherGroups> catcherGroupsList) throws WSValueNullException, WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"jobTarget() start:");
        if (pitchList == null || catcherGroupsList != null && catcherGroupsList.size() == 0) {
            log.error((Object)"Either packages and/or catchers are not selected");
            throw new WSValueNullException("Either packages and/or catchers are not selected");
        }
        for (PitchValues selectedPitch : pitchList) {
            for (ScheduleCatcherGroups catchergroup : catcherGroupsList) {
                JobTarget jobtarget = new JobTarget(selectedPitch.getId(), catchergroup.getId(), null, null, null);
                try {
                    WSLocator.getzBandInterface(this.username).createJobTarget(jobtarget);
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (LinkObjectException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSLinkObjectException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
                }
            }
        }
        log.debug((Object)("jobTarget() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        audit.info((Object)("Targeted pitches count [" + pitchList.size() + "] to catchers/groups count [" + catcherGroupsList.size() + "] by user [" + this.username + "]"));
    }

    public void reSchedule(PitchValues pitch, ScheduleByEnum scheduletype, Calendar scheduledtime, Calendar starttime, ArrayList<String> targetIdlist) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException, WSObjectStateException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"reSchedule() start:");
        if (pitch.getStatus().equalsIgnoreCase(PitchStatusEnum.Failed.getValue()) || pitch.getStatus().equalsIgnoreCase(PitchStatusEnum.Complete.getValue())) {
            pitch.setStarttime(scheduledtime);
            pitch.setNexttime(starttime);
            this.schedule(pitch, scheduletype, targetIdlist, new ArrayList<String>());
            if (pitch.getStatus().equalsIgnoreCase(PitchStatusEnum.Failed.getValue())) {
                ArrayList<String> delPitchList = new ArrayList<String>();
                log.debug((Object)(pitch.getId() + ",resheduled,now will be deleted"));
                delPitchList.add(pitch.getId());
                QueueManager.getInstance(this.username).deletePitchs(delPitchList);
            }
            log.debug((Object)("reSchedule() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        } else {
            String[] catcherGrpIdList = targetIdlist.toArray(new String[targetIdlist.size()]);
            try {
                WSLocator.getzBandInterface(this.username).rescheduleJob(pitch.getId(), this.tanslatePitchScheduleByEnum(scheduletype), scheduledtime, starttime, catcherGrpIdList);
            }
            catch (ObjectStateException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                log.debug((Object)"Inside ObjectStateException");
                throw (WSObjectStateException)emgr.TranslateException(e);
            }
            catch (PermissionException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                log.debug((Object)"Inside PermissionException");
                throw (WSPermissionException)emgr.TranslateException(e);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                log.debug((Object)"Inside DatabaseException");
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (InvalidValueException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                log.debug((Object)"Inside InvalidValueException");
                throw (WSInvalidValueException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
            }
            finally {
                log.debug((Object)("reSchedule() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
            }
        }
    }

    public String schedule(PitchValues pitch, ScheduleByEnum scheduletype, ArrayList<String> targetIdlist) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException {
        return this.schedule(pitch, scheduletype, targetIdlist, new ArrayList<String>());
    }

    public String schedule(PitchValues pitch, ScheduleByEnum scheduletype, ArrayList<String> targetIdlist, ArrayList<String> ruleIdList) throws WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidMetadataException, WSPermissionException, WSDatabaseException, WSInvalidValueException {
        long begin = System.currentTimeMillis();
        log.debug((Object)"schedule2() start:");
        String[] catcherGrpIdList = targetIdlist.toArray(new String[targetIdlist.size()]);
        String[] ruleIds = ruleIdList.toArray(new String[ruleIdList.size()]);
        Job job = this.translatePitchValue(pitch);
        try {
            String string = WSLocator.getzBandInterface(this.username).createJob(job, this.tanslatePitchScheduleByEnum(scheduletype), catcherGrpIdList, ruleIds);
            return string;
        }
        catch (InvalidMetadataException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidMetadataException");
            throw (WSInvalidMetadataException)emgr.TranslateException(e);
        }
        catch (PermissionException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside PermissionException");
            throw (WSPermissionException)emgr.TranslateException(e);
        }
        catch (DatabaseException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside DatabaseException");
            throw (WSDatabaseException)emgr.TranslateException(e);
        }
        catch (InvalidValueException e) {
            ExceptionManager emgr = ExceptionManager.getInstance(this.username);
            log.debug((Object)"Inside InvalidValueException");
            throw (WSInvalidValueException)emgr.TranslateException(e);
        }
        catch (RemoteException e) {
            audit.error((Object)("Exception is:" + e), (Throwable)e);
            throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
        }
        finally {
            log.debug((Object)("schedule2() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
        }
    }

    public StagedPitchsResult getStagedPitchs() throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInternalErrorException, WSInvalidFilterValueException {
        PitchFilter stagedPitchFilter = new PitchFilter();
        ArrayList<FilterProperty> stagedPitchesFilterPropertylist = new ArrayList<FilterProperty>();
        stagedPitchesFilterPropertylist.add(new FilterProperty(PitchFilterByEnum.Status.getValue(), PitchStatusEnum.Staged.getValue()));
        stagedPitchFilter.setFilterPropertyList(stagedPitchesFilterPropertylist);
        stagedPitchFilter.setIndex(new Long(0L));
        return this.getStagedPitchs(stagedPitchFilter);
    }

    public StagedPitchsResult getStagedPitchs(PitchFilter satgedpitchFilter) throws WSInvalidFilterException, WSDatabaseException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInternalErrorException, WSInvalidFilterValueException {
        HashMap<String, StagedPitchValues> map = new HashMap<String, StagedPitchValues>();
        QueueManager qmgr = QueueManager.getInstance(this.username);
        PitchResult result = qmgr.getPitchs(satgedpitchFilter);
        ArrayList<PitchValues> pitchValuesList = result.getPitchValuesList();
        Long totalStagedPitchs = result.getTotalCount();
        for (PitchValues pitchValues : pitchValuesList) {
            StagedPitchValues stagedPitchValues = new StagedPitchValues();
            stagedPitchValues.setPitchValues(pitchValues);
            String pitchId = pitchValues.getId();
            stagedPitchValues.setCatcherGroupList(this.getCatcherGroupsForPitch(pitchId));
            map.put(pitchValues.getId(), stagedPitchValues);
        }
        StagedPitchsResult stagedPitchsResult = new StagedPitchsResult(map, totalStagedPitchs);
        return stagedPitchsResult;
    }

    public StagedPitchValues getStagedPitch(String pitchid) throws WSDatabaseException, WSInvalidLoginException, WSServerDownException, WSConnectException, WSInvalidFilterException, WSInvalidValueException {
        PitchValues pitchValues = QueueManager.getInstance(this.username).getPitch(pitchid);
        StagedPitchValues stagedPitchValues = new StagedPitchValues();
        stagedPitchValues.setPitchValues(pitchValues);
        stagedPitchValues.setCatcherGroupList(this.getCatcherGroupsForPitch(pitchValues.getId()));
        return stagedPitchValues;
    }

    public void approveStagedPitchs(ArrayList<String> pitchIds) throws WSDatabaseException, WSConnectException, WSInvalidLoginException, WSServerDownException {
        long begin = System.currentTimeMillis();
        if (pitchIds != null) {
            for (String pitchId : pitchIds) {
                try {
                    Job job = WSLocator.getzBandInterface(this.username).getJob(pitchId);
                    job.setStatus(JobStatusEnum.Waiting);
                    job.setOnhold(false);
                    WSLocator.getzBandInterface(this.username).setJob(job);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
                }
                finally {
                    log.debug((Object)("getPitch() complete: [t=" + (double)(System.currentTimeMillis() - begin) / 1000.0 + "]"));
                }
            }
        }
    }

    public void removeCatcherGroupsFromPitch(String pitchId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSObjectStateException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        if (pitchId != null && catcherGroupIds != null) {
            try {
                for (String catcherGroupId : catcherGroupIds) {
                    WSLocator.getzBandInterface(this.username).deleteJobTarget(pitchId, catcherGroupId);
                }
            }
            catch (PermissionException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSPermissionException)emgr.TranslateException(e);
            }
            catch (DatabaseException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSDatabaseException)emgr.TranslateException(e);
            }
            catch (ObjectStateException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSObjectStateException)emgr.TranslateException(e);
            }
            catch (InvalidValueException e) {
                ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                throw (WSInvalidValueException)emgr.TranslateException(e);
            }
            catch (RemoteException e) {
                audit.error((Object)("Exception is:" + e), (Throwable)e);
                throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
            }
        }
    }

    public void addCatcherGroupsToPitch(String pitchId, ArrayList<String> catcherGroupIds) throws WSPermissionException, WSDatabaseException, WSLinkObjectException, WSInvalidValueException, WSInvalidLoginException, WSServerDownException, WSConnectException {
        log.debug((Object)"addCatcherGroupsToPitch() start:");
        if (pitchId != null && catcherGroupIds != null) {
            for (String catcherGroupId : catcherGroupIds) {
                JobTarget jobtarget = new JobTarget();
                jobtarget.setClientgroupid(catcherGroupId);
                jobtarget.setJobid(pitchId);
                try {
                    WSLocator.getzBandInterface(this.username).createJobTarget(jobtarget);
                }
                catch (PermissionException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSPermissionException)emgr.TranslateException(e);
                }
                catch (DatabaseException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSDatabaseException)emgr.TranslateException(e);
                }
                catch (LinkObjectException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSLinkObjectException)emgr.TranslateException(e);
                }
                catch (InvalidValueException e) {
                    ExceptionManager emgr = ExceptionManager.getInstance(this.username);
                    throw (WSInvalidValueException)emgr.TranslateException(e);
                }
                catch (RemoteException e) {
                    audit.error((Object)("Exception is:" + e), (Throwable)e);
                    throw new WSConnectException(SENDER_NO_CONNECTION_MSG);
                }
            }
        }
        log.debug((Object)"addCatcherGroupsToPitch() start:");
    }
}

