/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.util.Map;

public class DataTypeMappingReader {
    private static DataTypeMappingReader instance = null;
    Map<String, String> dataTypeXpathMap;

    protected DataTypeMappingReader(String dataTypeMappingFile) {
        this.dataTypeXpathMap = MappingFileParser.readFieldMapping(dataTypeMappingFile);
    }

    public static DataTypeMappingReader getInstance() {
        return DataTypeMappingReader.getInstance(null);
    }

    public static synchronized DataTypeMappingReader getInstance(String dataTypeMappingFile) {
        if (instance == null) {
            if (dataTypeMappingFile == null) {
                dataTypeMappingFile = "DatatypeMapping.dat";
            }
            instance = new DataTypeMappingReader(dataTypeMappingFile);
        }
        return instance;
    }

    public Map<String, String> getDataTypeXpathMap() {
        return this.dataTypeXpathMap;
    }

    public String determineDataType(String ttvXPath) {
        String type = null;
        if (this.dataTypeXpathMap.containsKey(ttvXPath)) {
            type = this.dataTypeXpathMap.get(ttvXPath);
        }
        return type;
    }

    public boolean hasChildren(String ttvXPath) {
        String prefix = ttvXPath + "/";
        for (String key : this.dataTypeXpathMap.keySet()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

