/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldTreeNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FieldTree {
    private static final String _ATTRIBUTE = "/@";
    private static final String _CLOSING_BRACE = "}";
    private static final String _OPENING_BRACE = "{";
    private static final String _TNS = "/tns:";
    private FieldTreeNode rootElement = new FieldTreeNode();

    public FieldTree() {
        this.rootElement.setName("Fields");
        this.rootElement.setCurrentIndex(1);
    }

    public FieldTree(String rootName, Integer currentIndex) {
        this.rootElement.setName(rootName);
        this.rootElement.setCurrentIndex(currentIndex);
    }

    public FieldTreeNode getRootElement() {
        return this.rootElement;
    }

    public void setRootElement(FieldTreeNode rootElement) {
        this.rootElement = rootElement;
    }

    public String toString() {
        return this.toList().toString();
    }

    public List<FieldTreeNode> toList() {
        ArrayList<FieldTreeNode> list = new ArrayList<FieldTreeNode>();
        this.walk(this.rootElement, list);
        return list;
    }

    private void walk(FieldTreeNode node, List<FieldTreeNode> list) {
        list.add(node);
        for (FieldTreeNode child : node.getChildren()) {
            this.walk(child, list);
        }
    }

    public List<Field> depthFirstTraversal() {
        return this.depthFirstTraversal(new ArrayList<Field>(), this.rootElement, "");
    }

    private List<Field> depthFirstTraversal(List<Field> fieldList, FieldTreeNode node, String xpath) {
        if (!node.isLeafNode()) {
            xpath = xpath + _TNS + node.getName() + _OPENING_BRACE + node.getCurrentIndex() + _CLOSING_BRACE;
            for (FieldTreeNode child : node.getChildren()) {
                this.depthFirstTraversal(fieldList, child, xpath);
            }
        } else {
            String[] indexSplit;
            boolean isAttribute = node.isAttribute();
            xpath = isAttribute ? xpath + _ATTRIBUTE + node.getName() + _OPENING_BRACE + node.getCurrentIndex() + _CLOSING_BRACE : xpath + _TNS + node.getName() + _OPENING_BRACE + node.getCurrentIndex() + _CLOSING_BRACE;
            List<Integer> indices = new ArrayList();
            for (String indexStr : indexSplit = xpath.split("\\{")) {
                int bracket = indexStr.indexOf(_CLOSING_BRACE);
                if (bracket <= -1) continue;
                indices.add(Integer.parseInt(indexStr.substring(0, bracket)));
            }
            if (isAttribute) {
                indices = indices.subList(0, indices.size() - 1);
            }
            Field f = new Field();
            f.setId(node.getField().getId());
            f.setDataType(node.getField().getDataType());
            f.setTtvXPath(xpath.replaceAll("\\{[0-9]*\\}", ""));
            f.setIndices(indices);
            f.setValue(node.getField().getValue());
            fieldList.add(f);
            xpath = "";
        }
        return fieldList;
    }

    public List<FieldTreeNode> breadthFirstTraversal(ConcurrentLinkedQueue<FieldTreeNode> queue) {
        ArrayList<FieldTreeNode> resultList = new ArrayList<FieldTreeNode>();
        this.rootElement.setCurrentIndex(1);
        queue.offer(this.rootElement);
        resultList.add(this.rootElement);
        return this.breadthFirstTraversal(queue, resultList);
    }

    private List<FieldTreeNode> breadthFirstTraversal(ConcurrentLinkedQueue<FieldTreeNode> queue, List<FieldTreeNode> resultList) {
        while (!queue.isEmpty()) {
            FieldTreeNode node = (FieldTreeNode)queue.remove();
            HashMap<String, Integer> names = new HashMap<String, Integer>();
            for (FieldTreeNode child : node.getChildren()) {
                String name = child.getName();
                if (names.containsKey(name)) {
                    Integer index;
                    Integer n = index = (Integer)names.get(name);
                    Integer n2 = index = Integer.valueOf(index + 1);
                    child.setCurrentIndex(index);
                    names.put(name, index);
                } else {
                    child.setCurrentIndex(1);
                    names.put(name, 1);
                }
                queue.offer(child);
                resultList.add(child);
            }
        }
        return resultList;
    }
}

