/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.tandbergtv.metadatamanager.MetadataManagerDAO;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.FieldRevision;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Expression;
import org.hibernate.criterion.Restrictions;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class MetadataManagerDAOImpl
implements MetadataManagerDAO {
    private static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    private HibernateTemplate template;
    private PlatformTransactionManager platformTxMgr;
    private String tablePrefix;
    private AssetSearchService assetSearchService;

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public PlatformTransactionManager getPlatformTxMgr() {
        return this.platformTxMgr;
    }

    public void setPlatformTxMgr(PlatformTransactionManager platformTxMgr) {
        this.platformTxMgr = platformTxMgr;
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    @Override
    @Transactional
    public TTVId saveAsset(Asset asset) throws MetadataException {
        logger.debug((Object)"Start of saveAsset()");
        try {
            if (asset.getState() == AssetState.INACTIVE) {
                throw new MetadataException("Cannot add inactive assets to the store.");
            }
            asset = AssetUtil.deleteEmptyFields(asset);
            this.getTemplate().saveOrUpdate((Object)asset);
            this.getTemplate().flush();
            return asset.getTTVId();
        }
        catch (DataAccessException e) {
            throw new MetadataException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void delete(Asset a) throws SearchException {
        if (a.getRoot() == null) {
            this.inactivateAllChildren(a);
            this.getTemplate().update((Object)a);
        } else {
            this.deleteChildren(a);
            Asset root = a.getRoot();
            Asset parent = root.getAssetsParent(a);
            Relation toBeDeletedRelation = null;
            for (Relation r : parent.getRelations()) {
                if (r.getTargetAsset().getId() != a.getId()) continue;
                toBeDeletedRelation = r;
            }
            parent.getRelations().remove(toBeDeletedRelation);
            this.getTemplate().update((Object)root);
            this.getTemplate().delete((Object)a);
        }
    }

    private void deleteChildren(Asset asset) {
        ArrayList<Relation> relations = new ArrayList<Relation>();
        for (Relation relation : asset.getRelations()) {
            Asset target = relation.getTargetAsset();
            this.deleteChildren(target);
            this.getTemplate().delete((Object)target);
            relations.add(relation);
        }
        asset.getRelations().removeAll(relations);
    }

    private void inactivateAllChildren(Asset a) {
        a.setState(AssetState.INACTIVE);
        for (Relation relation : a.getRelations()) {
            Asset targetAsset = relation.getTargetAsset();
            targetAsset.setState(AssetState.INACTIVE);
            this.inactivateAllChildren(targetAsset);
        }
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id, int revisionNumber, boolean isForReadOnly, boolean filterRevisions) throws SearchException, InvalidRevisionException {
        logger.debug((Object)("Start of getAsset(" + id.getId() + "," + revisionNumber + ")"));
        Session session = this.getCurrentSession();
        Asset asset = (Asset)this.getTemplate().get(Asset.class, (Serializable)Long.valueOf(id.getId()));
        if (asset == null || asset.getState() == AssetState.INACTIVE) {
            throw new SearchException("Could not get asset with id: " + id.getId());
        }
        if (revisionNumber != 0) {
            if (!this.isValidRevisionNumber(asset, revisionNumber)) {
                throw new InvalidRevisionException("Revision Number does not exist");
            }
        } else {
            revisionNumber = Integer.MAX_VALUE;
        }
        if (filterRevisions) {
            session.enableFilter("relationRevisionFilter").setParameter("revisionParam", (Object)revisionNumber);
        }
        asset.getRelations();
        Asset returnAsset = null;
        boolean needToGetFieldRevision = this.needToGetFieldRevision(revisionNumber, asset.getLatestRevisionNumber(), isForReadOnly);
        asset = this.traversAssetTree(asset, needToGetFieldRevision);
        AssetUtil.evictAssetTree(asset, this.getCurrentSession());
        returnAsset = needToGetFieldRevision ? this.getAssetTree(asset, revisionNumber, isForReadOnly, false) : asset;
        logger.debug((Object)("END of getAsset(" + id.getId() + ")"));
        return returnAsset;
    }

    private boolean needToGetFieldRevision(int desiiredVersionNumber, int assetLatestVersionNumber, boolean isForReadOnly) {
        boolean isGettingLatest = desiiredVersionNumber >= assetLatestVersionNumber;
        return !isGettingLatest || !isForReadOnly;
    }

    private boolean isValidRevisionNumber(Asset asset, int revisionNumber) {
        boolean isValid = false;
        if (asset instanceof Group) {
            for (RootAssetRevision rootAssetRevision : ((Group)asset).getRevisions()) {
                if (rootAssetRevision.getRevisionNumber() != revisionNumber) continue;
                isValid = true;
                break;
            }
        } else {
            isValid = true;
        }
        return isValid;
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id, boolean isForReadOnly, boolean filterRevisions) throws SearchException {
        try {
            return this.getAsset(id, 0, isForReadOnly, filterRevisions);
        }
        catch (InvalidRevisionException e) {
            logger.error((Object)("Unable to get latest Asset with TTVid: " + id), (Throwable)e);
            throw new SearchException("Invalid Revision");
        }
    }

    @Override
    @Transactional
    public Relation getRelation(Asset owner, Asset target) throws SearchException {
        DetachedCriteria criteria = DetachedCriteria.forClass(Relation.class);
        criteria.add((Criterion)Restrictions.eq((String)"targetAsset.id", (Object)target.getTTVId().getId()));
        criteria.add((Criterion)Restrictions.eq((String)"ownerAsset.id", (Object)owner.getTTVId().getId()));
        List relations = this.getTemplate().findByCriteria(criteria);
        if (relations.size() > 1) {
            throw new SearchException("Multiple relations found between owner: " + owner.getTTVId().getId() + " and target: " + target.getTTVId().getId());
        }
        return relations.size() == 1 ? (Relation)relations.get(0) : null;
    }

    public AssetSearchService getAssetSearchService() {
        return this.assetSearchService;
    }

    public void setAssetSearchService(AssetSearchService assetSearchService) {
        this.assetSearchService = assetSearchService;
    }

    @Override
    @Transactional
    public List<FieldRevision> getUnDeletedFieldRevsions(FieldRevision fieldRevision) {
        DetachedCriteria criteria = DetachedCriteria.forClass(FieldRevision.class).add((Criterion)Expression.eq((String)"parentAsset.id", (Object)fieldRevision.getParentAsset().getId()));
        criteria.add((Criterion)Expression.eq((String)"ttvXPath", (Object)fieldRevision.getTtvXPath()));
        criteria.add((Criterion)Expression.eq((String)"storedIndices", (Object)fieldRevision.getStoredIndices()));
        criteria.add((Criterion)Expression.lt((String)"revisionNumber", (Object)fieldRevision.getRevisionNumber()));
        criteria.add((Criterion)Expression.le((String)"deleteRevision", (Object)0));
        return this.getTemplate().findByCriteria(criteria);
    }

    public Asset getAssetTree(Asset dbAsset, int desiredRevision, boolean isForReadOnly, boolean forceCopyFromFieldRevisions) throws SearchException {
        boolean isGettingLatest;
        Asset asset = dbAsset;
        boolean bl = isGettingLatest = desiredRevision >= asset.getLatestRevisionNumber();
        if (asset instanceof Group && !isGettingLatest) {
            ArrayList<RootAssetRevision> toBeDeletedRevisions = new ArrayList<RootAssetRevision>();
            for (RootAssetRevision rootAssetRevision : ((Group)asset).getRevisions()) {
                if (rootAssetRevision.getRevisionNumber() <= desiredRevision) break;
                toBeDeletedRevisions.add(rootAssetRevision);
            }
            ((Group)asset).getRevisions().removeAll(toBeDeletedRevisions);
        }
        if (!isForReadOnly || !isGettingLatest || forceCopyFromFieldRevisions) {
            this.getRightVersionOfFieldRevisions(asset, desiredRevision);
            if (isForReadOnly) {
                this.copyFromRevisionsToFields(asset, desiredRevision, forceCopyFromFieldRevisions);
            }
        }
        for (Relation targetRelation : asset.getRelations()) {
            Asset ta = targetRelation.getTargetAsset();
            boolean forceCopy = false;
            if (targetRelation.getDeleteRevision() != 0) {
                forceCopy = true;
            }
            targetRelation.setTargetAsset(this.getAssetTree(ta, desiredRevision, isForReadOnly, forceCopy));
        }
        return asset;
    }

    private void getRightVersionOfFieldRevisions(Asset asset, int desiredRevision) {
        HashMap<String, FieldRevision> rightVersionOfFieldRevisions = new HashMap<String, FieldRevision>();
        ArrayList<FieldRevision> invalidVersionOfFieldRevisions = new ArrayList<FieldRevision>();
        if (asset.getFieldRevisions() != null) {
            for (FieldRevision fieldRevision : asset.getFieldRevisions()) {
                int deleteRevisionNumber = fieldRevision.getDeleteRevision();
                int revisionNumber = fieldRevision.getRevisionNumber();
                String mapKey = fieldRevision.getTtvXPath() + fieldRevision.getIndices();
                FieldRevision fieldRevisionMapEntry = (FieldRevision)rightVersionOfFieldRevisions.get(mapKey);
                if (fieldRevision.getAddRevision() <= desiredRevision && (deleteRevisionNumber > desiredRevision || deleteRevisionNumber == 0) && revisionNumber <= desiredRevision) {
                    if (fieldRevisionMapEntry == null) {
                        rightVersionOfFieldRevisions.put(mapKey, fieldRevision);
                        continue;
                    }
                    if (fieldRevisionMapEntry.getRevisionNumber() < revisionNumber) {
                        invalidVersionOfFieldRevisions.add(fieldRevisionMapEntry);
                        rightVersionOfFieldRevisions.put(mapKey, fieldRevision);
                        continue;
                    }
                    invalidVersionOfFieldRevisions.add(fieldRevision);
                    continue;
                }
                invalidVersionOfFieldRevisions.add(fieldRevision);
            }
            asset.getFieldRevisions().removeAll(invalidVersionOfFieldRevisions);
        }
        asset.setFieldRevisionsMap(rightVersionOfFieldRevisions);
    }

    protected void copyFromRevisionsToFields(Asset asset, int revisionNumber, boolean forceCopy) {
        if (revisionNumber < asset.getLatestRevisionNumber() || forceCopy) {
            List<Field> assetFields = asset.getFields();
            assetFields.removeAll(assetFields);
            for (FieldRevision fieldRevision : asset.getFieldRevisions()) {
                assetFields.add(new Field(fieldRevision));
            }
        }
    }

    protected Asset traversAssetTree(Asset asset, boolean getFieldRevisions) {
        if (getFieldRevisions && asset.getFieldRevisions() != null) {
            asset.getFieldRevisions().size();
        }
        asset = new AssetUtil().unWrap(asset);
        Hibernate.initialize(asset.getAllDescendantAssetFields());
        for (Relation targetRelation : asset.getRelations()) {
            Asset ta = targetRelation.getTargetAsset();
            ta = new AssetUtil().unWrap(ta);
            targetRelation.setTargetAsset(ta);
            this.traversAssetTree(ta, getFieldRevisions);
        }
        return asset;
    }

    @Override
    public Session getCurrentSession() {
        return (Session)this.getTemplate().executeWithNativeSession(new HibernateCallback(){

            public Session doInHibernate(Session session) {
                return session;
            }
        });
    }
}

