/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.model;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.NextRevision;

public abstract class Relation {
    private long id;
    private Asset ownerAsset;
    private Asset targetAsset;
    private int direction;
    private int addRevision = 1;
    private int deleteRevision = 0;

    public Relation() {
    }

    public Relation(Asset ownerAsset, Asset targetAsset) {
        this.ownerAsset = ownerAsset;
        this.targetAsset = targetAsset;
    }

    public Relation(Asset ownerAsset, Asset targetAsset, NextRevision nextRevision) {
        this.ownerAsset = ownerAsset;
        this.targetAsset = targetAsset;
        this.addRevision = nextRevision.getRevisionNumber();
    }

    public abstract boolean isValid();

    public void setId(long id) {
        this.id = id;
    }

    public long getId() {
        return this.id;
    }

    public void setOwnerAsset(Asset ownerAsset) {
        this.ownerAsset = ownerAsset;
    }

    public Asset getOwnerAsset() {
        return this.ownerAsset;
    }

    public Asset getTargetAsset() {
        return this.targetAsset;
    }

    public void setTargetAsset(Asset targetAsset) {
        this.targetAsset = targetAsset;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        this.direction = direction;
    }

    public int getAddRevision() {
        return this.addRevision;
    }

    public void setAddRevision(int addRevision) {
        this.addRevision = addRevision;
    }

    public int getDeleteRevision() {
        return this.deleteRevision;
    }

    public void setDeleteRevision(int deleteRevision) {
        this.deleteRevision = deleteRevision;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ownerAsset == null ? 0 : this.ownerAsset.hashCode());
        result = 31 * result + (this.targetAsset == null ? 0 : this.targetAsset.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Relation)) {
            return false;
        }
        Relation other = (Relation)obj;
        if (this.ownerAsset == null ? other.ownerAsset != null : !this.ownerAsset.equals(other.ownerAsset)) {
            return false;
        }
        return !(this.targetAsset == null ? other.targetAsset != null : !this.targetAsset.equals(other.targetAsset));
    }

    public String toString() {
        String tmp = "[" + this.id + "] (";
        if (this.ownerAsset != null) {
            tmp = tmp + this.ownerAsset.getId();
        }
        if (this.targetAsset != null) {
            tmp = tmp + " " + this.targetAsset.getId();
        }
        tmp = tmp + ")";
        return tmp;
    }
}

