/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.util.DateParseException;
import com.tandbergtv.metadatamanager.util.DateUtil;
import com.tandbergtv.watchpoint.search.Entity;
import com.tandbergtv.watchpoint.search.NestedQueryEntity;
import com.tandbergtv.workflow.driver.search.RangeParameter;
import com.tandbergtv.workflow.driver.search.SearchOperator;
import com.tandbergtv.workflow.driver.search.SearchParameterBase;
import com.tandbergtv.workflow.driver.search.SearchType;
import com.tandbergtv.workflow.driver.search.ValueParameter;
import java.util.Date;
import java.util.GregorianCalendar;
import org.w3c.util.DateParser;
import org.w3c.util.InvalidDateException;

public class MetadataValueFieldInfo
extends FieldInfo {
    SearchOperator operator;
    String value;

    public MetadataValueFieldInfo(String ttvxpath, SearchOperator operator, String value) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.value = value;
        this.isConjunction = true;
    }

    public MetadataValueFieldInfo(String ttvxpath, SearchOperator operator, String value, boolean isConjunction) {
        this.ttvxpath = ttvxpath;
        this.operator = operator;
        this.value = value;
        this.isConjunction = isConjunction;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public SearchOperator getOperator() {
        return this.operator;
    }

    public void setOperator(SearchOperator operator) {
        this.operator = operator;
    }

    @Override
    public void createEntity(String property, Entity assetEntity) {
        if (this.operator.equals((Object)SearchOperator.ISEMPTY)) {
            Entity internalAssetEntity = new Entity("rootAsset", Asset.class, "internalAsset");
            internalAssetEntity.addParameter((SearchParameterBase)new ValueParameter(AssetSearchKey.ASSET_STATE.toString(), SearchType.NUMERIC, (Object)AssetState.ACTIVE.ordinal()));
            Entity internalField = new Entity("field", property, "internalField");
            internalField.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.ISNOTEMPTY));
            ValueParameter assetTypeParam = this.addAssetTypeCriteria();
            if (assetTypeParam != null) {
                internalField.addParameter((SearchParameterBase)assetTypeParam);
            }
            internalAssetEntity.addParameter((SearchParameterBase)internalField);
            NestedQueryEntity n = new NestedQueryEntity("rootAsset", Asset.class, assetEntity.getAlias());
            n.setOperator(SearchOperator.NOTIN);
            n.addParameter((SearchParameterBase)internalAssetEntity);
            assetEntity.addParameter((SearchParameterBase)n, this.isConjunction());
        } else {
            Entity field = new Entity("field", property, "f");
            if (this.operator.equals((Object)SearchOperator.ISNOTEMPTY)) {
                field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, this.operator));
            } else if (this.ttvxpath.contains("CustomField[@name")) {
                this.handleCustomFieldValueParameter(field, this.value);
                field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.EQUAL));
            } else {
                String valueColumnName = "";
                SearchType searchType = SearchType.STRING;
                field.addParameter((SearchParameterBase)new ValueParameter("ttvXPath", SearchType.STRING, (Object)this.ttvxpath, SearchOperator.EQUAL));
                valueColumnName = this.getValueColumnName();
                searchType = this.getSearchTypeBasedOnColumn(valueColumnName);
                if (searchType == SearchType.DATE && this.operator.equals((Object)SearchOperator.EQUAL)) {
                    RangeParameter range = this.handleEqualsOnDate(field, valueColumnName);
                    field.addParameter((SearchParameterBase)range);
                } else {
                    if (searchType == SearchType.DATE) {
                        this.value = this.convertDate();
                    }
                    if (this.operator.equals((Object)SearchOperator.CONTAINSUNPARSABLE)) {
                        field.addParameter((SearchParameterBase)new ValueParameter("parsable", SearchType.NUMERIC, (Object)"0", SearchOperator.EQUAL));
                    } else {
                        field.addParameter((SearchParameterBase)new ValueParameter(valueColumnName, searchType, (Object)this.value, this.operator, this.ignoreCase));
                    }
                }
            }
            ValueParameter assetTypeParam = this.addAssetTypeCriteria();
            if (assetTypeParam != null) {
                field.addParameter((SearchParameterBase)assetTypeParam);
            }
            assetEntity.addParameter((SearchParameterBase)field, this.isConjunction());
        }
    }

    private void handleCustomFieldValueParameter(Entity field, String value) {
        boolean isInt = true;
        boolean isFloat = true;
        boolean isDate = false;
        boolean isString = false;
        try {
            Integer.parseInt(value);
            field.addParameter((SearchParameterBase)new ValueParameter("intValue", SearchType.NUMERIC, (Object)value, this.operator));
        }
        catch (NumberFormatException e) {
            isInt = false;
        }
        if (!isInt) {
            try {
                Float.parseFloat(value);
                field.addParameter((SearchParameterBase)new ValueParameter("floatValue", SearchType.NUMERIC, (Object)value, this.operator));
            }
            catch (NumberFormatException e) {
                isFloat = false;
            }
            if (!isFloat) {
                try {
                    DateParser.parse(value);
                    if (this.operator.equals((Object)SearchOperator.EQUAL)) {
                        RangeParameter range = this.handleEqualsOnDate(field, "dateValue");
                        field.addParameter((SearchParameterBase)range);
                    } else {
                        field.addParameter((SearchParameterBase)new ValueParameter("dateValue", SearchType.DATE, (Object)value, this.operator));
                    }
                }
                catch (NumberFormatException e) {
                    isDate = false;
                }
                catch (InvalidDateException e) {
                    isDate = false;
                }
                if (!isDate) {
                    field.addParameter((SearchParameterBase)new ValueParameter("value", SearchType.STRING, (Object)value, this.operator, this.ignoreCase));
                    isString = true;
                }
            }
        }
        if (!isString) {
            field.addParameter((SearchParameterBase)new ValueParameter("value", SearchType.STRING, (Object)value, this.operator, this.ignoreCase), false);
        }
    }

    private RangeParameter handleEqualsOnDate(Entity field, String valueColumnName) {
        String buffer = this.convertDate();
        RangeParameter range = new RangeParameter(valueColumnName, SearchType.DATE, buffer);
        range.setTo(buffer);
        return range;
    }

    private String convertDate() {
        Date d = null;
        try {
            d = DateUtil.convertDate(this.value);
        }
        catch (DateParseException e) {
            return "";
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(d);
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(this.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(this.twoDigit(calendar.get(5)));
        return buffer.toString();
    }

    private String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }
}

