/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.specimpl.ttv;

import com.tandbergtv.metadatamanager.AssetCopyException;
import com.tandbergtv.metadatamanager.ITTVDataModelHandler;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.factoryImpl.IdentifierFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.Field;
import com.tandbergtv.metadatamanager.model.Group;
import com.tandbergtv.metadatamanager.model.Relation;
import com.tandbergtv.metadatamanager.model.RootAssetRevision;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.model.compare.IAssetCompareReport;
import com.tandbergtv.metadatamanager.spec.IIdentifier;
import com.tandbergtv.metadatamanager.specimpl.IdentifierBase;
import com.tandbergtv.metadatamanager.specimpl.SpecHandlerBase;
import com.tandbergtv.metadatamanager.specimpl.ttv.AssetComparator;
import com.tandbergtv.metadatamanager.specimpl.ttv.AssetCopier;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.annotation.Transactional;

public class TTVSpecHandler
extends SpecHandlerBase
implements ITTVDataModelHandler {
    private static final String TTV_ROOTELEMENT_NAME = "tns:TTVSpec";

    public TTVSpecHandler() {
        this.alias = "TTV";
        this.rootElementName = TTV_ROOTELEMENT_NAME;
    }

    @Override
    public IIdentifier extractId(Asset asset) {
        return asset.getTTVId();
    }

    @Override
    public SearchCriteria prepareSearchPathById(List<Field> fields) {
        return null;
    }

    @Override
    public IdentifierBase getIdentifier() {
        TTVId id = new TTVId();
        id.setSearchService(this.searchService);
        return id;
    }

    @Override
    protected Map<String, String> translate(List<String> fields) {
        HashMap<String, String> fieldsXPath = new HashMap<String, String>();
        for (String field : fields) {
            fieldsXPath.put(field, field);
        }
        return fieldsXPath;
    }

    @Override
    public TTVId getTTVId(Asset asset, Asset rootAsset) throws SearchException {
        TTVId ttvId = asset.getTTVId();
        return ttvId.getId() <= 0L ? null : ttvId;
    }

    @Override
    public Asset getAsset(Long assetId) throws SearchException {
        TTVId ttvId = IdentifierFactory.getTTVIdentifier(assetId);
        return this.getMetadataManagerDAO().getAsset(ttvId, false, true);
    }

    @Override
    public boolean isXPathPartOfSpec(String assetType, String ttvXPath) {
        return true;
    }

    @Override
    @Transactional
    public void delete(Asset asset) throws SearchException {
        this.metadataManagerDAO.delete(asset);
    }

    @Override
    @Transactional(readOnly=true)
    public Asset getAsset(TTVId id) throws SearchException {
        return this.getAsset(id, null);
    }

    @Override
    @Transactional(readOnly=true)
    public Asset getAssetWithDeletedRelationships(TTVId id) throws SearchException {
        return this.getAssetTree(id, null, true, false);
    }

    @Override
    @Transactional
    public Asset saveAsset(Asset asset, boolean saveAsDraft) throws MetadataException {
        return this.saveAsset(asset, null, null, null, saveAsDraft);
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id, String revision) throws SearchException {
        return this.getAssetTree(id, revision, true, true);
    }

    @Override
    @Transactional
    public List<RootAssetRevision> getRevisions(TTVId id) throws SearchException {
        Asset topLevelAsset = this.metadataManagerDAO.getAsset(id, true, true);
        if (!(topLevelAsset instanceof Group)) {
            throw new SearchException("Asset with TTVID[" + id + "] is not a top level asset, thus no revision history.");
        }
        return ((Group)topLevelAsset).getRevisions();
    }

    @Override
    @Transactional
    public void batchMerge(Asset updates, Asset asset) {
        Relation relation;
        Asset target;
        for (Field fieldUpdate : updates.getFields()) {
            boolean highCardinality = false;
            boolean nullify = fieldUpdate.isNullify();
            String xpath = fieldUpdate.getTtvXPath();
            if (nullify) {
                Iterator<Field> fieldIterator = asset.getFields().iterator();
                while (fieldIterator.hasNext()) {
                    Field assetField = fieldIterator.next();
                    if (!assetField.getTtvXPath().equals(xpath)) continue;
                    fieldIterator.remove();
                }
                continue;
            }
            Field assetField = asset.getFirstField(xpath);
            if (assetField == null || highCardinality) {
                int indexCount = xpath.replaceAll("[^/]", "").length();
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < indexCount; ++i) {
                    indices.add(1);
                }
                Field f = new Field(xpath, fieldUpdate.getValue());
                f.setIndices(indices);
                asset.addField(f);
                continue;
            }
            assetField.setTypedValue(fieldUpdate.getTypedValue());
        }
        if (updates.getAssetType().equals("PACKAGE") && (target = (relation = updates.getRelations().get(0)).getTargetAsset()).getAssetType().equals("TITLE")) {
            Asset title = null;
            for (Relation assetRelation : asset.getRelations()) {
                Asset targetAsset = assetRelation.getTargetAsset();
                if (!targetAsset.getAssetType().equals("TITLE")) continue;
                title = targetAsset;
                break;
            }
            this.batchMerge(target, title);
        }
    }

    @Override
    @Transactional
    public Asset saveAsset(Asset asset, String revisionSource, String revisionComment, String externalRevision, boolean saveAsDraft) throws MetadataException {
        if (!((asset = new AssetUtil().unWrap(asset)) instanceof Group)) {
            throw new MetadataException("Asset:" + asset + ", is not a top level asset, can not be saved.");
        }
        asset.loadCompleteTree();
        AssetUtil.evictAssetTree(asset, this.metadataManagerDAO.getCurrentSession());
        RootAssetRevision rootAssetRevision = null;
        rootAssetRevision = new RootAssetRevision(revisionSource, revisionComment, externalRevision);
        ArrayList<Asset> toBeMergedAssets = new ArrayList<Asset>();
        toBeMergedAssets.add(asset);
        List<Asset> mergedAssets = this.mergeSaveAssets(toBeMergedAssets, true, rootAssetRevision, false, saveAsDraft);
        if (mergedAssets != null && mergedAssets.size() > 0) {
            TTVId tid = mergedAssets.get(0).getTTVId();
            try {
                return this.getAsset(tid);
            }
            catch (SearchException e) {
                throw new MetadataException(e.getMessage());
            }
        }
        return null;
    }

    @Override
    protected boolean isAssetTypePartOfSpec(String assetType) {
        return true;
    }

    @Override
    protected Asset searchNewTargetAsset(String oldTargetAssetType, Asset newAsset, Asset oldTargetAsset) {
        return newAsset.getAsset(oldTargetAsset.getTTVId().getId());
    }

    @Override
    protected Asset searchTargetAssetInMemory(Asset newTargetAsset, Asset rootAsset, Asset oldAsset) {
        if (newTargetAsset.getTTVId() == null || newTargetAsset.getTTVId().getId() <= 0L) {
            return null;
        }
        return oldAsset.getAsset(newTargetAsset.getTTVId().getId());
    }

    @Override
    @Transactional
    public Asset copyAsset(long assetId, boolean referenceOriginal) throws AssetCopyException {
        try {
            Asset asset = this.getAsset(assetId);
            return this.copyAsset(asset, referenceOriginal);
        }
        catch (SearchException se) {
            String msg = "Failed to find asset[" + assetId + "] to copy, error: " + se.getLocalizedMessage();
            throw new AssetCopyException(msg, se);
        }
    }

    @Override
    public Asset copyAsset(Asset asset, boolean referenceOriginal) throws AssetCopyException {
        AssetCopier copier = new AssetCopier();
        return copier.copyAssetTree(asset, referenceOriginal);
    }

    @Override
    @Transactional
    public Asset overwriteAssetCopy(long copiedAssetId) throws AssetCopyException {
        Asset copy = null;
        try {
            copy = this.getAsset(copiedAssetId);
        }
        catch (SearchException se) {
            String msg = "Failed to find copied asset[" + copiedAssetId + "], error: " + se.getLocalizedMessage();
            throw new AssetCopyException(msg, se);
        }
        Long originalAssetID = copy.getOriginalAssetID();
        if (originalAssetID == null) {
            String msg = "Cannot overwrite asset copy[" + copiedAssetId + "] since the asset is not a copy.";
            throw new AssetCopyException(msg);
        }
        Asset original = null;
        try {
            original = this.getAsset(originalAssetID);
        }
        catch (SearchException se) {
            String msg = "Failed to find asset[" + originalAssetID + "] to copy, error: " + se.getLocalizedMessage();
            throw new AssetCopyException(msg, se);
        }
        AssetCopier copier = new AssetCopier();
        copier.overwriteAssetTreeCopy(original, copy);
        return copy;
    }

    @Override
    @Transactional
    public Collection<Asset> getAssetCopies(long assetId) throws SearchException {
        Collection<TTVId> copiedAssetIDs = this.getAssetCopyIds(assetId);
        ArrayList<Asset> copiedAssets = new ArrayList<Asset>();
        if (copiedAssetIDs != null) {
            for (TTVId copiedAssetID : copiedAssetIDs) {
                copiedAssets.add(this.getAsset(copiedAssetID));
            }
        }
        return copiedAssets;
    }

    @Override
    @Transactional
    public Collection<TTVId> getAssetCopyIds(long assetId) {
        TTVId ttvId = IdentifierFactory.getTTVIdentifier(assetId);
        return this.getMetadataManagerDAO().getAssetCopyIds(ttvId);
    }

    @Override
    @Transactional
    public Asset getOriginalAsset(long copiedAssetId) throws SearchException {
        TTVId ttvId = this.getOriginalAssetId(copiedAssetId);
        return ttvId != null ? this.getAsset(ttvId) : null;
    }

    @Override
    @Transactional
    public TTVId getOriginalAssetId(long copiedAssetId) {
        TTVId ttvId = IdentifierFactory.getTTVIdentifier(copiedAssetId);
        return this.getMetadataManagerDAO().getOriginalAssetId(ttvId);
    }

    @Override
    public IAssetCompareReport compareAssets(Asset asset1, Asset asset2) {
        AssetComparator comparator = new AssetComparator();
        return comparator.compare(asset1, asset2);
    }

    @Override
    @Transactional
    public IAssetCompareReport compareAssetWithRevision(long assetId, String revision) throws SearchException {
        TTVId ttvId = IdentifierFactory.getTTVIdentifier(assetId);
        Asset currentAsset = this.getAsset(ttvId);
        Asset revisionedAsset = this.getAsset(ttvId, revision);
        return this.compareAssets(currentAsset, revisionedAsset);
    }

    @Override
    @Transactional
    public IAssetCompareReport compareAssetRevisions(long assetId, String revision1, String revision2) throws SearchException {
        TTVId ttvId = IdentifierFactory.getTTVIdentifier(assetId);
        Asset revisionedAsset1 = this.getAsset(ttvId, revision1);
        Asset revisionedAsset2 = this.getAsset(ttvId, revision2);
        return this.compareAssets(revisionedAsset1, revisionedAsset2);
    }

    @Override
    @Transactional
    public IAssetCompareReport compareAssetWithCopy(long copiedAssetId) throws SearchException {
        Asset copy = this.getAssetCopyForComparison(copiedAssetId);
        Asset original = this.getOriginalAsset(copiedAssetId);
        return this.compareAssets(original, copy);
    }

    @Override
    public boolean areAssetsDifferent(Asset asset1, Asset asset2) {
        AssetComparator comparator = new AssetComparator();
        return comparator.isDifferent(asset1, asset2);
    }

    @Override
    @Transactional
    public boolean isAssetDifferentFromRevision(long assetId, String revision) throws SearchException {
        TTVId ttvId = IdentifierFactory.getTTVIdentifier(assetId);
        Asset currentAsset = this.getAsset(ttvId);
        Asset revisionedAsset = this.getAsset(ttvId, revision);
        return this.areAssetsDifferent(currentAsset, revisionedAsset);
    }

    @Override
    @Transactional
    public boolean areAssetRevisionsDifferent(long assetId, String revision1, String revision2) throws SearchException {
        TTVId ttvId = IdentifierFactory.getTTVIdentifier(assetId);
        Asset revisionedAsset1 = this.getAsset(ttvId, revision1);
        Asset revisionedAsset2 = this.getAsset(ttvId, revision2);
        return this.areAssetsDifferent(revisionedAsset1, revisionedAsset2);
    }

    @Override
    @Transactional
    public boolean isAssetCopyDifferent(long copiedAssetId) throws SearchException {
        Asset copy = this.getAssetCopyForComparison(copiedAssetId);
        Asset original = this.getOriginalAsset(copiedAssetId);
        return this.areAssetsDifferent(original, copy);
    }

    private Asset getAssetCopyForComparison(long assetId) throws SearchException {
        Asset asset = this.getAsset(assetId);
        if (!asset.isCopy()) {
            String msg = "The asset[" + assetId + "] is not a copy and cannot be compared to the original asset.";
            throw new SearchException(msg);
        }
        return asset;
    }
}

