/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import com.tandbergtv.metadatamanager.util.MappingFileParser;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class DataTypeMappingReader {
    private static final String PARAMETER_ID = "dataTypeMappingFile";
    private static final String EXTENSION_ID = "customFieldDataTypeMapping";
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static DataTypeMappingReader instance = null;
    Map<String, String> dataTypeXpathMap;
    private static final Logger logger = Logger.getLogger(DataTypeMappingReader.class);

    protected DataTypeMappingReader(String dataTypeMappingFile, PluginManager pm) {
        this.dataTypeXpathMap = MappingFileParser.readFieldMapping(dataTypeMappingFile);
        if (pm != null) {
            try {
                PluginRegistry pluginRegistry = pm.getRegistry();
                ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, EXTENSION_ID);
                Collection extensions = point.getAvailableExtensions();
                if (!extensions.isEmpty()) {
                    Extension extension = (Extension)extensions.iterator().next();
                    Extension.Parameter param = extension.getParameter(PARAMETER_ID);
                    PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
                    PluginClassLoader classLoader = pm.getPluginClassLoader(descriptor);
                    InputStream is = classLoader.getResourceAsStream(param.valueAsString());
                    Map<String, String> map = MappingFileParser.readFieldMapping(is);
                    this.dataTypeXpathMap.putAll(map);
                }
            }
            catch (Exception e) {
                logger.warn((Object)"You do not have a cfDataTypeMapping.dat in your com.tandbergtv.metadata plugin.", (Throwable)e);
            }
        }
    }

    public static DataTypeMappingReader getInstance() {
        return DataTypeMappingReader.getInstance(null, null);
    }

    public static DataTypeMappingReader getInstance(PluginManager pm) {
        return DataTypeMappingReader.getInstance(null, pm);
    }

    public static synchronized DataTypeMappingReader getInstance(String dataTypeMappingFile, PluginManager pm) {
        if (instance == null) {
            if (dataTypeMappingFile == null) {
                dataTypeMappingFile = "DatatypeMapping.dat";
            }
            instance = new DataTypeMappingReader(dataTypeMappingFile, pm);
        }
        return instance;
    }

    public Map<String, String> getDataTypeXpathMap() {
        return this.dataTypeXpathMap;
    }

    public String determineDataType(String ttvXPath) {
        String type = null;
        if (this.dataTypeXpathMap.containsKey(ttvXPath)) {
            type = this.dataTypeXpathMap.get(ttvXPath);
        }
        return type;
    }

    public boolean hasChildren(String ttvXPath) {
        String prefix = ttvXPath + "/";
        for (String key : this.dataTypeXpathMap.keySet()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

