/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.SearchCriteria;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.FieldSearchKey;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.MetadataValueFieldInfo;
import com.tandbergtv.metadatamanager.search.PropertyValueField;
import com.tandbergtv.metadatamanager.search.SearchField;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SearchFieldBuilder {
    public List<SearchField> getAssetSearchFields(SearchCriteria criteria, boolean queryRoot, Long rootAssetId, boolean queryOriginal, boolean onlyOriginal) {
        SearchField field;
        LogicalOperator operator;
        ArrayList<String> values;
        ArrayList<SearchField> assetSearchFields = new ArrayList<SearchField>();
        if (queryOriginal) {
            values = new ArrayList<String>();
            values.add(null);
            String columnName = DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ORIGINAL_ASSET_ID.toString());
            operator = onlyOriginal ? LogicalOperator.ISNULL : LogicalOperator.ISNOTNULL;
            field = new PropertyValueField(columnName, values, operator, Asset.class);
            field.setConjunction(true);
            assetSearchFields.add(field);
        }
        if (queryRoot) {
            values = new ArrayList();
            String idVal = rootAssetId == null ? null : String.valueOf(rootAssetId);
            operator = rootAssetId == null ? LogicalOperator.ISNULL : LogicalOperator.EQUAL;
            values.add(idVal);
            String columnName = DBNameFinder.getInstance().getColumnName(Asset.class, AssetSearchKey.ASSET_ROOT.toString());
            PropertyValueField field2 = new PropertyValueField(columnName, values, operator, Asset.class);
            field2.setConjunction(true);
            assetSearchFields.add(field2);
        }
        for (Map.Entry entry : criteria.entrySet()) {
            ArrayList<String> values2 = new ArrayList<String>();
            values2.add((String)entry.getValue());
            if (((String)entry.getKey()).contains(FieldSearchKey.FIELD_XPATH_PATTERN.toString())) {
                field = new MetadataValueFieldInfo((String)entry.getKey(), LogicalOperator.EQUAL, (String)entry.getValue(), true);
                assetSearchFields.add(field);
                continue;
            }
            field = new PropertyValueField((String)entry.getKey(), values2, LogicalOperator.AND, Asset.class);
            assetSearchFields.add(field);
        }
        return assetSearchFields;
    }
}

