/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.searchimpl.querybuilder;

import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.search.AssetSearchKey;
import com.tandbergtv.metadatamanager.search.FileInfo;
import com.tandbergtv.metadatamanager.search.builder.IQueryBuilder;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.search.builder.QueryOperators;
import com.tandbergtv.metadatamanager.searchimpl.joinbuilder.ImmediateOwnerRelationJoinBuilder;
import com.tandbergtv.metadatamanager.searchimpl.joinbuilder.TargetAssetIdRelationJoinBuilder;
import com.tandbergtv.metadatamanager.searchimpl.joinbuilder.TargetRelationJoinBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.AssetFieldQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.AssetQueryBuilder;
import com.tandbergtv.metadatamanager.searchimpl.querybuilder.RelationQueryBuilder;
import com.tandbergtv.metadatamanager.util.DBNameFinder;
import java.util.Iterator;

public class FileQueryBuilder
implements IQueryBuilder {
    private static final String MATCHING_FILE_ASSETS_ALIAS = "matchingFileAsset";
    private static final String ROOT_RELATION_ALIAS = "rootRel";
    private static final String FILE_RELATION_ALIAS = "fileRel";
    private static final String SPACEY_JOIN = " JOIN ";
    private static final String SPACEY_AND = " AND ";
    private TargetRelationJoinBuilder trjb = new TargetRelationJoinBuilder();
    private TargetAssetIdRelationJoinBuilder tarjb = new TargetAssetIdRelationJoinBuilder();
    private ImmediateOwnerRelationJoinBuilder orjb = new ImmediateOwnerRelationJoinBuilder();
    private RelationQueryBuilder rqb = new RelationQueryBuilder();
    protected DBNameFinder dbNamefinder = DBNameFinder.getInstance();
    private AssetQueryBuilder aqb = new AssetQueryBuilder();
    private AssetFieldQueryBuilder afqb = new AssetFieldQueryBuilder(false);

    public String getSearchSubQuery(FileInfo field) {
        StringBuffer sb = new StringBuffer();
        if (field.isInvert()) {
            this.invertinator(sb, field);
        } else {
            this.addMainQuery(sb, field);
        }
        return sb.toString();
    }

    private void invertinator(StringBuffer sb, FileInfo field) {
        this.addInvertedSelect(sb);
        this.addInvertedFrom(sb);
        this.addInvertedWhere(sb, field);
    }

    private void addInvertedSelect(StringBuffer sb) {
        sb.append(QueryConstants.SELECT);
        sb.append(QueryConstants.SPACE);
        sb.append(QueryConstants.DISTINCT);
        sb.append(QueryConstants.SPACE);
        sb.append(this.aqb.getAlias());
        sb.append(QueryConstants.PERIOD);
        sb.append(this.dbNamefinder.getColumnName(Asset.class, AssetSearchKey.ASSET_ROOT.toString()));
        sb.append(" as AssetId ");
    }

    private void addInvertedFrom(StringBuffer sb) {
        sb.append(QueryConstants.FROM);
        sb.append(QueryConstants.SPACE);
        sb.append(this.aqb.getPartialFromClause());
        sb.append(SPACEY_JOIN);
        sb.append(this.rqb.getPartialFromClause());
        this.wrapJoinCondition(sb, this.trjb.getJoin(this.rqb.getAlias(), this.aqb.getAlias()));
        sb.append(QueryConstants.SPACE);
    }

    private void addInvertedWhere(StringBuffer sb, FileInfo field) {
        sb.append(QueryConstants.WHERE);
        sb.append(QueryConstants.SPACE);
        sb.append(this.aqb.getAlias());
        sb.append(QueryConstants.PERIOD);
        sb.append(AssetSearchKey.ASSET_ID.toString());
        sb.append(QueryConstants.SPACE);
        sb.append((Object)QueryOperators.NOTIN);
        sb.append(QueryConstants.SPACE);
        sb.append(QueryConstants.START_PARENTHESIS);
        this.addMainQuery(sb, field);
        sb.append(QueryConstants.END_PARENTHESIS);
        sb.append(SPACEY_AND);
        this.addTypeIn(sb, field, this.aqb.getAlias());
        sb.append(SPACEY_AND);
        sb.append(this.aqb.getDefaultConditions(this.aqb.getAlias()));
        sb.append(SPACEY_AND);
        sb.append(this.rqb.getPartialWhereClause());
    }

    private void addMainQuery(StringBuffer sb, FileInfo field) {
        this.buildSelect(sb, field.isInvert());
        this.buildMainFrom(sb, field);
        this.buildMainWhere(sb, field);
    }

    private void buildSelect(StringBuffer sb, boolean invert) {
        sb.append(QueryConstants.SELECT);
        sb.append(QueryConstants.SPACE);
        if (invert) {
            sb.append(this.aqb.getAlias());
            sb.append(QueryConstants.PERIOD);
            sb.append(AssetSearchKey.ASSET_ID.toString());
        } else {
            sb.append(QueryConstants.DISTINCT);
            sb.append(QueryConstants.SPACE);
            sb.append(this.aqb.getAlias());
            sb.append(QueryConstants.PERIOD);
            sb.append(this.dbNamefinder.getColumnName(Asset.class, AssetSearchKey.ASSET_ROOT.toString()));
        }
        sb.append(" as AssetId ");
    }

    private void wrapInParens(StringBuffer sb, String str) {
        sb.append(" (");
        sb.append(str);
        sb.append(") ");
    }

    private void wrapJoinCondition(StringBuffer sb, String joinCondition) {
        sb.append(" ON");
        this.wrapInParens(sb, joinCondition);
    }

    private void buildMainFrom(StringBuffer sb, FileInfo field) {
        sb.append(QueryConstants.FROM);
        sb.append(QueryConstants.SPACE);
        this.wrapInParens(sb, this.afqb.getSearchSubQuery(field, false, true, true));
        sb.append(QueryConstants.SPACE);
        sb.append(MATCHING_FILE_ASSETS_ALIAS);
        sb.append(SPACEY_JOIN);
        sb.append(this.rqb.getPartialFromClause(FILE_RELATION_ALIAS));
        this.wrapJoinCondition(sb, this.tarjb.getJoin(FILE_RELATION_ALIAS, MATCHING_FILE_ASSETS_ALIAS));
        sb.append(SPACEY_JOIN);
        sb.append(this.aqb.getPartialFromClause());
        this.wrapJoinCondition(sb, this.orjb.getJoin(FILE_RELATION_ALIAS, this.aqb.getAlias()));
        sb.append(SPACEY_JOIN);
        sb.append(this.rqb.getPartialFromClause(ROOT_RELATION_ALIAS));
        this.wrapJoinCondition(sb, this.trjb.getJoin(ROOT_RELATION_ALIAS, this.aqb.getAlias()));
        sb.append(QueryConstants.SPACE);
    }

    private void buildMainWhere(StringBuffer sb, FileInfo field) {
        sb.append(QueryConstants.WHERE);
        sb.append(QueryConstants.SPACE);
        sb.append(this.aqb.getDefaultConditions(this.aqb.getAlias()));
        sb.append(SPACEY_AND);
        this.addTypeIn(sb, field, this.aqb.getAlias());
        sb.append(SPACEY_AND);
        sb.append(this.rqb.getPartialWhereClause(FILE_RELATION_ALIAS));
        sb.append(SPACEY_AND);
        sb.append(this.rqb.getPartialWhereClause(ROOT_RELATION_ALIAS));
    }

    private void addTypeIn(StringBuffer sb, FileInfo field, String assetAlias) {
        sb.append(assetAlias);
        sb.append(QueryConstants.PERIOD);
        sb.append(AssetSearchKey.ASSET_TYPE.toString());
        sb.append(QueryConstants.SPACE);
        sb.append((Object)QueryOperators.IN);
        sb.append(QueryConstants.SPACE);
        sb.append(QueryConstants.START_PARENTHESIS);
        Iterator<String> typeIterator = field.getParentAssetTypes().iterator();
        while (typeIterator.hasNext()) {
            sb.append(QueryConstants.QUOTE);
            sb.append(typeIterator.next());
            sb.append(QueryConstants.QUOTE);
            if (!typeIterator.hasNext()) continue;
            sb.append(QueryConstants.COMMA);
        }
        sb.append(QueryConstants.END_PARENTHESIS);
    }

    @Override
    public String getAlias() {
        throw new RuntimeException("You should not get an alias of this query through this method.");
    }
}

