/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.search;

import com.tandbergtv.metadatamanager.search.FieldInfo;
import com.tandbergtv.metadatamanager.search.FieldSearchKey;
import com.tandbergtv.metadatamanager.search.LogicalOperator;
import com.tandbergtv.metadatamanager.search.builder.QueryConstants;
import com.tandbergtv.metadatamanager.util.DateParseException;
import com.tandbergtv.metadatamanager.util.DateUtil;
import com.tandbergtv.workflow.driver.search.SearchType;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;

public class RangeFieldInfo
extends FieldInfo {
    private static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private static final String AND = " AND ";
    private LogicalOperator operator;
    private String rangeStart;
    private String rangeEnd;
    private String valueCol;
    private SearchType searchType;

    public RangeFieldInfo(String ttvxpath, String assetType, String rangeStart, String rangeEnd, LogicalOperator operator, boolean isConjunction) {
        super(ttvxpath, assetType, isConjunction);
        this.operator = operator;
        try {
            this.setRangeStart(rangeStart);
            this.setRangeEnd(rangeEnd);
        }
        catch (DateParseException e) {
            throw new RuntimeException("Invalid date while trying to do a range search.", e);
        }
    }

    @Override
    public void setTtvxpath(String xpath) {
        this.ttvxpath = xpath;
        this.valueCol = this.getValueColumnName();
        this.searchType = this.getSearchTypeBasedOnColumn(this.valueCol);
    }

    @Override
    public String getCondition(String alias) {
        if (!this.operator.equals((Object)LogicalOperator.BETWEEN)) {
            throw new RuntimeException("Operator " + this.operator.toString() + " yet supported");
        }
        StringBuilder condition = new StringBuilder();
        this.addXpathCond(alias, condition);
        condition.append(AND);
        condition.append(alias);
        condition.append(".");
        condition.append(this.valueCol);
        condition.append(QueryConstants.BETWEEN);
        this.addValue(this.rangeStart, condition);
        condition.append(AND);
        this.addValue(this.rangeEnd, condition);
        return condition.toString();
    }

    private void addXpathCond(String alias, StringBuilder condition) {
        condition.append(alias);
        condition.append(".");
        condition.append((Object)FieldSearchKey.TTV_XPATH);
        condition.append(" = '");
        condition.append(this.ttvxpath);
        condition.append("'");
    }

    private void addValue(String value, StringBuilder sb) {
        switch (this.searchType) {
            case DATE: {
                sb.append("to_date('");
                sb.append(value);
                sb.append("',");
                sb.append(QueryConstants.DATE_TIME_FORMAT);
                sb.append(")");
                break;
            }
            case STRING: {
                sb.append("'");
                sb.append(value);
                sb.append("'");
                break;
            }
            case NUMERIC: {
                sb.append(value);
                break;
            }
            default: {
                throw new RuntimeException("unsupported search type.");
            }
        }
    }

    @Override
    public String getSelectProperties() {
        return "";
    }

    public LogicalOperator getOperator() {
        return this.operator;
    }

    public String getRangeStart() {
        return this.rangeStart;
    }

    public void setRangeStart(String rangeStart) throws DateParseException {
        if (this.searchType.equals((Object)SearchType.DATE)) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(DateUtil.convertDate(rangeStart));
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            this.rangeStart = sdf.format(calendar.getTime());
        } else {
            this.rangeStart = rangeStart;
        }
    }

    public String getRangeEnd() {
        return this.rangeEnd;
    }

    public void setRangeEnd(String rangeEnd) throws DateParseException {
        if (this.searchType.equals((Object)SearchType.DATE)) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(DateUtil.convertDate(rangeEnd));
            calendar.set(10, 23);
            calendar.set(12, 59);
            calendar.set(13, 59);
            this.rangeEnd = sdf.format(calendar.getTime());
        } else {
            this.rangeEnd = rangeEnd;
        }
    }
}

