/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.factoryImpl;

import com.tandbergtv.metadatamanager.model.Spec;
import com.tandbergtv.metadatamanager.spec.ISpecHandler;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.Document;

public class SpecHandlerFactory {
    private static Map<String, ISpecHandler> handlers;

    public SpecHandlerFactory(Map<String, ISpecHandler> handlers) {
        SpecHandlerFactory.handlers = handlers;
    }

    public SpecHandlerFactory() {
        handlers = new HashMap<String, ISpecHandler>();
    }

    public static ISpecHandler getInstance(String specification) {
        return handlers.get(specification);
    }

    @Deprecated
    public static ISpecHandler getInstance(Spec specification) {
        return handlers.get(specification.toString());
    }

    public static Map<String, ISpecHandler> getHandlers() {
        return handlers;
    }

    public static void setHandlers(Map<String, ISpecHandler> handlers) {
        SpecHandlerFactory.handlers = handlers;
    }

    public static ISpecHandler getInstance(Document metadataDoc) {
        Iterator<Map.Entry<String, ISpecHandler>> it = handlers.entrySet().iterator();
        while (it.hasNext()) {
            ISpecHandler handler = it.next().getValue();
            String spec = handler.getSpecAlias(metadataDoc);
            if (spec == null) continue;
            return handler;
        }
        return null;
    }
}

