/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager;

import com.tandbergtv.metadatamanager.DocumentDAO;
import com.tandbergtv.metadatamanager.MetadataManagerDAO;
import com.tandbergtv.metadatamanager.exception.InvalidRevisionException;
import com.tandbergtv.metadatamanager.exception.MetadataException;
import com.tandbergtv.metadatamanager.exception.SearchException;
import com.tandbergtv.metadatamanager.factoryImpl.IdentifierFactory;
import com.tandbergtv.metadatamanager.model.Asset;
import com.tandbergtv.metadatamanager.model.AssetState;
import com.tandbergtv.metadatamanager.search.AssetSearchService;
import com.tandbergtv.metadatamanager.specimpl.ttv.TTVId;
import com.tandbergtv.metadatamanager.util.AssetUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

public class MetadataManagerDAOImpl
implements MetadataManagerDAO {
    private static final Logger logger = Logger.getLogger(MetadataManagerDAOImpl.class);
    private HibernateTemplate template;
    private PlatformTransactionManager platformTxMgr;
    private String tablePrefix;
    private AssetSearchService assetSearchService;

    public String getTablePrefix() {
        return this.tablePrefix;
    }

    public void setTablePrefix(String tablePrefix) {
        this.tablePrefix = tablePrefix;
    }

    public PlatformTransactionManager getPlatformTxMgr() {
        return this.platformTxMgr;
    }

    public void setPlatformTxMgr(PlatformTransactionManager platformTxMgr) {
        this.platformTxMgr = platformTxMgr;
    }

    public HibernateTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(HibernateTemplate template) {
        this.template = template;
    }

    @Override
    @Transactional
    public TTVId saveAsset(Asset asset) throws MetadataException {
        logger.debug((Object)"Start of saveAsset()");
        try {
            if (asset.getState() == AssetState.INACTIVE) {
                throw new MetadataException("Cannot add inactive assets to the store.");
            }
            asset = AssetUtil.deleteEmptyFields(asset);
            DocumentDAO dao = new DocumentDAO(this.getTemplate());
            dao.saveAsset(asset);
            this.getTemplate().flush();
            return asset.getTTVId();
        }
        catch (DataAccessException e) {
            throw new MetadataException(e.getMessage(), e);
        }
    }

    @Override
    @Transactional
    public void delete(Asset a) throws SearchException {
        try {
            a = this.getAssetFromCurrentSession(new TTVId(a.getId()), 0, false, true);
            if (a.getRoot() != null) {
                String msg = "Non-root asset cannot be deleted from database";
                logger.debug((Object)msg);
                throw new SearchException(msg);
            }
            DocumentDAO dao = new DocumentDAO(this.getTemplate());
            dao.deleteAsset(a);
            this.getTemplate().flush();
        }
        catch (Exception e) {
            throw new SearchException(e.getMessage());
        }
    }

    @Override
    @Transactional
    public Asset getAssetFromCurrentSession(TTVId id, int revisionNumber, boolean isForReadOnly, boolean filterRevisions) throws SearchException, InvalidRevisionException {
        return this.getAsset(id, revisionNumber, isForReadOnly, filterRevisions, true, false);
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id, int revisionNumber, boolean isForReadOnly, boolean filterRevisions) throws SearchException, InvalidRevisionException {
        return this.getAsset(id, revisionNumber, isForReadOnly, filterRevisions, false, false);
    }

    @Override
    @Transactional
    public Asset getDeletedAsset(TTVId id, boolean filterRevisions) throws SearchException {
        try {
            return this.getAsset(id, 0, true, filterRevisions, false, true);
        }
        catch (InvalidRevisionException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Transactional
    private Asset getAsset(TTVId id, int revisionNumber, boolean isForReadOnly, boolean filterRevisions, boolean withCurrentSession, boolean deleted) throws SearchException, InvalidRevisionException {
        DocumentDAO dao = new DocumentDAO(this.getTemplate());
        Asset returnAsset = dao.getAsset(id, revisionNumber, withCurrentSession);
        return returnAsset;
    }

    @Override
    @Transactional
    public Asset getAsset(TTVId id, boolean isForReadOnly, boolean filterRevisions) throws SearchException {
        try {
            return this.getAsset(id, 0, isForReadOnly, filterRevisions);
        }
        catch (InvalidRevisionException e) {
            logger.error((Object)("Unable to get latest Asset with TTVid: " + id), (Throwable)e);
            throw new SearchException("Invalid Revision");
        }
    }

    public AssetSearchService getAssetSearchService() {
        return this.assetSearchService;
    }

    public void setAssetSearchService(AssetSearchService assetSearchService) {
        this.assetSearchService = assetSearchService;
    }

    @Override
    @Transactional
    public Collection<TTVId> getAssetCopyIds(TTVId id) {
        logger.info((Object)".........Asset.GetCopyIDs query not supported yet!!!!!!!!!");
        ArrayList results = new ArrayList();
        ArrayList<TTVId> copyIDs = new ArrayList<TTVId>();
        for (Object assetID : results) {
            TTVId ttvId = IdentifierFactory.getTTVIdentifier((Long)assetID);
            copyIDs.add(ttvId);
        }
        return copyIDs;
    }

    @Override
    @Transactional
    public TTVId getOriginalAssetId(TTVId copiedAssetId) {
        logger.info((Object)".........Asset.GetOriginalID query not supported yet!!!!!!");
        ArrayList results = new ArrayList();
        TTVId originalId = null;
        if (results.size() > 0) {
            originalId = IdentifierFactory.getTTVIdentifier((Long)results.get(0));
        }
        return originalId;
    }

    @Override
    public Session getCurrentSession() {
        return (Session)this.getTemplate().executeWithNativeSession(new HibernateCallback(){

            public Session doInHibernate(Session session) {
                return session;
            }
        });
    }
}

