/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.metadatamanager.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.java.plugin.PluginClassLoader;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.registry.ExtensionPoint;
import org.java.plugin.registry.PluginDescriptor;
import org.java.plugin.registry.PluginRegistry;

public class FieldAliasMappingReader {
    private static final String PARAMETER_ID = "fieldAliasMapping";
    private static final String EXTENSION_ID = "fieldAliasMapping";
    private static final String PLUGIN_ID = "com.tandbergtv.metadata";
    private static String MAPPING_DELIMITER = ",";
    private static FieldAliasMappingReader instance = null;
    Map<String, String> aliasMap;
    private static final Logger logger = Logger.getLogger(FieldAliasMappingReader.class);

    public static synchronized FieldAliasMappingReader getInstance(String aliasMappingFile, PluginManager pm) {
        if (instance == null) {
            if (aliasMappingFile == null) {
                aliasMappingFile = "FieldAliasMapping.dat";
            }
            instance = new FieldAliasMappingReader(aliasMappingFile, pm);
        }
        return instance;
    }

    public static FieldAliasMappingReader getInstance(PluginManager pm) {
        return FieldAliasMappingReader.getInstance(null, pm);
    }

    public static FieldAliasMappingReader getInstance() {
        return FieldAliasMappingReader.getInstance(null, null);
    }

    private FieldAliasMappingReader(String aliasMappingFile, PluginManager pm) {
        if (pm != null) {
            try {
                PluginRegistry pluginRegistry = pm.getRegistry();
                ExtensionPoint point = pluginRegistry.getExtensionPoint(PLUGIN_ID, "fieldAliasMapping");
                Collection extensions = point.getAvailableExtensions();
                if (!extensions.isEmpty()) {
                    Extension extension = (Extension)extensions.iterator().next();
                    Extension.Parameter param = extension.getParameter("fieldAliasMapping");
                    PluginDescriptor descriptor = extension.getDeclaringPluginDescriptor();
                    PluginClassLoader classLoader = pm.getPluginClassLoader(descriptor);
                    InputStream is = classLoader.getResourceAsStream(param.valueAsString());
                    this.loadAliasMap(is);
                }
            }
            catch (Exception e) {
                logger.warn((Object)("You do not have " + aliasMappingFile + " file in your com.tandbergtv.metadata plugin."), (Throwable)e);
            }
        }
    }

    private void loadAliasMap(InputStream is) throws RuntimeException {
        this.aliasMap = new HashMap<String, String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.indexOf(MAPPING_DELIMITER) == -1) continue;
                String[] fieldMapping = line.split(MAPPING_DELIMITER);
                this.aliasMap.put(fieldMapping[0].trim(), fieldMapping[1].trim());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, String> getAliasMap() {
        return this.aliasMap;
    }
}

