/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.ldap.ejb;

import com.tandbergtv.neptune.realm.ldap.conf.LdapConfiguration;
import com.tandbergtv.neptune.realm.ldap.ejb.EntityService;
import com.tandbergtv.neptune.realm.ldap.ejb.LdapContextFactory;
import com.tandbergtv.neptune.realm.ldap.service.IEntityService;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.naming.NamingException;
import javax.naming.ldap.LdapContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.ejb3.annotation.Service;

@Service
@PermitAll
public class UserLdapContext
implements IUserLdapContext {
    private static final String LDAP_CONFIG_RESOURCE_PATH = "/META-INF/ldap.cfg.xml";
    protected LdapConfiguration configuration;
    protected LdapContextFactory contextFactory;
    protected IEntityService entityService;

    @Override
    public void create() throws Exception {
        try {
            String packageName = this.getClass().getPackage().getName();
            packageName = String.valueOf(packageName.substring(0, packageName.lastIndexOf("."))) + ".conf";
            JAXBContext jaxbContext = JAXBContext.newInstance((String)packageName);
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            InputStream stream = this.getClass().getResourceAsStream(LDAP_CONFIG_RESOURCE_PATH);
            if (stream == null) {
                throw new RuntimeException("Failed to load LDAP configuration resource from path: /META-INF/ldap.cfg.xml");
            }
            JAXBElement object = (JAXBElement)unmarshaller.unmarshal(stream);
            this.configuration = (LdapConfiguration)object.getValue();
            this.contextFactory = LdapContextFactory.newInstance(this.configuration.getConnection());
            this.entityService = new EntityService(this.configuration.getEntities());
        }
        catch (JAXBException e) {
            throw new RuntimeException("Failed to unmarshall the LDAP configuration from path: /META-INF/ldap.cfg.xml", e);
        }
    }

    @Override
    public LdapContext openContext() throws NamingException {
        return this.contextFactory.newLdapContext();
    }

    @Override
    public LdapContext openContext(Map<String, String> environmentOverride) throws NamingException {
        return this.contextFactory.newLdapContext(environmentOverride);
    }

    @Override
    public IEntityService getEntityService() {
        return this.entityService;
    }

    @Override
    public boolean isExternalUserModelEnabled() {
        return this.configuration != null ? this.configuration.isEnabled() : false;
    }
}

