/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.cms.portal.util.paging.PagingAspect;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.usermgmt.ejb.DigestUtil;
import com.tandbergtv.neptune.usermgmt.service.IUserAvailabilityService;
import com.tandbergtv.neptune.usermgmt.service.internal.IInternalUserManager;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.aspectj.runtime.internal.AroundClosure;

@Local(value={IInternalUserManager.class})
@Stateless
public class LocalUserManager
implements IInternalUserManager {
    private static final Logger logger = Logger.getLogger(LocalUserManager.class);
    @PersistenceContext(unitName="NeptuneRealm")
    protected EntityManager entityManager;

    @RolesAllowed(value={"UserManagement_View"})
    @PageTarget(entityClass="User", entityName="user")
    public List<User> getUsers() {
        List list;
        Object[] objectArray = new Object[]{LocalUserManager.class.getDeclaredMethod("getUsers", new Class[0]).getAnnotation(PageTarget.class)};
        PagingAspect.ajc$cflowStack$0.push(objectArray);
        try {
            String string = "SELECT user FROM User user";
            EntityManager entityManager = this.entityManager;
            Query query = PagingAspect.ajc$cflowStack$0.isValid() ? LocalUserManager.createQuery_aroundBody1$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
            list = query.getResultList();
        }
        finally {
            PagingAspect.ajc$cflowStack$0.pop();
        }
        return list;
    }

    @RolesAllowed(value={"UserManagement_View"})
    public User getUser(UserKey userKey) {
        return this.find(userKey.getId());
    }

    @RolesAllowed(value={"UserManagement_View"})
    public User getUser(String userName) {
        return this.findByUserName(userName);
    }

    @RolesAllowed(value={"UserManagement_View"})
    public List<User> getUsersWithPermission(String moduleName, String permissionName) {
        String string = "SELECT user FROM User user, IN(user.roles) role, IN(role.permissions) permission where permission.name = :permissionName and permission.module.name = :moduleName";
        EntityManager entityManager = this.entityManager;
        Query query = PagingAspect.ajc$cflowStack$0.isValid() ? LocalUserManager.createQuery_aroundBody3$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
        query.setParameter("moduleName", (Object)moduleName);
        query.setParameter("permissionName", (Object)permissionName);
        return query.getResultList();
    }

    @RolesAllowed(value={"UserManagement_Create"})
    public User createUser(User user) {
        this.encryptPassword(user);
        this.entityManager.persist((Object)user);
        return user;
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User updateUser(User user) {
        Query query = this.entityManager.createNamedQuery("User.GetPassword");
        query.setParameter("userId", (Object)user.getId());
        String oldPassword = (String)query.getSingleResult();
        user.setPassword(oldPassword);
        return (User)this.entityManager.merge((Object)user);
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User updateUserWithPassword(User user) {
        this.encryptPassword(user);
        return (User)this.entityManager.merge((Object)user);
    }

    @RolesAllowed(value={"UserManagement_Delete"})
    public boolean deleteUser(UserKey userKey) {
        User user = this.find(userKey.getId());
        if (user != null) {
            boolean isBusy = this.isBusy(user.getUserName());
            if (!isBusy) {
                this.entityManager.remove((Object)user);
                return true;
            }
            throw new RuntimeException("The user is busy, cannot delete the user.");
        }
        return false;
    }

    @RolesAllowed(value={"UserManagement_Delete"})
    public boolean deleteUsers(UserKey ... userKeys) {
        boolean result = true;
        UserKey[] userKeyArray = userKeys;
        int n = userKeys.length;
        int n2 = 0;
        while (n2 < n) {
            UserKey userKey = userKeyArray[n2];
            result &= this.deleteUser(userKey);
            ++n2;
        }
        return result;
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User setActiveStatus(UserKey userKey, boolean active) {
        User user = (User)this.entityManager.find(User.class, (Object)userKey);
        if (user != null) {
            user.setActive(active);
        }
        return user;
    }

    @RolesAllowed(value={"UserManagement_View"})
    public boolean isReadOnly() {
        return false;
    }

    private User find(Long userId) {
        return (User)this.entityManager.find(User.class, (Object)userId);
    }

    private User findByUserName(String userName) {
        User match = null;
        Query query = this.entityManager.createNamedQuery("User.FindByUserName");
        query.setParameter("userName", (Object)userName);
        try {
            match = (User)query.getSingleResult();
        }
        catch (NoResultException nre) {
            match = null;
        }
        return match;
    }

    private void encryptPassword(User user) {
        String encryptedPassword = DigestUtil.Digest(user.getPassword(), "SHA");
        user.setPassword(encryptedPassword);
    }

    private boolean isBusy(String username) {
        ServiceLoader<IUserAvailabilityService> userAvailabilityLoader = ServiceLoader.load(IUserAvailabilityService.class);
        if (userAvailabilityLoader != null) {
            for (IUserAvailabilityService userAvailabilityProvider : userAvailabilityLoader) {
                boolean currentResult = userAvailabilityProvider.isBusy(username);
                logger.debug((Object)(String.valueOf(username) + ", isBusy=" + currentResult));
                if (!currentResult) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Query createQuery_aroundBody1$advice(LocalUserManager this_, EntityManager pageTarget, String entityManager, PagingAspect queryString, PageTarget ajc_aroundClosure, EntityManager entityManager2, String string, AroundClosure aroundClosure) {
        void query;
        void builder;
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)queryString).get() == null) {
            AroundClosure aroundClosure2 = aroundClosure;
            String string2 = string;
            EntityManager entityManager3 = entityManager2;
            PageTarget pageTarget2 = ajc_aroundClosure;
            return entityManager3.createQuery(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" ORDER BY ").append(ajc_aroundClosure.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)queryString).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)queryString).get()).booleanValue()) {
            stringBuilder.append("ASC");
        } else {
            stringBuilder.append("DESC");
        }
        AroundClosure aroundClosure3 = aroundClosure;
        String string3 = stringBuilder.toString();
        void var18_15 = builder;
        PageTarget pageTarget3 = ajc_aroundClosure;
        Query query2 = ((EntityManager)var18_15).createQuery(string3);
        query2.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)queryString).get()).intValue());
        query2.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)queryString).get()).intValue());
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("select count(").append(ajc_aroundClosure.entityName()).append(") from ").append(ajc_aroundClosure.entityClass()).append(' ').append(ajc_aroundClosure.entityName()).append(" where ").append(ajc_aroundClosure.entityName()).append(" in (").append((String)query).append(')');
        Query query3 = builder.createQuery(stringBuilder2.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)queryString).set(((Long)query3.getSingleResult()).intValue());
        return query2;
    }

    /*
     * WARNING - void declaration
     */
    private static final /* synthetic */ Query createQuery_aroundBody3$advice(LocalUserManager this_, EntityManager pageTarget, String entityManager, PagingAspect queryString, PageTarget ajc_aroundClosure, EntityManager entityManager2, String string, AroundClosure aroundClosure) {
        void query;
        void builder;
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)queryString).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)queryString).get() == null) {
            AroundClosure aroundClosure2 = aroundClosure;
            String string2 = string;
            EntityManager entityManager3 = entityManager2;
            PageTarget pageTarget2 = ajc_aroundClosure;
            return entityManager3.createQuery(string2);
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(" ORDER BY ").append(ajc_aroundClosure.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)queryString).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)queryString).get()).booleanValue()) {
            stringBuilder.append("ASC");
        } else {
            stringBuilder.append("DESC");
        }
        AroundClosure aroundClosure3 = aroundClosure;
        String string3 = stringBuilder.toString();
        void var18_15 = builder;
        PageTarget pageTarget3 = ajc_aroundClosure;
        Query query2 = ((EntityManager)var18_15).createQuery(string3);
        query2.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)queryString).get()).intValue());
        query2.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)queryString).get()).intValue());
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("select count(").append(ajc_aroundClosure.entityName()).append(") from ").append(ajc_aroundClosure.entityClass()).append(' ').append(ajc_aroundClosure.entityName()).append(" where ").append(ajc_aroundClosure.entityName()).append(" in (").append((String)query).append(')');
        Query query3 = builder.createQuery(stringBuilder2.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)queryString).set(((Long)query3.getSingleResult()).intValue());
        return query2;
    }
}

