/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.usermgmt.service.internal.IExternalUserManager;
import com.tandbergtv.neptune.usermgmt.service.internal.IInternalUserManager;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Stateless;

@Stateless
public class UserManager
implements IUserManager {
    @EJB
    IInternalUserManager internalManager;
    @EJB
    IExternalUserManager externalManager;
    @EJB
    IUserLdapContext userLdapContext;

    @RolesAllowed(value={"UserManagement_View"})
    public List<User> getUsers() {
        return this.getUserManager().getUsers();
    }

    @RolesAllowed(value={"UserManagement_View"})
    public User getUser(UserKey userKey) {
        return this.getUserManager().getUser(userKey);
    }

    @RolesAllowed(value={"UserManagement_View"})
    public User getUser(String userName) {
        return this.getUserManager().getUser(userName);
    }

    @RolesAllowed(value={"UserManagement_View"})
    public List<User> getUsersWithPermission(String moduleName, String permissionName) {
        return this.getUserManager().getUsersWithPermission(moduleName, permissionName);
    }

    @RolesAllowed(value={"UserManagement_Create"})
    public User createUser(User user) throws ValidationException {
        this.validate(user, true);
        return this.getUserManager().createUser(user);
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User updateUser(User user) throws ValidationException {
        this.validate(user, false);
        return this.getUserManager().updateUser(user);
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User updateUserWithPassword(User user) throws ValidationException {
        this.validate(user, true);
        return this.getUserManager().updateUserWithPassword(user);
    }

    @RolesAllowed(value={"UserManagement_Delete"})
    public boolean deleteUser(UserKey userKey) {
        return this.getUserManager().deleteUser(userKey);
    }

    @RolesAllowed(value={"UserManagement_Delete"})
    public boolean deleteUsers(UserKey ... userKeys) {
        return this.getUserManager().deleteUsers(userKeys);
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User setActiveStatus(UserKey userKey, boolean active) {
        return this.getUserManager().setActiveStatus(userKey, active);
    }

    @RolesAllowed(value={"UserManagement_View"})
    public boolean isReadOnly() {
        return this.getUserManager().isReadOnly();
    }

    private void validate(User user, boolean withPassword) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.isBlank(user.getUserName())) {
            validationMessages.add("User Name is required.");
        } else if (user.getUserName().length() < 3 || user.getUserName().length() > 16) {
            validationMessages.add("User Name must be between 3 and 16 characters.");
        }
        if (withPassword) {
            if (this.isBlank(user.getPassword())) {
                validationMessages.add("Password is required.");
            } else if (user.getPassword().length() < 6 || user.getPassword().length() > 16) {
                validationMessages.add("Password must be between 6 and 16 characters.");
            }
            if (!this.isBlank(user.getUserName()) && !this.isBlank(user.getPassword()) && user.getUserName().equalsIgnoreCase(user.getPassword())) {
                validationMessages.add("User Name and password cannot be the same, case-insensitive");
            }
        }
        if (user.getRoles().isEmpty()) {
            validationMessages.add("Roles is required.");
        }
        if (this.isBlank(user.getFirstName())) {
            validationMessages.add("First Name is required.");
        } else if (user.getFirstName().length() > 16) {
            validationMessages.add("First Name cannot exceed 16 characters.");
        }
        if (this.isBlank(user.getLastName())) {
            validationMessages.add("Last Name is required.");
        }
        if (this.isBlank(user.getEmail())) {
            validationMessages.add("Email is required.");
        } else if (!user.getEmail().matches("^.+@.+$")) {
            validationMessages.add("Email is not valid.");
        }
        if (this.isBlank(user.getEmployeeId())) {
            validationMessages.add("Employee ID is required.");
        }
        if (this.isBlank(user.getDepartment())) {
            validationMessages.add("Department is required.");
        }
        if (this.isBlank(user.getLocation())) {
            validationMessages.add("Location is required.");
        }
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private IUserManager getUserManager() {
        Object manager = null;
        manager = this.userLdapContext.isExternalUserModelEnabled() ? this.externalManager : this.internalManager;
        return manager;
    }
}

