/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.neptune.realm.ldap.conf.Entity;
import com.tandbergtv.neptune.realm.ldap.conf.EntityProperty;
import com.tandbergtv.neptune.realm.ldap.conf.Query;
import com.tandbergtv.neptune.realm.ldap.conf.SearchScope;
import com.tandbergtv.neptune.realm.ldap.service.IEntityService;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.rolemgmt.service.internal.IExternalRoleManager;
import com.tandbergtv.neptune.usermgmt.service.internal.IExternalUserManager;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import org.apache.log4j.Logger;

@Local(value={IExternalUserManager.class})
@Stateless
public class LDAPUserManager
implements IExternalUserManager {
    private static final Logger logger = Logger.getLogger(LDAPUserManager.class);
    @EJB
    protected IUserLdapContext userLdapContext;
    @EJB
    protected IExternalRoleManager roleManager;

    @RolesAllowed(value={"UserManagement_View"})
    public List<User> getUsers() {
        ArrayList<User> users = new ArrayList<User>();
        LdapContext context = null;
        try {
            context = this.userLdapContext.openContext();
            IEntityService entityService = this.userLdapContext.getEntityService();
            NamingEnumeration<SearchResult> results = this.search(context, "FindAll", null, null);
            while (results.hasMore()) {
                SearchResult result = results.next();
                User user = entityService.createUser(context, result);
                user.setRoles(this.roleManager.getRolesForUser(context, user.getUserKey()));
                users.add(user);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("Failed to get users using LdapContext.", ne);
        }
        finally {
            this.closeContext(context);
        }
        return users;
    }

    @RolesAllowed(value={"UserManagement_View", "NeptuneAuthenticator"})
    public User getUser(UserKey userKey) {
        String externalKey = userKey.getExternalKey();
        if (externalKey == null) {
            throw new RuntimeException("No user external key specified.");
        }
        User user = null;
        LdapContext context = null;
        try {
            context = this.userLdapContext.openContext();
            IEntityService entityService = this.userLdapContext.getEntityService();
            NamingEnumeration<SearchResult> results = this.search(context, "Find", externalKey, null);
            SearchResult searchResult = null;
            if (results.hasMore()) {
                searchResult = results.next();
                user = entityService.createUser(context, searchResult);
                user.setRoles(this.roleManager.getRolesForUser(context, user.getUserKey()));
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("Failed to get user using LdapContext.", ne);
        }
        finally {
            this.closeContext(context);
        }
        return user;
    }

    @RolesAllowed(value={"UserManagement_View"})
    public User getUser(String userName) {
        User user = null;
        LdapContext context = null;
        try {
            context = this.userLdapContext.openContext();
            IEntityService entityService = this.userLdapContext.getEntityService();
            String[] arguments = new String[]{userName};
            NamingEnumeration<SearchResult> results = this.search(context, "FindByUserName", null, arguments);
            SearchResult searchResult = null;
            if (results.hasMore()) {
                searchResult = results.next();
                user = entityService.createUser(context, searchResult);
                user.setRoles(this.roleManager.getRolesForUser(context, user.getUserKey()));
                if (results.hasMore()) {
                    String msg = "Found more than 1 user with same userName: " + userName;
                    throw new RuntimeException(msg);
                }
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("Failed to open LdapContext.", ne);
        }
        finally {
            this.closeContext(context);
        }
        return user;
    }

    @RolesAllowed(value={"UserManagement_View"})
    public List<User> getUsersWithPermission(String moduleName, String permissionName) {
        throw new UnsupportedOperationException();
    }

    @RolesAllowed(value={"UserManagement_Create"})
    public User createUser(User user) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User updateUser(User user) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User updateUserWithPassword(User user) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"UserManagement_Delete"})
    public boolean deleteUser(UserKey userKey) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"UserManagement_Delete"})
    public boolean deleteUsers(UserKey ... userKeys) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"UserManagement_Modify"})
    public User setActiveStatus(UserKey userKey, boolean active) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"UserManagement_View"})
    public boolean isReadOnly() {
        return true;
    }

    private Query getQuery(String name, List<Query> queries) {
        Query match = null;
        if (queries != null) {
            for (Query query : queries) {
                if (!name.equals(query.getName())) continue;
                match = query;
                break;
            }
        }
        return match;
    }

    private NamingEnumeration<SearchResult> search(LdapContext context, String queryName, String baseDN, String[] filterArguments) throws NamingException {
        IEntityService entityService = this.userLdapContext.getEntityService();
        Entity entity = entityService.getEntityConfiguration(User.class);
        Query query = this.getQuery(queryName, entity.getSearch().getQuery());
        SearchControls controls = new SearchControls();
        controls.setCountLimit(query.getSearchControl().getCountLimit());
        controls.setDerefLinkFlag(query.getSearchControl().isDerefLinkFlag());
        controls.setReturningObjFlag(query.getSearchControl().isReturningObjectFlag());
        controls.setSearchScope(this.translateSearchScope(query.getSearchControl().getSearchScope()));
        Integer timeLimit = query.getSearchControl().getTimeLimit();
        if (timeLimit == null) {
            timeLimit = entity.getSearch().getDefaultTimeLimit();
        }
        controls.setTimeLimit(timeLimit * 1000);
        controls.setReturningAttributes(this.getReturningAttributes(entity));
        if (baseDN == null) {
            baseDN = query.getBaseDN();
        }
        return context.search(baseDN, query.getFilter(), (Object[])filterArguments, controls);
    }

    private int translateSearchScope(SearchScope searchScope) {
        int scope = 0;
        switch (searchScope) {
            case OBJECT: {
                scope = 0;
                break;
            }
            case ONE_LEVEL: {
                scope = 1;
                break;
            }
            case SUBTREE: {
                scope = 2;
            }
        }
        return scope;
    }

    private String[] getReturningAttributes(Entity entity) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (EntityProperty property : entity.getProperties().getProperty()) {
            String attrName = property.getValue();
            if (attrName == null || attrName.trim().length() <= 0) continue;
            attributeNames.add(attrName.trim());
        }
        return attributeNames.toArray(new String[attributeNames.size()]);
    }

    private void closeContext(LdapContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failure closing the LdapContext.", (Throwable)e);
            }
        }
    }
}

