/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.rolemgmt.ejb;

import com.tandbergtv.neptune.realm.ldap.conf.Entity;
import com.tandbergtv.neptune.realm.ldap.conf.EntityProperty;
import com.tandbergtv.neptune.realm.ldap.conf.SearchScope;
import com.tandbergtv.neptune.realm.ldap.service.IEntityService;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.rolemgmt.service.internal.IExternalRoleManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Stateless;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.log4j.Logger;

@Local(value={IExternalRoleManager.class})
@Stateless
public class LDAPRoleManager
implements IExternalRoleManager {
    private static final Logger logger = Logger.getLogger(LDAPRoleManager.class);
    @EJB
    IUserLdapContext userLdapContext;
    @PersistenceContext(unitName="NeptuneRealm")
    protected EntityManager entityManager;

    @RolesAllowed(value={"RoleManagement_View"})
    public List<Role> getRoles() {
        ArrayList<Role> roles = new ArrayList<Role>();
        LdapContext context = null;
        try {
            context = this.userLdapContext.openContext();
            IEntityService entityService = this.userLdapContext.getEntityService();
            NamingEnumeration<SearchResult> results = this.search(context, "FindAll", null, null);
            while (results.hasMore()) {
                SearchResult result = results.next();
                Role role = entityService.createRole(context, result);
                this.readRolePermissions(role);
                roles.add(role);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("Failed to get roles using LdapContext.", ne);
        }
        finally {
            this.closeContext(context);
        }
        return roles;
    }

    @RolesAllowed(value={"RoleManagement_View"})
    public Role getRole(RoleKey roleKey) {
        String externalKey = roleKey.getExternalKey();
        if (externalKey == null) {
            throw new RuntimeException("No external key present for the role.");
        }
        Role role = null;
        LdapContext context = null;
        try {
            context = this.userLdapContext.openContext();
            IEntityService entityService = this.userLdapContext.getEntityService();
            NamingEnumeration<SearchResult> results = this.search(context, "Find", externalKey, null);
            SearchResult searchResult = null;
            if (results.hasMore()) {
                searchResult = results.next();
                role = entityService.createRole(context, searchResult);
                this.readRolePermissions(role);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("Failed to get role using LdapContext.", ne);
        }
        finally {
            this.closeContext(context);
        }
        return role;
    }

    @Override
    public Set<Role> getRolesForUser(LdapContext context, UserKey userKey) {
        HashSet<Role> roles = new HashSet<Role>();
        try {
            IEntityService entityService = this.userLdapContext.getEntityService();
            NamingEnumeration<SearchResult> results = this.search(context, "FindByUser", null, new String[]{userKey.getExternalKey()});
            while (results.hasMore()) {
                SearchResult result = results.next();
                Role role = entityService.createRole(context, result);
                this.readRolePermissions(role);
                roles.add(role);
            }
        }
        catch (NamingException ne) {
            throw new RuntimeException("Failed to get roles for user using LdapContext.", ne);
        }
        return roles;
    }

    @RolesAllowed(value={"RoleManagement_Create"})
    public Role createRole(Role role) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"RoleManagement_Modify"})
    public Role updateRole(Role role) {
        if (role.getExternalKey() == null) {
            throw new RuntimeException("Cannot update an external role with no external key.");
        }
        Integer userCount = role.getUserCount();
        if (role.getDescription() == null) {
            role.setDescription("");
        }
        role = (Role)this.entityManager.merge((Object)role);
        role.setUserCount(userCount);
        return role;
    }

    @RolesAllowed(value={"RoleManagement_Delete"})
    public boolean deleteRole(RoleKey roleKey) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"RoleManagement_Delete"})
    public boolean deleteRoles(RoleKey ... roleKeys) {
        throw new RuntimeException("This operation is not permitted.");
    }

    @RolesAllowed(value={"RoleManagement_View"})
    public boolean isReadOnly() {
        return true;
    }

    private void readRolePermissions(Role role) {
        if (role.getExternalKey() == null) {
            return;
        }
        Query query = this.entityManager.createNamedQuery("Role.FindByExternalKey");
        query.setParameter("externalKey", (Object)role.getExternalKey());
        try {
            Role persistedRole = (Role)query.getSingleResult();
            role.setId(persistedRole.getId());
            role.setPermissions(persistedRole.getPermissions());
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    private com.tandbergtv.neptune.realm.ldap.conf.Query getQuery(String name, List<com.tandbergtv.neptune.realm.ldap.conf.Query> queries) {
        com.tandbergtv.neptune.realm.ldap.conf.Query match = null;
        if (queries != null) {
            for (com.tandbergtv.neptune.realm.ldap.conf.Query query : queries) {
                if (!name.equals(query.getName())) continue;
                match = query;
                break;
            }
        }
        return match;
    }

    private NamingEnumeration<SearchResult> search(LdapContext context, String queryName, String baseDN, String[] filterArguments) throws NamingException {
        IEntityService entityService = this.userLdapContext.getEntityService();
        Entity entity = entityService.getEntityConfiguration(Role.class);
        com.tandbergtv.neptune.realm.ldap.conf.Query query = this.getQuery(queryName, entity.getSearch().getQuery());
        SearchControls controls = new SearchControls();
        controls.setCountLimit(query.getSearchControl().getCountLimit());
        controls.setDerefLinkFlag(query.getSearchControl().isDerefLinkFlag());
        controls.setReturningObjFlag(query.getSearchControl().isReturningObjectFlag());
        controls.setSearchScope(this.translateSearchScope(query.getSearchControl().getSearchScope()));
        Integer timeLimit = query.getSearchControl().getTimeLimit();
        if (timeLimit == null) {
            timeLimit = entity.getSearch().getDefaultTimeLimit();
        }
        controls.setTimeLimit(timeLimit * 1000);
        controls.setReturningAttributes(this.getReturningAttributes(entity));
        if (baseDN == null) {
            baseDN = query.getBaseDN();
        }
        return context.search(baseDN, query.getFilter(), (Object[])filterArguments, controls);
    }

    private int translateSearchScope(SearchScope searchScope) {
        int scope = 0;
        switch (searchScope) {
            case OBJECT: {
                scope = 0;
                break;
            }
            case ONE_LEVEL: {
                scope = 1;
                break;
            }
            case SUBTREE: {
                scope = 2;
            }
        }
        return scope;
    }

    private String[] getReturningAttributes(Entity entity) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (EntityProperty property : entity.getProperties().getProperty()) {
            String attrName = property.getValue();
            if (attrName == null || attrName.trim().length() <= 0) continue;
            attributeNames.add(attrName.trim());
        }
        return attributeNames.toArray(new String[attributeNames.size()]);
    }

    private void closeContext(LdapContext context) {
        if (context != null) {
            try {
                context.close();
            }
            catch (Exception e) {
                logger.warn((Object)"Failure closing the LdapContext.", (Throwable)e);
            }
        }
    }
}

