/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.configuration.ejb;

import com.tandbergtv.neptune.configuration.entity.ProductInfo;
import com.tandbergtv.neptune.configuration.service.IConfigurationService;
import com.tandbergtv.neptune.configuration.service.ILifecycleConfigurationService;
import com.tandbergtv.neptune.util.PropertyFileReader;
import java.io.File;
import java.util.Map;
import javax.annotation.security.PermitAll;
import org.apache.log4j.Logger;
import org.jboss.ejb3.annotation.Service;

@PermitAll
@Service
public class ConfigurationService
implements IConfigurationService,
ILifecycleConfigurationService {
    private String confFolderLocation;
    private static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    private static final String CONFIG_FOLDER_RELATIVE_PATH = "conf";
    private static final String PRODUCT_FILE = "product.properties";
    private static final Logger logger = Logger.getLogger(ConfigurationService.class);
    private static ProductInfo productInfo = null;

    @Override
    public void start() throws Exception {
        File configFolder = new File(System.getProperty(INSTALL_FOLDER_PROPERTY), CONFIG_FOLDER_RELATIVE_PATH);
        this.confFolderLocation = configFolder.getAbsolutePath();
        this.readProductInfo(this.getInstallDirectory());
        logger.debug((Object)("confFolderLocation=" + this.confFolderLocation));
    }

    private void readProductInfo(String installDir) {
        File productFile = new File(installDir, PRODUCT_FILE);
        if (productFile.exists()) {
            Map properties = PropertyFileReader.readProperties((File)productFile);
            productInfo = new ProductInfo(properties);
        } else {
            logger.warn((Object)("[Configuration Error] product.properties " + installDir + "file is not present"));
            productInfo = new ProductInfo();
        }
        logger.info((Object)("[software version] " + this.removeHTMLTags(productInfo.getProductTitle()) + " " + productInfo.getProductVersion()));
    }

    public File getFile(String relativeFolderPath, String filename) {
        if (relativeFolderPath != null && !relativeFolderPath.equals("")) {
            File folderLocation = new File(this.confFolderLocation, relativeFolderPath);
            logger.debug((Object)("final folderLocation=" + folderLocation.getAbsolutePath()));
            return new File(folderLocation, filename);
        }
        return new File(this.confFolderLocation, filename);
    }

    public String getInstallDirectory() {
        return System.getProperty(INSTALL_FOLDER_PROPERTY);
    }

    public File getFile(String relativeFilePath) {
        return new File(this.confFolderLocation, relativeFilePath);
    }

    public ProductInfo getProductInfo() {
        return productInfo;
    }

    private String removeHTMLTags(String str) {
        return str.replaceAll("\\<.*&?>", "");
    }
}

