/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.usermgmt.ejb;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.cms.portal.util.paging.PagingAspect;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.User;
import com.tandbergtv.neptune.realm.persist.UserKey;
import com.tandbergtv.neptune.usermgmt.service.IUserManager;
import com.tandbergtv.neptune.usermgmt.service.IUserValidityService;
import com.tandbergtv.neptune.usermgmt.service.UserValidationException;
import com.tandbergtv.neptune.usermgmt.service.internal.IExternalUserManager;
import com.tandbergtv.neptune.usermgmt.service.internal.IInternalUserManager;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.aspectj.runtime.internal.AroundClosure;

@Stateless
@TransactionAttribute
public class UserManager
implements IUserManager {
    @EJB
    IInternalUserManager internalManager;
    @EJB
    IExternalUserManager externalManager;
    @EJB
    IUserLdapContext userLdapContext;
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;
    private static final String ALPHABET_PATTERN = "(.*)([a-zA-Z]+)(.*)";
    private static final String NUMERIC_PATTERN = "(.*)([0-9]+)(.*)";
    private static final int PASSWORD_LENGTH = 8;

    public List<User> getUsers() {
        return this.getUserManager().getUsers();
    }

    public User getUser(UserKey userKey) {
        return this.getUserManager().getUser(userKey);
    }

    public User getUser(String userName) {
        return this.getUserManager().getUser(userName);
    }

    public List<User> getUsersWithPermission(String moduleName, String permissionName) {
        return this.getUserManager().getUsersWithPermission(moduleName, permissionName);
    }

    public User createUser(User user) throws ValidationException {
        this.validate(user, true);
        return this.getUserManager().createUser(user);
    }

    public User updateUser(User user) throws ValidationException {
        this.validate(user, false);
        return this.getUserManager().updateUser(user);
    }

    public User updateUserWithPassword(User user) throws ValidationException {
        this.validate(user, true);
        return this.getUserManager().updateUserWithPassword(user);
    }

    public boolean deleteUser(UserKey userKey) {
        return this.getUserManager().deleteUser(userKey);
    }

    public boolean deleteUsers(UserKey ... userKeys) {
        return this.getUserManager().deleteUsers(userKeys);
    }

    public User setActiveStatus(UserKey userKey, boolean active) {
        return this.getUserManager().setActiveStatus(userKey, active);
    }

    public boolean isReadOnly() {
        return this.getUserManager().isReadOnly();
    }

    public boolean isReadOnly(User user) {
        return this.getUserManager().isReadOnly(user);
    }

    private void validate(User user, boolean withPassword) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.isReadOnly(user)) {
            validationMessages.add("User is read-only.");
        }
        if (this.isBlank(user.getUserName())) {
            validationMessages.add("User Name is required.");
        } else if (user.getUserName().length() < 3 || user.getUserName().length() > 16) {
            validationMessages.add("User Name must be between 3 and 16 characters.");
        }
        User existingUser = this.getUser(user.getUserName());
        if (existingUser != null && !existingUser.getUserKey().equals((Object)user.getUserKey())) {
            validationMessages.add("User Name already exists.");
        }
        if (withPassword) {
            this.validatePassword(user.getPassword(), validationMessages);
            if (!this.isBlank(user.getUserName()) && !this.isBlank(user.getPassword()) && user.getUserName().equalsIgnoreCase(user.getPassword())) {
                validationMessages.add("User Name and password cannot be the same, case-insensitive");
            }
        }
        if (user.getRoles().isEmpty()) {
            validationMessages.add("Roles is required.");
        }
        if (this.isBlank(user.getFirstName())) {
            validationMessages.add("First Name is required.");
        } else if (user.getFirstName().length() > 16) {
            validationMessages.add("First Name cannot exceed 16 characters.");
        }
        if (this.isBlank(user.getLastName())) {
            validationMessages.add("Last Name is required.");
        }
        if (this.isBlank(user.getEmail())) {
            validationMessages.add("Email is required.");
        } else if (!user.getEmail().matches("^.+@.+$")) {
            validationMessages.add("Email is not valid.");
        }
        if (!this.isBlank(user.getUserName())) {
            for (Role role : user.getRoles()) {
                String string = "SELECT role FROM Role role WHERE role.id = :roleId";
                EntityManager entityManager = this.entityManager;
                Query query = PagingAspect.ajc$cflowStack$0.isValid() ? UserManager.createQuery_aroundBody1$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
                query.setParameter("roleId", (Object)role.getId());
                List roles = query.getResultList();
                user.setRoles(new HashSet(roles));
                this.validateWithComponents(user, validationMessages);
            }
        }
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private void validateWithComponents(User user, List<String> validationMessages) {
        ServiceLoader<IUserValidityService> userValidityLoader = ServiceLoader.load(IUserValidityService.class);
        if (userValidityLoader != null) {
            for (IUserValidityService userValidityProvider : userValidityLoader) {
                try {
                    userValidityProvider.validate(user);
                }
                catch (UserValidationException e) {
                    validationMessages.add(e.getLocalizedMessage());
                }
            }
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private IUserManager getUserManager() {
        Object manager = null;
        manager = this.userLdapContext.isExternalUserModelEnabled() ? this.externalManager : this.internalManager;
        return manager;
    }

    private void validatePassword(String password, List<String> validationMessages) {
        if (this.isBlank(password)) {
            validationMessages.add("Password is required.");
        } else {
            if (password != null && password.trim().length() < 8 || password.length() > 16) {
                validationMessages.add("Password must be between 8 and 16 characters.");
            }
            if (!this.hasAtleastOneAlphabet(password)) {
                validationMessages.add("Password must contain at least one alphabet.");
            }
            if (!this.hasAtleastOneDigit(password)) {
                validationMessages.add("Password must contain at least one digit.");
            }
        }
    }

    public static void main(String[] a) {
        String s1 = "3#$%$#^sdfdssd";
        System.out.println("Alhpabet present " + new UserManager().hasAtleastOneAlphabet(s1));
        System.out.println("Digit present " + new UserManager().hasAtleastOneDigit(s1));
    }

    private boolean hasAtleastOneAlphabet(String s) {
        return s.matches(ALPHABET_PATTERN);
    }

    private boolean hasAtleastOneDigit(String s) {
        return s.matches(NUMERIC_PATTERN);
    }

    private static final /* synthetic */ Query createQuery_aroundBody1$advice(UserManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }
}

