/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.rolemgmt.ejb;

import com.tandbergtv.cms.portal.util.paging.PageTarget;
import com.tandbergtv.cms.portal.util.paging.PagingAspect;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.Permission;
import com.tandbergtv.neptune.realm.persist.Role;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.rolemgmt.service.IRoleManager;
import com.tandbergtv.neptune.rolemgmt.service.IRoleValidityService;
import com.tandbergtv.neptune.rolemgmt.service.RoleValidationException;
import com.tandbergtv.neptune.rolemgmt.service.internal.IExternalRoleManager;
import com.tandbergtv.neptune.rolemgmt.service.internal.IInternalRoleManager;
import com.tandbergtv.neptune.validation.ValidationException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import javax.ejb.EJB;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.aspectj.runtime.internal.AroundClosure;

@Stateless
@TransactionAttribute
public class RoleManager
implements IRoleManager {
    @EJB
    IInternalRoleManager internalManager;
    @EJB
    IExternalRoleManager externalManager;
    @EJB
    IUserLdapContext userLdapContext;
    @PersistenceContext(unitName="NeptuneRealm")
    private EntityManager entityManager;

    public List<Role> getRoles() {
        return this.getRoleManager().getRoles();
    }

    public Role getRole(RoleKey roleKey) {
        return this.getRoleManager().getRole(roleKey);
    }

    public Role getRole(String name) {
        return this.getRoleManager().getRole(name);
    }

    public Role createRole(Role role) throws ValidationException {
        this.validate(role);
        return this.getRoleManager().createRole(role);
    }

    public Role updateRole(Role role) throws ValidationException {
        this.validate(role);
        return this.getRoleManager().updateRole(role);
    }

    public boolean deleteRole(RoleKey roleKey) throws ValidationException {
        Integer userCount = this.getRole(roleKey).getUserCount();
        if (userCount != null && userCount > 0) {
            ArrayList<String> validationMessages = new ArrayList<String>();
            validationMessages.add("There are Users associated with this Role");
            throw new ValidationException(validationMessages);
        }
        return this.getRoleManager().deleteRole(roleKey);
    }

    public boolean deleteRoles(RoleKey ... roleKeys) {
        return this.getRoleManager().deleteRoles(roleKeys);
    }

    public Role assignAllPermissions(RoleKey roleKey) {
        return this.getRoleManager().assignAllPermissions(roleKey);
    }

    public boolean isReadOnly() {
        return this.getRoleManager().isReadOnly();
    }

    public boolean isReadOnly(Role role) {
        return this.getRoleManager().isReadOnly(role);
    }

    private void validateWithComponents(Role role, List<String> validationMessages) throws ValidationException {
        String string = "SELECT permission FROM Permission permission";
        EntityManager entityManager = this.entityManager;
        Query query = PagingAspect.ajc$cflowStack$0.isValid() ? RoleManager.createQuery_aroundBody1$advice(this, entityManager, string, PagingAspect.aspectOf(), (PageTarget)PagingAspect.ajc$cflowStack$0.get(0), entityManager, string, null) : entityManager.createQuery(string);
        List permissions = query.getResultList();
        HashMap<Long, Permission> permissionIdMap = new HashMap<Long, Permission>();
        for (Permission perm : permissions) {
            permissionIdMap.put(perm.getId(), perm);
        }
        HashSet<Permission> completePermissionInfo = new HashSet<Permission>();
        for (Permission perm : role.getPermissions()) {
            Permission completePermission = (Permission)permissionIdMap.get(perm.getId());
            completePermissionInfo.add(completePermission);
        }
        role.setPermissions(completePermissionInfo);
        ServiceLoader<IRoleValidityService> roleValidityLoader = ServiceLoader.load(IRoleValidityService.class);
        if (roleValidityLoader != null) {
            for (IRoleValidityService roleValidityProvider : roleValidityLoader) {
                try {
                    roleValidityProvider.validate(role);
                }
                catch (RoleValidationException e) {
                    validationMessages.add(e.getLocalizedMessage());
                }
            }
        }
    }

    private void validate(Role role) throws ValidationException {
        ArrayList<String> validationMessages = new ArrayList<String>();
        if (this.isReadOnly(role)) {
            validationMessages.add("Role is read-only.");
        }
        if (!this.getRoleManager().isReadOnly()) {
            Role existingRole;
            if (this.isBlank(role.getName())) {
                validationMessages.add("Name is required.");
            }
            if ((existingRole = this.getRole(role.getName())) != null && !existingRole.getRoleKey().equals((Object)role.getRoleKey())) {
                validationMessages.add("Name already exists.");
            }
        }
        this.validateWithComponents(role, validationMessages);
        if (!validationMessages.isEmpty()) {
            throw new ValidationException(validationMessages);
        }
    }

    private boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    private IRoleManager getRoleManager() {
        Object manager = null;
        manager = this.userLdapContext.isExternalUserModelEnabled() ? this.externalManager : this.internalManager;
        return manager;
    }

    private static final /* synthetic */ Query createQuery_aroundBody1$advice(RoleManager this_, EntityManager target, String arg0, PagingAspect ajc$aspectInstance, PageTarget pageTarget, EntityManager entityManager, String queryString, AroundClosure ajc$aroundClosure) {
        if (PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get() == null || PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get() == null) {
            AroundClosure aroundClosure = ajc$aroundClosure;
            String string = queryString;
            EntityManager entityManager2 = entityManager;
            PageTarget pageTarget2 = pageTarget;
            return entityManager2.createQuery(string);
        }
        StringBuilder builder = new StringBuilder(queryString);
        builder.append(" ORDER BY ").append(pageTarget.entityName()).append('.').append((String)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_sortBy((PagingAspect)ajc$aspectInstance).get()).append(' ');
        if (((Boolean)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_isAscending((PagingAspect)ajc$aspectInstance).get()).booleanValue()) {
            builder.append("ASC");
        } else {
            builder.append("DESC");
        }
        AroundClosure aroundClosure = ajc$aroundClosure;
        String string = builder.toString();
        EntityManager entityManager3 = entityManager;
        PageTarget pageTarget3 = pageTarget;
        Query query = entityManager3.createQuery(string);
        query.setFirstResult(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_start((PagingAspect)ajc$aspectInstance).get()).intValue());
        query.setMaxResults(((Integer)PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_length((PagingAspect)ajc$aspectInstance).get()).intValue());
        StringBuilder countQueryBuilder = new StringBuilder();
        countQueryBuilder.append("select count(").append(pageTarget.entityName()).append(") from ").append(pageTarget.entityClass()).append(' ').append(pageTarget.entityName()).append(" where ").append(pageTarget.entityName()).append(" in (").append(queryString).append(')');
        Query countQuery = entityManager.createQuery(countQueryBuilder.toString());
        PagingAspect.ajc$inlineAccessFieldGet$com_tandbergtv_cms_portal_util_paging_PagingAspect$com_tandbergtv_cms_portal_util_paging_PagingAspect$_count((PagingAspect)ajc$aspectInstance).set(((Long)countQuery.getSingleResult()).intValue());
        return query;
    }
}

