/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.conf;

import com.tandbergtv.neptune.realm.conf.IRealmConfigurationService;
import com.tandbergtv.neptune.realm.conf.RealmConfigurationException;
import com.tandbergtv.neptune.realm.conf.RealmConfigurationReader;
import com.tandbergtv.neptune.realm.ldap.service.IUserLdapContext;
import com.tandbergtv.neptune.realm.persist.RoleKey;
import com.tandbergtv.neptune.realm.persist.UserKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.ejb.EJB;
import org.jboss.ejb3.annotation.Depends;
import org.jboss.ejb3.annotation.Service;

@Depends(value={"Neptune:service=com.tandbergtv.neptune.configuration.service.IConfigurationService"})
@Service(objectName="Neptune:service=com.tandbergtv.neptune.realm.conf.IRealmConfigurationService")
public class RealmConfigurationService
implements IRealmConfigurationService {
    @EJB
    private IUserLdapContext userLdapContext;
    private RealmConfigurationReader configurationReader = new RealmConfigurationReader();
    private Properties configuration = null;
    private String filePath;
    private static final String PROPS = "./neptune_realm.properties";

    @Override
    public void start() throws Exception {
        try {
            this.configuration = this.configurationReader.readRealmConfiguration(PROPS);
        }
        catch (Exception e) {
            String msg = "[Configuration Error] ./neptune_realm.properties is missing, error: " + e.getLocalizedMessage();
            throw new RealmConfigurationException(msg, e);
        }
    }

    @Override
    public Properties getConfiguration() {
        return this.configuration;
    }

    @Override
    public List<UserKey> getReadOnlyUserKeys() throws RealmConfigurationException {
        ArrayList<UserKey> userKeys = new ArrayList<UserKey>();
        String value = this.configuration.getProperty("NeptuneRealm.ReadOnlyUserIDs");
        List<String> allValues = this.getValues(value, ",");
        for (String userIDValue : allValues) {
            try {
                Long userID = new Long(userIDValue);
                userKeys.add(new UserKey(userID, null));
            }
            catch (RuntimeException e) {
                String msg = "[Configuration Error] NeptuneRealm.ReadOnlyUserIDs " + this.filePath + " failed to parse the list of read only user IDs, " + "value: " + userIDValue + " is not a valid user ID.";
                throw new RealmConfigurationException(msg, e);
            }
        }
        return userKeys;
    }

    @Override
    public List<RoleKey> getAdministratorRoleKeys() throws RealmConfigurationException {
        ArrayList<RoleKey> roleKeys = new ArrayList<RoleKey>();
        boolean externalEnabled = this.userLdapContext.isExternalUserModelEnabled();
        String key = externalEnabled ? "NeptuneRealm.AdministratorRoleExternalKeys" : "NeptuneRealm.AdministratorRoleIDs";
        String value = this.configuration.getProperty(key);
        String separator = externalEnabled ? "|" : ",";
        List<String> allValues = this.getValues(value, separator);
        for (String roleKeyValue : allValues) {
            RoleKey roleKey = new RoleKey();
            if (externalEnabled) {
                roleKey.setExternalKey(roleKeyValue);
            } else {
                try {
                    Long roleId = new Long(roleKeyValue);
                    roleKey.setId(roleId);
                }
                catch (Exception e) {
                    String msg = "[Configuration Error] " + key + " " + this.filePath + " failed to parse the list of administrator role IDs, " + "value: " + roleKeyValue + " is not a valid role ID.";
                    throw new RealmConfigurationException(msg, e);
                }
            }
            roleKeys.add(roleKey);
        }
        return roleKeys;
    }

    private List<String> getValues(String valueList, String separator) {
        String[] values;
        ArrayList<String> allValues = new ArrayList<String>();
        if (valueList != null && (values = valueList.split(separator)) != null) {
            for (String value : values) {
                if (value == null || (value = value.trim()).length() <= 0) continue;
                allValues.add(value);
            }
        }
        return allValues;
    }
}

