/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.neptune.realm.ldap.ejb;

import com.tandbergtv.neptune.realm.ldap.conf.ConnectionConfiguration;
import com.tandbergtv.neptune.realm.ldap.conf.Property;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

public class LdapContextFactory {
    protected ConnectionConfiguration configuration;

    protected LdapContextFactory(ConnectionConfiguration configuration) {
        this.configuration = configuration;
    }

    public static LdapContextFactory newInstance(ConnectionConfiguration configuration) {
        return new LdapContextFactory(configuration);
    }

    public LdapContext newLdapContext() throws NamingException {
        List<Property> connectionProperties = this.configuration.getProperty();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        if (connectionProperties != null) {
            for (Property connectionProperty : connectionProperties) {
                String name = connectionProperty.getName();
                String value = connectionProperty.getValue();
                environment.put(name, value);
            }
        }
        return new InitialLdapContext(environment, null);
    }

    public LdapContext newLdapContext(Map<String, String> overrideEnvironment) throws NamingException {
        Hashtable<String, String> environment = this.buildEnvironment(overrideEnvironment);
        return new InitialLdapContext(environment, null);
    }

    private Hashtable<String, String> buildEnvironment() {
        List<Property> connectionProperties = this.configuration.getProperty();
        Hashtable<String, String> environment = new Hashtable<String, String>();
        if (connectionProperties != null) {
            for (Property connectionProperty : connectionProperties) {
                String name = connectionProperty.getName();
                String value = connectionProperty.getValue();
                environment.put(name, value);
            }
        }
        return environment;
    }

    private Hashtable<String, String> buildEnvironment(Map<String, String> override) {
        Hashtable<String, String> environment = this.buildEnvironment();
        if (override != null) {
            environment.putAll(override);
        }
        return environment;
    }
}

